/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.Secret;
import java.io.IOException;
import java.security.KeyPair;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.ssh.jce.KeyFormat;
import net.adamcin.httpsig.ssh.jce.SSHKey;
import net.adamcin.httpsig.ssh.jce.UserKeysFingerprintKeyId;
import org.apache.commons.lang.StringUtils;

abstract class GraniteNamedIdCredentials
implements IdCredentials {
    private static final Logger LOGGER = Logger.getLogger(GraniteNamedIdCredentials.class.getName());
    private static final long serialVersionUID = -7611025520557823267L;

    GraniteNamedIdCredentials() {
    }

    @CheckForNull
    public static Credentials getCredentialsById(String credentialsId) {
        if (GraniteNamedIdCredentials.sanityCheck() && StringUtils.isNotBlank((String)credentialsId)) {
            CredentialsIdMatcher matcher = new CredentialsIdMatcher(credentialsId);
            List credentialsList = DomainCredentials.getCredentials((Map)SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), Credentials.class, Collections.emptyList(), (CredentialsMatcher)matcher);
            if (!credentialsList.isEmpty()) {
                return (Credentials)credentialsList.iterator().next();
            }
        }
        return null;
    }

    public static Credentials getCredentialsFromURIUserInfo(String userInfo, Credentials toOverride) {
        if (GraniteNamedIdCredentials.sanityCheck() && userInfo != null && !userInfo.isEmpty()) {
            if (userInfo.indexOf(58) >= 0) {
                String[] parts = userInfo.split(":", 2);
                return new URIUserInfoCredentials(parts[0], parts[1], null);
            }
            if (toOverride instanceof SSHUserPrivateKey) {
                return new URIUserInfoCredentialsWithSSHKey(userInfo, (SSHUserPrivateKey)toOverride);
            }
            if (toOverride instanceof StandardUsernamePasswordCredentials) {
                return new URIUserInfoCredentials(userInfo, null, (StandardUsernamePasswordCredentials)toOverride);
            }
            return new URIUserInfoCredentials(userInfo, null, null);
        }
        return null;
    }

    private static boolean sanityCheck() {
        return Jenkins.getInstance() != null;
    }

    public CredentialsScope getScope() {
        return this.getWrappedCredentials().getScope();
    }

    protected abstract Credentials getWrappedCredentials();

    public abstract String getName();

    @NonNull
    public CredentialsDescriptor getDescriptor() {
        return this.getWrappedCredentials().getDescriptor();
    }

    @NonNull
    public static GraniteNamedIdCredentials wrap(SSHUserPrivateKey creds) {
        return new SSHPrivateKeyNamedIdCredentials(creds);
    }

    @NonNull
    public static GraniteNamedIdCredentials wrap(StandardUsernamePasswordCredentials creds) {
        return new UserPassNamedIdCredentials(creds);
    }

    @CheckForNull
    public static GraniteNamedIdCredentials maybeWrap(@CheckForNull Credentials creds) {
        if (creds instanceof StandardUsernamePasswordCredentials) {
            return GraniteNamedIdCredentials.wrap((StandardUsernamePasswordCredentials)creds);
        }
        if (creds instanceof SSHUserPrivateKey) {
            return GraniteNamedIdCredentials.wrap((SSHUserPrivateKey)creds);
        }
        return null;
    }

    public static Keychain getKeychainFromCredentials(@CheckForNull SSHUserPrivateKey creds) {
        ArrayList<SSHKey> keys = new ArrayList<SSHKey>();
        if (creds == null) {
            return new DefaultKeychain(keys);
        }
        char[] passphrase = null;
        Secret cPPhrase = creds.getPassphrase();
        if (cPPhrase != null) {
            passphrase = cPPhrase.getEncryptedValue().toCharArray();
        }
        for (String pk : creds.getPrivateKeys()) {
            try {
                PEMEncodable enc = PEMEncodable.decode((String)pk, (char[])passphrase);
                KeyPair keyPair = enc.toKeyPair();
                if (keyPair == null) continue;
                if (keyPair.getPrivate() instanceof RSAPrivateKey || keyPair.getPublic() instanceof RSAPublicKey) {
                    keys.add(new SSHKey(KeyFormat.SSH_RSA, keyPair));
                    continue;
                }
                if (!(keyPair.getPrivate() instanceof DSAPrivateKey) && !(keyPair.getPublic() instanceof DSAPublicKey)) continue;
                keys.add(new SSHKey(KeyFormat.SSH_DSS, keyPair));
            }
            catch (UnrecoverableKeyException e) {
                LOGGER.severe("[getKeyFromCredentials] failed to decode key from SSHUserPrivateKey: " + e.getMessage());
            }
            catch (IOException e) {
                LOGGER.severe("[getKeyFromCredentials] failed to read key from SSHUserPrivateKey: " + e.getMessage());
            }
        }
        return new DefaultKeychain(keys);
    }

    @CheckForNull
    public static Key getKeyFromCredentials(@CheckForNull SSHUserPrivateKey creds) {
        Keychain keys;
        if (creds != null && !(keys = GraniteNamedIdCredentials.getKeychainFromCredentials(creds)).isEmpty()) {
            return keys.currentKey();
        }
        return null;
    }

    private static class CredentialsIdMatcher
    implements CredentialsMatcher {
        final String credentialsId;

        private CredentialsIdMatcher(String credentialsId) {
            this.credentialsId = credentialsId;
        }

        public boolean matches(@NonNull Credentials item) {
            if (this.credentialsId != null && !this.credentialsId.isEmpty()) {
                if (item instanceof SSHUserPrivateKey) {
                    return this.credentialsId.equals(((SSHUserPrivateKey)item).getId());
                }
                if (item instanceof IdCredentials) {
                    return this.credentialsId.equals(((IdCredentials)item).getId());
                }
            }
            return false;
        }
    }

    static class URIUserInfoCredentialsWithSSHKey
    extends BaseStandardCredentials
    implements SSHUserPrivateKey {
        private String username;
        private SSHUserPrivateKey wrapped;

        URIUserInfoCredentialsWithSSHKey(String username, SSHUserPrivateKey wrapped) {
            super("URIUserInfoCredentialsWithSSHKey_" + username, "");
            if (username == null) {
                throw new NullPointerException("username");
            }
            if (wrapped == null) {
                throw new NullPointerException("wrapped");
            }
            this.username = username;
            this.wrapped = wrapped;
        }

        @NonNull
        public List<String> getPrivateKeys() {
            return this.wrapped.getPrivateKeys();
        }

        @NonNull
        public String getPrivateKey() {
            return this.wrapped.getPrivateKey();
        }

        public Secret getPassphrase() {
            return this.wrapped.getPassphrase();
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }
    }

    static class URIUserInfoCredentials
    extends BaseStandardCredentials
    implements StandardUsernamePasswordCredentials {
        private String username;
        private Secret password;
        private StandardUsernamePasswordCredentials wrapped;

        URIUserInfoCredentials(String username, String password, StandardUsernamePasswordCredentials wrapped) {
            super("URIUserInfoCredentials_" + username, "");
            if (username == null) {
                throw new NullPointerException("username");
            }
            this.username = username;
            this.password = password == null || password.isEmpty() ? null : Secret.fromString((String)password);
            this.wrapped = wrapped;
        }

        @NonNull
        public String getUsername() {
            return this.username;
        }

        @NonNull
        public Secret getPassword() {
            if (this.password != null) {
                return this.password;
            }
            if (this.wrapped != null) {
                return this.wrapped.getPassword();
            }
            return Secret.fromString((String)"admin");
        }
    }

    static class UserPassNamedIdCredentials
    extends GraniteNamedIdCredentials {
        private static final long serialVersionUID = -7566342113168803477L;
        private final StandardUsernamePasswordCredentials wrapped;

        UserPassNamedIdCredentials(StandardUsernamePasswordCredentials wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return CredentialsNameProvider.name((Credentials)this.wrapped);
        }

        @Override
        protected Credentials getWrappedCredentials() {
            return this.wrapped;
        }

        @NonNull
        public String getId() {
            return this.wrapped.getId();
        }
    }

    static class SSHPrivateKeyNamedIdCredentials
    extends GraniteNamedIdCredentials {
        private static final long serialVersionUID = -8908675817671402062L;
        private final SSHUserPrivateKey wrapped;

        SSHPrivateKeyNamedIdCredentials(SSHUserPrivateKey wrapped) {
            this.wrapped = wrapped;
        }

        @NonNull
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public String getName() {
            Keychain keychain = SSHPrivateKeyNamedIdCredentials.getKeychainFromCredentials(this.wrapped);
            if (keychain.isEmpty()) {
                return "[Signature] <failed to read SSH key> " + this.getId();
            }
            UserKeysFingerprintKeyId keyId = new UserKeysFingerprintKeyId(this.wrapped.getUsername());
            StringBuilder nameBuilder = new StringBuilder("[Signature] ").append(keyId.getId(keychain.currentKey()));
            if (!this.wrapped.getDescription().trim().isEmpty()) {
                nameBuilder.append(" (").append(this.wrapped.getDescription()).append(")");
            }
            return nameBuilder.toString();
        }

        @Override
        protected Credentials getWrappedCredentials() {
            return this.wrapped;
        }
    }
}

