/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.security.ACL;
import java.util.Collections;
import java.util.List;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.graniteclient.GraniteNamedIdCredentials;

public class GraniteCredentialsListBoxModel
extends AbstractIdCredentialsListBoxModel<GraniteCredentialsListBoxModel, IdCredentials> {
    private static final long serialVersionUID = 6621529150670191090L;

    @NonNull
    protected String describe(@NonNull IdCredentials idCredentials) {
        if (idCredentials instanceof GraniteNamedIdCredentials) {
            return ((GraniteNamedIdCredentials)idCredentials).getName();
        }
        return CredentialsNameProvider.name((Credentials)idCredentials);
    }

    public static AbstractIdCredentialsListBoxModel fillItems(String currentValue, Item context) {
        return GraniteCredentialsListBoxModel.fillItems(currentValue, context, Collections.emptyList());
    }

    public static AbstractIdCredentialsListBoxModel fillItems(String currentValue, Item context, String baseUrl) {
        if (baseUrl != null) {
            return GraniteCredentialsListBoxModel.fillItems(currentValue, context, URIRequirementBuilder.fromUri((String)baseUrl).build());
        }
        return GraniteCredentialsListBoxModel.fillItems(currentValue, context);
    }

    private static AbstractIdCredentialsListBoxModel fillItems(String currentValue, Item context, List<DomainRequirement> reqs) {
        List basicAuthCredsList;
        AbstractIdCredentialsListBoxModel model = new GraniteCredentialsListBoxModel().withEmptySelection();
        if (context == null || !context.hasPermission(Item.CONFIGURE)) {
            Credentials _credentials = GraniteNamedIdCredentials.getCredentialsById(currentValue);
            return model.with((IdCredentials)GraniteNamedIdCredentials.maybeWrap(_credentials));
        }
        List keys = CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (Item)context, (Authentication)ACL.SYSTEM, reqs);
        if (!keys.isEmpty()) {
            for (SSHUserPrivateKey key : keys) {
                model = model.with((IdCredentials)GraniteNamedIdCredentials.wrap(key));
            }
        }
        if (!(basicAuthCredsList = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, reqs)).isEmpty()) {
            for (StandardUsernamePasswordCredentials creds : basicAuthCredsList) {
                model = model.with((IdCredentials)GraniteNamedIdCredentials.wrap(creds));
            }
        }
        return model;
    }
}

