/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.Credentials;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;

public class GraniteClientGlobalConfig
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(GraniteClientGlobalConfig.class.getName());
    private static final TaskListener DEFAULT_LISTENER = new LogTaskListener(LOGGER, Level.INFO);
    private static final long serialVersionUID = 2713710297120024271L;
    public static final int DEFAULT_TIMEOUT = 60000;
    private final Credentials defaultCredentials;
    private final String preemptLoginForBaseUrls;
    private final int connectionTimeoutInMs;
    private final int idleConnectionTimeoutInMs;
    private final int requestTimeoutInMs;
    private final ProxyConfiguration proxy;

    public GraniteClientGlobalConfig(Credentials defaultCredentials, String preemptLoginForBaseUrls, int connectionTimeoutInMs, int idleConnectionTimeoutInMs, int requestTimeoutInMs, ProxyConfiguration proxy) {
        this.defaultCredentials = defaultCredentials;
        this.preemptLoginForBaseUrls = preemptLoginForBaseUrls;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.proxy = proxy;
    }

    public Credentials getDefaultCredentials() {
        return this.defaultCredentials;
    }

    public String getPreemptLoginForBaseUrls() {
        return this.preemptLoginForBaseUrls;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public int getIdleConnectionTimeoutInMs() {
        return this.idleConnectionTimeoutInMs;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public AsyncHttpClient getInstance() {
        return new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setProxyServer(this.getProxyServer()).setConnectTimeout(this.connectionTimeoutInMs > 0 ? this.connectionTimeoutInMs : 60000).setReadTimeout(this.idleConnectionTimeoutInMs > 0 ? this.idleConnectionTimeoutInMs : 60000).setRequestTimeout(this.requestTimeoutInMs > 0 ? this.requestTimeoutInMs : 60000).build());
    }

    public ProxyServer getProxyServer() {
        ProxyServer proxyServer = this.proxy != null ? new ProxyServer(this.proxy.name, this.proxy.port, this.proxy.getUserName(), this.proxy.getPassword()) : null;
        return proxyServer;
    }

    public boolean shouldPreemptLoginForBaseUrl(String baseUrl, @CheckForNull TaskListener _listener) {
        TaskListener listener;
        TaskListener taskListener = listener = _listener != null ? _listener : DEFAULT_LISTENER;
        if (baseUrl != null && !baseUrl.trim().isEmpty()) {
            boolean matched = false;
            try {
                List<Pattern> patterns = GraniteClientGlobalConfig.getPreemptLoginPatterns(this.getPreemptLoginForBaseUrls());
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(baseUrl).find()) continue;
                    matched = true;
                }
            }
            catch (PatternSyntaxException e) {
                listener.getLogger().printf("[WARN] exception encountered when attempting to compile Preempt Login patterns: %n%s%n", e.getMessage());
            }
            return matched;
        }
        return false;
    }

    public static List<Pattern> getPreemptLoginPatterns(String _patterns) throws PatternSyntaxException {
        String[] patterns;
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        if (_patterns == null) {
            return compiled;
        }
        for (String pattern : patterns = _patterns.split("\\r?\\n")) {
            if (pattern.trim().isEmpty()) continue;
            compiled.add(Pattern.compile(pattern, 2));
        }
        return compiled;
    }
}

