/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.adamcin.granite.client.packman.PackageManagerClient;
import net.adamcin.granite.client.packman.async.AsyncPackageManagerClient;
import net.adamcin.httpsig.api.KeyId;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.Signer;
import net.adamcin.httpsig.http.ning.AsyncUtil;
import net.adamcin.httpsig.ssh.jce.UserKeysFingerprintKeyId;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientGlobalConfig;
import org.jenkinsci.plugins.graniteclient.GraniteNamedIdCredentials;
import org.jenkinsci.plugins.graniteclient.PackageManagerClientCallable;

public final class GraniteClientExecutor {
    private static final Logger LOGGER = Logger.getLogger(GraniteClientExecutor.class.getName());
    private static final TaskListener DEFAULT_LISTENER = new LogTaskListener(LOGGER, Level.INFO);
    private static final AsyncCompletionHandler<Boolean> LOGIN_HANDLER = new AsyncCompletionHandler<Boolean>(){

        public Boolean onCompleted(Response response) throws Exception {
            return response.getStatusCode() == 405 || response.getStatusCode() == 200;
        }
    };

    public static <T> T execute(PackageManagerClientCallable<T> callable, GraniteClientConfig config) throws Exception {
        return GraniteClientExecutor.execute(callable, config, null);
    }

    public static <T> T execute(PackageManagerClientCallable<T> callable, GraniteClientConfig config, TaskListener _listener) throws Exception {
        TaskListener listener = _listener != null ? _listener : DEFAULT_LISTENER;
        GraniteClientGlobalConfig globalConfig = config.getGlobalConfig();
        try (AsyncHttpClient ahcClient = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setProxyServer(globalConfig.getProxyServer()).setConnectTimeout(globalConfig.getConnectionTimeoutInMs()).setReadTimeout(config.getServiceTimeout() > 0L ? (int)config.getServiceTimeout() : globalConfig.getIdleConnectionTimeoutInMs()).setRequestTimeout(config.getRequestTimeout() > 0L ? (int)config.getRequestTimeout() : globalConfig.getRequestTimeoutInMs()).build());){
            AsyncPackageManagerClient client = new AsyncPackageManagerClient(ahcClient);
            boolean preemptLogin = GraniteClientExecutor.isPreemptLogin(config, listener);
            client.setBaseUrl(config.getBaseUrl());
            client.setRequestTimeout(config.getRequestTimeout());
            client.setServiceTimeout(config.getServiceTimeout());
            client.setWaitDelay(config.getWaitDelay());
            if (GraniteClientExecutor.doLogin(client, config.getCredentials(), preemptLogin, listener, globalConfig.getDefaultCredentials())) {
                T t = callable.doExecute((PackageManagerClient)client);
                return t;
            }
            throw new IOException("Failed to login to " + config.getBaseUrl());
        }
    }

    private static boolean doLogin(AsyncPackageManagerClient client, Credentials credentials, boolean preemptLogin, TaskListener listener, Credentials defaultCredentials) throws IOException {
        Credentials _creds;
        Credentials credentials2 = _creds = credentials != null ? credentials : defaultCredentials;
        if (_creds instanceof SSHUserPrivateKey) {
            if (preemptLogin) {
                listener.getLogger().printf("[ALERT] Ignoring preemptive auth preference for HTTP Signature scheme.%n", new Object[0]).flush();
            }
            return GraniteClientExecutor.doLoginSignature(client, (SSHUserPrivateKey)_creds, listener);
        }
        if (_creds instanceof UsernamePasswordCredentials) {
            String username = ((UsernamePasswordCredentials)_creds).getUsername();
            String password = ((UsernamePasswordCredentials)_creds).getPassword().getPlainText();
            if (preemptLogin) {
                client.preemptLogin(username, password);
                listener.getLogger().printf("[ALERT] Preemptive basic auth enabled for URL %s%n", client.getBaseUrl()).flush();
                try {
                    return client.waitForService();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Unexpected exception during preemptive auth check.", e);
                }
            }
            return GraniteClientExecutor.doLoginPOST(client, username, password, listener);
        }
        if (preemptLogin) {
            client.preemptLogin("admin", "admin");
            listener.getLogger().printf("[ALERT] Preemptive basic auth enabled for URL %s%n", client.getBaseUrl()).flush();
            try {
                return client.waitForService();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Unexpected exception during preemptive auth check.", e);
            }
        }
        return GraniteClientExecutor.doLoginPOST(client, "admin", "admin", listener);
    }

    private static boolean doLoginSignature(AsyncPackageManagerClient client, SSHUserPrivateKey key, TaskListener listener) throws IOException {
        Keychain sshkeys = GraniteNamedIdCredentials.getKeychainFromCredentials(key);
        if (sshkeys.isEmpty()) {
            return false;
        }
        UserKeysFingerprintKeyId keyId = new UserKeysFingerprintKeyId(key.getUsername());
        Signer signer = new Signer(sshkeys, (KeyId)keyId);
        Future fResponse = AsyncUtil.login((AsyncHttpClient)client.getClient(), (Signer)signer, (Request)client.getClient().prepareGet(client.getBaseUrl() + "?sling:authRequestLogin=Signature&j_validate=true").build(), LOGIN_HANDLER);
        try {
            if (client.getServiceTimeout() > 0L) {
                return (Boolean)fResponse.get(client.getServiceTimeout(), TimeUnit.MILLISECONDS);
            }
            return (Boolean)fResponse.get();
        }
        catch (Exception e) {
            throw new IOException("Failed to login using HTTP Signature authentication.", e);
        }
    }

    private static boolean doLoginPOST(AsyncPackageManagerClient client, String username, String password, TaskListener listener) throws IOException {
        return client.login(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateBaseUrl(GraniteClientConfig config) throws IOException {
        TaskListener listener = DEFAULT_LISTENER;
        try (AsyncHttpClient asyncHttpClient = config.getGlobalConfig().getInstance();){
            AsyncPackageManagerClient client = new AsyncPackageManagerClient(asyncHttpClient);
            client.setBaseUrl(config.getBaseUrl());
            client.setRequestTimeout(config.getRequestTimeout());
            client.setServiceTimeout(config.getServiceTimeout());
            client.setWaitDelay(config.getWaitDelay());
            boolean bl = GraniteClientExecutor.doLogin(client, config.getCredentials(), GraniteClientExecutor.isPreemptLogin(config, listener), listener, config.getGlobalConfig().getDefaultCredentials());
            return bl;
        }
    }

    static boolean isPreemptLogin(GraniteClientConfig config, TaskListener _listener) {
        TaskListener listener = _listener != null ? _listener : DEFAULT_LISTENER;
        return config.getGlobalConfig().shouldPreemptLoginForBaseUrl(config.getBaseUrl(), listener);
    }
}

