/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUser;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.graniteclient.GraniteClientGlobalConfig;
import org.jenkinsci.plugins.graniteclient.GraniteNamedIdCredentials;

public final class GraniteClientConfig
implements Serializable {
    private static final long serialVersionUID = 2713710297119924271L;
    private static final List<String> ignorableSuffixes = Arrays.asList("/", "/crx", "/crx/packmgr", "/crx/packmgr/service.jsp");
    private final GraniteClientGlobalConfig globalConfig;
    private final String baseUrl;
    private final String credentialsId;
    private final long requestTimeout;
    private final long serviceTimeout;
    private final long waitDelay;
    private final String urlUserInfo;
    private Credentials credentials;
    private boolean resolvedCredentials;
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("(https?://)([^/]+)($|/.*)");

    static String trimUrl(@CheckForNull String value) {
        String trimmed = value == null ? "" : value.trim();
        for (String ignorableSuffix : ignorableSuffixes) {
            if (!trimmed.endsWith(ignorableSuffix)) continue;
            trimmed = trimmed.substring(0, trimmed.length() - ignorableSuffix.length());
        }
        return trimmed;
    }

    public GraniteClientConfig(@Nonnull GraniteClientGlobalConfig globalConfig, String baseUrl, String credentialsId) {
        this(globalConfig, baseUrl, credentialsId, 0L, 0L, 0L);
    }

    public GraniteClientConfig(@Nonnull GraniteClientGlobalConfig globalConfig, String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout) {
        this(globalConfig, baseUrl, credentialsId, requestTimeout, serviceTimeout, 0L);
    }

    public GraniteClientConfig(@Nonnull GraniteClientGlobalConfig globalConfig, String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout, long waitDelay) {
        this.globalConfig = globalConfig;
        this.credentialsId = credentialsId;
        this.requestTimeout = requestTimeout > 0L ? requestTimeout : -1L;
        this.serviceTimeout = serviceTimeout > 0L ? serviceTimeout : -1L;
        this.waitDelay = waitDelay > 0L ? waitDelay : -1L;
        String _baseUrl = GraniteClientConfig.sanitizeUrl(baseUrl);
        String _urlUserInfo = null;
        try {
            URI baseUri = new URI(_baseUrl);
            if (baseUri.getUserInfo() != null) {
                _urlUserInfo = baseUri.getUserInfo();
                URI changed = new URI(baseUri.getScheme(), null, baseUri.getHost(), baseUri.getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
                _baseUrl = changed.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.baseUrl = _baseUrl;
        this.urlUserInfo = _urlUserInfo;
    }

    public void resolveCredentials() {
        Credentials _credentials = GraniteNamedIdCredentials.getCredentialsById(this.credentialsId);
        if (_credentials == null) {
            _credentials = this.globalConfig.getDefaultCredentials();
        }
        this.credentials = this.urlOverrideCredentials(_credentials);
        this.resolvedCredentials = true;
    }

    public GraniteClientGlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean isSignatureLogin() {
        return this.credentials instanceof SSHUserPrivateKey;
    }

    public Credentials getCredentials() {
        if (!this.resolvedCredentials) {
            throw new AssertionError((Object)"Credentials were not resolved");
        }
        return this.credentials;
    }

    public String getUsername() {
        if (this.credentials instanceof SSHUser) {
            return ((SSHUser)this.credentials).getUsername();
        }
        if (this.credentials instanceof UsernameCredentials) {
            return ((UsernameCredentials)this.credentials).getUsername();
        }
        return "admin";
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    public String getUrlUserInfo() {
        return this.urlUserInfo;
    }

    public Credentials urlOverrideCredentials(Credentials toOverride) {
        if (this.getUrlUserInfo() != null) {
            return GraniteNamedIdCredentials.getCredentialsFromURIUserInfo(this.getUrlUserInfo(), toOverride);
        }
        return toOverride;
    }

    public static String sanitizeUrl(String url) {
        String _url = GraniteClientConfig.trimUrl(url).replaceAll("\\$\\{\\w*\\}?", "");
        Matcher urlMatcher = HTTP_URL_PATTERN.matcher(_url);
        if (urlMatcher.find()) {
            StringBuilder sb = new StringBuilder(urlMatcher.group(1));
            String authority = urlMatcher.group(2);
            int lastAt = authority.lastIndexOf(64);
            if (lastAt >= 0) {
                String host = authority.substring(lastAt);
                String rawUserInfo = authority.substring(0, lastAt);
                int firstColon = rawUserInfo.indexOf(58);
                if (firstColon >= 0) {
                    String rawUsername = rawUserInfo.substring(0, firstColon);
                    String rawPassword = rawUserInfo.substring(firstColon + 1);
                    sb.append(GraniteClientConfig.urlEscape(rawUsername)).append(":").append(GraniteClientConfig.urlEscape(rawPassword));
                } else {
                    sb.append(GraniteClientConfig.urlEscape(rawUserInfo));
                }
                sb.append(host);
            } else {
                sb.append(authority);
            }
            _url = sb.append(urlMatcher.group(3)).toString();
        }
        return _url;
    }

    private static String urlEscape(String raw) {
        return raw.replaceAll("%(?![A-Fa-f0-9]{2})", "%25").replace(" ", "%20").replace("!", "%21").replace("#", "%23").replace("$", "%24").replace("&", "%26").replace("'", "%27").replace("(", "%28").replace(")", "%29").replace("*", "%2A").replace("+", "%2B").replace(",", "%2C").replace("/", "%2F").replace(":", "%3A").replace(";", "%3B").replace("=", "%3D").replace("?", "%3F").replace("@", "%40").replace("[", "%5B").replace("]", "%5D");
    }
}

