/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.graniteclient.GraniteClientGlobalConfig;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.graniteclient.GraniteNamedIdCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class GraniteAHCFactory
extends Descriptor<GraniteAHCFactory>
implements Describable<GraniteAHCFactory>,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(GraniteAHCFactory.class.getName());
    private static final TaskListener DEFAULT_LISTENER = new LogTaskListener(LOGGER, Level.INFO);
    private static final long serialVersionUID = 1329103722879551701L;
    private static final int DEFAULT_TIMEOUT = 60000;
    private String credentialsId;
    private String preemptLoginForBaseUrls;
    private int connectionTimeoutInMs = 60000;
    private int idleConnectionTimeoutInMs = 60000;
    private int requestTimeoutInMs = 60000;

    public GraniteAHCFactory() {
        super(GraniteAHCFactory.class);
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json.getJSONObject("GraniteAHCFactory"));
        this.save();
        return true;
    }

    public Descriptor<GraniteAHCFactory> getDescriptor() {
        return GraniteAHCFactory.getFactoryDescriptor();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getPreemptLoginForBaseUrls() {
        return this.preemptLoginForBaseUrls;
    }

    public void setPreemptLoginForBaseUrls(String preemptLoginForBaseUrls) {
        this.preemptLoginForBaseUrls = preemptLoginForBaseUrls;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeoutInMs;
    }

    public void setConnectionTimeoutInMs(int connectionTimeoutInMs) {
        this.connectionTimeoutInMs = connectionTimeoutInMs;
    }

    public int getIdleConnectionTimeoutInMs() {
        return this.idleConnectionTimeoutInMs;
    }

    public void setIdleConnectionTimeoutInMs(int idleConnectionTimeoutInMs) {
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public void setRequestTimeoutInMs(int requestTimeoutInMs) {
        this.requestTimeoutInMs = requestTimeoutInMs;
    }

    public String getDisplayName() {
        return "CRX Content Package Deployer - HTTP Client";
    }

    public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="value") String value) {
        return GraniteCredentialsListBoxModel.fillItems(value, context);
    }

    public Credentials getDefaultCredentials() {
        if (this.credentialsId != null) {
            return GraniteNamedIdCredentials.getCredentialsById(this.credentialsId);
        }
        return null;
    }

    public FormValidation doCheckPreemptLoginForBaseUrls(@QueryParameter String value) throws IOException, ServletException {
        try {
            List<Pattern> patterns = GraniteClientGlobalConfig.getPreemptLoginPatterns(value);
            return FormValidation.ok();
        }
        catch (PatternSyntaxException e) {
            return FormValidation.error((String)"Invalid regular expression: %n%s%n", (Object[])new Object[]{e.getMessage()});
        }
    }

    private static Descriptor<GraniteAHCFactory> getFactoryDescriptor() {
        Jenkins j = Jenkins.getActiveInstance();
        return j.getDescriptorOrDie(GraniteAHCFactory.class);
    }

    public static GraniteAHCFactory getFactoryInstance() {
        return GraniteAHCFactory.getFactoryInstance(Jenkins.getActiveInstance());
    }

    public static GraniteAHCFactory getFactoryInstance(@Nonnull Jenkins jenkins) {
        Descriptor descriptor = jenkins.getDescriptorOrDie(GraniteAHCFactory.class);
        if (descriptor instanceof GraniteAHCFactory) {
            GraniteAHCFactory factory = (GraniteAHCFactory)descriptor;
            factory.load();
            return factory;
        }
        throw new AssertionError((Object)("Incompatible descriptor: " + descriptor.getJsonSafeClassName()));
    }

    public GraniteClientGlobalConfig createGlobalConfig() {
        GraniteClientGlobalConfig globalConfig = new GraniteClientGlobalConfig(this.getDefaultCredentials(), this.getPreemptLoginForBaseUrls(), this.getConnectionTimeoutInMs(), this.getIdleConnectionTimeoutInMs(), this.getRequestTimeoutInMs(), GraniteAHCFactory.getProxyConfig());
        return globalConfig;
    }

    public static GraniteClientGlobalConfig getGlobalConfig() {
        GraniteAHCFactory factory = GraniteAHCFactory.getFactoryInstance();
        return factory.createGlobalConfig();
    }

    public static ProxyConfiguration getProxyConfig() {
        Jenkins j = Jenkins.getActiveInstance();
        if (j != null && j.proxy != null) {
            return j.proxy;
        }
        return null;
    }
}

