/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.adamcin.granite.client.packman.DetailedResponse;
import net.adamcin.granite.client.packman.DownloadResponse;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.PackageManagerClient;
import net.adamcin.granite.client.packman.ResponseProgressListener;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;
import org.jenkinsci.plugins.graniteclient.GraniteClientFileCallable;
import org.jenkinsci.plugins.graniteclient.JenkinsResponseProgressListener;
import org.jenkinsci.plugins.graniteclient.PackageManagerClientCallable;

public class DownloadPackagesCallable
extends GraniteClientFileCallable<Result> {
    private static final long serialVersionUID = 5909791609148794746L;
    protected final GraniteClientConfig clientConfig;
    protected final TaskListener listener;
    private final List<PackId> packIds;
    private final boolean ignoreErrors;
    private final boolean rebuild;
    private final ResponseProgressListener progressListener;

    public DownloadPackagesCallable(GraniteClientConfig clientConfig, TaskListener listener, List<PackId> packIds, boolean ignoreErrors, boolean rebuild) {
        this.clientConfig = clientConfig;
        this.listener = listener;
        this.packIds = packIds;
        this.ignoreErrors = ignoreErrors;
        this.rebuild = rebuild;
        this.progressListener = new JenkinsResponseProgressListener(listener);
    }

    public Result invoke(File toDirectory, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            return GraniteClientExecutor.execute(new Execution(toDirectory), this.clientConfig, this.listener);
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.fatalError("Failed to download packages.", new Object[]{e.getMessage()}));
            if (this.ignoreErrors) {
                return Result.UNSTABLE;
            }
            return Result.FAILURE;
        }
    }

    private class Execution
    implements PackageManagerClientCallable<Result> {
        final File toDirectory;

        private Execution(File toDirectory) {
            this.toDirectory = toDirectory;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Result doExecute(PackageManagerClient client) throws Exception {
            Result result = Result.SUCCESS;
            for (PackId packId : DownloadPackagesCallable.this.packIds) {
                client.waitForService();
                DownloadPackagesCallable.this.listener.getLogger().printf("Checking for package %s on server %s%n", packId, DownloadPackagesCallable.this.clientConfig.getBaseUrl());
                if (client.existsOnServer(packId)) {
                    DownloadPackagesCallable.this.listener.getLogger().printf("Found package: %s%n", client.getConsoleUiUrl(packId));
                    if (DownloadPackagesCallable.this.rebuild) {
                        DownloadPackagesCallable.this.listener.getLogger().printf("Rebuilding %s.%n", packId);
                        DetailedResponse r_rebuild = client.build(packId, DownloadPackagesCallable.this.progressListener);
                        if (!r_rebuild.isSuccess()) {
                            DownloadPackagesCallable.this.listener.error(r_rebuild.getMessage());
                            if (!DownloadPackagesCallable.this.ignoreErrors) return Result.FAILURE;
                            result = result.combine(Result.UNSTABLE);
                        } else if (r_rebuild.hasErrors()) {
                            result = result.combine(Result.UNSTABLE);
                        }
                    }
                    DownloadPackagesCallable.this.listener.getLogger().printf("Downloading %s to %s%n", packId, this.toDirectory);
                    DownloadResponse response = client.downloadToDirectory(packId, this.toDirectory);
                    DownloadPackagesCallable.this.listener.getLogger().printf("Downloaded %d bytes to file %s.%n", response.getLength(), response.getContent());
                    DownloadPackagesCallable.this.listener.getLogger().printf("Verifying downloaded package...%n", new Object[0]);
                    PackId reId = PackId.identifyPackage((File)response.getContent());
                    if (!packId.equals((Object)reId)) throw new Exception("Package verification failed: " + response.getContent());
                    DownloadPackagesCallable.this.listener.getLogger().printf("Package verified as %s.%n", packId);
                    continue;
                }
                DownloadPackagesCallable.this.listener.error("Package %s does not exist on server.", new Object[]{packId});
                if (!DownloadPackagesCallable.this.ignoreErrors) return Result.FAILURE;
                result = Result.UNSTABLE.combine(result);
            }
            return result;
        }
    }
}

