/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.adamcin.granite.client.packman.PackId;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.graniteclient.AbstractBuildStep;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.DownloadPackagesCallable;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DownloadPackagesBuilder
extends AbstractBuildStep {
    private String packageIds;
    private String baseUrl;
    private String credentialsId = null;
    private long requestTimeout = 0L;
    private long serviceTimeout = 0L;
    private long waitDelay = 0L;
    private String localDirectory = null;
    private boolean ignoreErrors = false;
    private boolean rebuild = false;

    @DataBoundConstructor
    public DownloadPackagesBuilder(String packageIds, String baseUrl) {
        this.packageIds = packageIds;
        this.baseUrl = baseUrl;
    }

    public DownloadPackagesBuilder(String packageIds, String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout, long waitDelay, String localDirectory, boolean ignoreErrors, boolean rebuild) {
        this.packageIds = packageIds;
        this.baseUrl = baseUrl;
        this.credentialsId = credentialsId;
        this.requestTimeout = requestTimeout;
        this.serviceTimeout = serviceTimeout;
        this.waitDelay = waitDelay;
        this.localDirectory = localDirectory;
        this.ignoreErrors = ignoreErrors;
        this.rebuild = rebuild;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        GraniteClientConfig clientConfig = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), this.getBaseUrl(build, workspace, listener), this.credentialsId, this.requestTimeout, this.serviceTimeout, this.waitDelay);
        clientConfig.resolveCredentials();
        DownloadPackagesCallable callable = new DownloadPackagesCallable(clientConfig, listener, this.listPackIds(build, workspace, listener), this.ignoreErrors, this.rebuild);
        String fLocalDirectory = this.getLocalDirectory(build, workspace, listener);
        Result actResult = (Result)workspace.child(fLocalDirectory).act((FilePath.FileCallable)callable);
        if (actResult != null) {
            result = result.combine(actResult);
        }
        build.setResult(result);
    }

    public String getPackageIds() {
        if (this.packageIds != null) {
            return this.packageIds.trim();
        }
        return "";
    }

    public String getPackageIds(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPackageIds());
        }
        catch (MacroEvaluationException e) {
            listener.error("Failed to expand macros in Package ID: %s", new Object[]{this.getPackageIds()});
            return this.getPackageIds();
        }
    }

    private String getBaseUrl(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getBaseUrl());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getBaseUrl()});
            return this.getBaseUrl();
        }
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = StringUtils.isBlank((String)credentialsId) ? null : credentialsId;
    }

    private String getLocalDirectory(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getLocalDirectory());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getLocalDirectory()});
            return this.getLocalDirectory();
        }
    }

    public List<PackId> listPackIds(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<PackId> packIds = new ArrayList<PackId>();
        for (String packageId : BaseUrlUtil.splitByNewline(this.getPackageIds(build, workspace, listener))) {
            PackId packId = PackId.parsePid((String)packageId);
            if (packId == null) continue;
            packIds.add(packId);
        }
        return Collections.unmodifiableList(packIds);
    }

    public String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl.trim();
        }
        return "";
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    @DataBoundSetter
    public void setWaitDelay(long waitDelay) {
        this.waitDelay = waitDelay;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public String getLocalDirectory() {
        if (StringUtils.isBlank((String)this.localDirectory)) {
            return ".";
        }
        return this.localDirectory;
    }

    @DataBoundSetter
    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    @DataBoundSetter
    public void setPackageIds(String packageIds) {
        this.packageIds = packageIds;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @DataBoundSetter
    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    @DataBoundSetter
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @DataBoundSetter
    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"crxDownload"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="value") String value) {
            return GraniteCredentialsListBoxModel.fillItems(value, context, baseUrl);
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="requestTimeout") long requestTimeout, @QueryParameter(value="serviceTimeout") long serviceTimeout) throws IOException, ServletException {
            return BaseUrlUtil.testOneConnection(baseUrl, credentialsId, requestTimeout, serviceTimeout);
        }

        public String getDisplayName() {
            return "Download Content Packages from CRX";
        }
    }
}

