/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.MasterToSlaveFileCallable;
import net.adamcin.granite.client.packman.ACHandling;
import net.adamcin.granite.client.packman.PackId;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.graniteclient.AbstractBuildStep;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.DeployPackageCallable;
import org.jenkinsci.plugins.graniteclient.ExistingPackageBehavior;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.graniteclient.IdentifyPackageCallable;
import org.jenkinsci.plugins.graniteclient.PackageInstallOptions;
import org.jenkinsci.plugins.graniteclient.PathOrPackIdFilter;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class DeployPackagesBuilder
extends AbstractBuildStep {
    private String packageIdFilters;
    private String baseUrls;
    private String credentialsId = null;
    private String localDirectory = null;
    private String behavior = null;
    private boolean recursive = false;
    private boolean replicate = false;
    private int autosave = 1024;
    private String acHandling = null;
    private boolean disableForJobTesting = false;
    private long requestTimeout = 0L;
    private long serviceTimeout = 0L;
    private long waitDelay = 0L;

    @DataBoundConstructor
    public DeployPackagesBuilder(@Nonnull String packageIdFilters, @Nonnull String baseUrls) {
        this.packageIdFilters = packageIdFilters;
        this.baseUrls = baseUrls;
    }

    public DeployPackagesBuilder(String packageIdFilters, String baseUrls, String credentialsId, String localDirectory, String behavior, boolean recursive, boolean replicate, int autosave, String acHandling, boolean disableForJobTesting, long requestTimeout, long serviceTimeout, long waitDelay) {
        this.packageIdFilters = packageIdFilters;
        this.baseUrls = baseUrls;
        this.credentialsId = credentialsId;
        this.localDirectory = localDirectory;
        this.behavior = behavior;
        this.recursive = recursive;
        this.replicate = replicate;
        this.autosave = autosave;
        this.acHandling = acHandling;
        this.disableForJobTesting = disableForJobTesting;
        this.requestTimeout = requestTimeout;
        this.serviceTimeout = serviceTimeout;
        this.waitDelay = waitDelay;
    }

    public String getPackageIdFilters() {
        if (this.packageIdFilters != null) {
            return this.packageIdFilters.trim();
        }
        return "";
    }

    @DataBoundSetter
    public void setPackageIdFilters(@Nonnull String packageIdFilters) {
        this.packageIdFilters = packageIdFilters;
    }

    public String getBaseUrls() {
        if (this.baseUrls != null) {
            return this.baseUrls.trim();
        }
        return "";
    }

    @DataBoundSetter
    public void setBaseUrls(String baseUrls) {
        this.baseUrls = baseUrls;
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = StringUtils.isBlank((String)credentialsId) ? null : credentialsId;
    }

    public String getLocalDirectory() {
        if (StringUtils.isBlank((String)this.localDirectory)) {
            return ".";
        }
        return this.localDirectory.trim();
    }

    @DataBoundSetter
    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public String getBehavior() {
        return this.behavior;
    }

    @DataBoundSetter
    public void setBehavior(String behavior) {
        this.behavior = behavior;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    @DataBoundSetter
    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @DataBoundSetter
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public int getAutosave() {
        return this.autosave;
    }

    @DataBoundSetter
    public void setAutosave(int autosave) {
        this.autosave = autosave;
    }

    public String getAcHandling() {
        if (this.acHandling == null) {
            return "_DEFER";
        }
        return this.acHandling.toUpperCase();
    }

    @DataBoundSetter
    public void setAcHandling(String acHandling) {
        this.acHandling = "_DEFER".equals(acHandling) ? null : acHandling;
    }

    public boolean isDisableForJobTesting() {
        return this.disableForJobTesting;
    }

    @DataBoundSetter
    public void setDisableForJobTesting(boolean disableForJobTesting) {
        this.disableForJobTesting = disableForJobTesting;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    @DataBoundSetter
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    @DataBoundSetter
    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    @DataBoundSetter
    public void setWaitDelay(long waitDelay) {
        this.waitDelay = waitDelay;
    }

    public PackageInstallOptions getPackageInstallOptions() {
        ACHandling _acHandling = null;
        if (this.getAcHandling() != null && !"_DEFER".equals(this.getAcHandling())) {
            if (ACHandling.IGNORE.name().equals(this.getAcHandling())) {
                _acHandling = ACHandling.IGNORE;
            } else if (ACHandling.MERGE.name().equals(this.getAcHandling())) {
                _acHandling = ACHandling.MERGE;
            } else if (ACHandling.MERGE_PRESERVE.name().equals(this.getAcHandling())) {
                _acHandling = ACHandling.MERGE_PRESERVE;
            } else if (ACHandling.OVERWRITE.name().equals(this.getAcHandling())) {
                _acHandling = ACHandling.OVERWRITE;
            } else if (ACHandling.CLEAR.name().equals(this.getAcHandling())) {
                _acHandling = ACHandling.CLEAR;
            }
        }
        return new PackageInstallOptions(this.isRecursive(), this.getAutosave(), _acHandling, this.isReplicate());
    }

    public ExistingPackageBehavior getExistingPackageBehavior() {
        ExistingPackageBehavior _behavior = ExistingPackageBehavior.IGNORE;
        if (this.getBehavior() != null) {
            if ("uninstall".equalsIgnoreCase(this.getBehavior())) {
                _behavior = ExistingPackageBehavior.UNINSTALL;
            } else if ("delete".equalsIgnoreCase(this.getBehavior())) {
                _behavior = ExistingPackageBehavior.DELETE;
            } else if ("overwrite".equalsIgnoreCase(this.getBehavior())) {
                _behavior = ExistingPackageBehavior.OVERWRITE;
            } else if ("skip".equalsIgnoreCase(this.getBehavior())) {
                _behavior = ExistingPackageBehavior.SKIP;
            }
        }
        return _behavior;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        if (this.disableForJobTesting) {
            listener.getLogger().println("DEBUG: *** package deployment disabled for testing ***");
        }
        for (String baseUrl : this.listBaseUrls(build, workspace, listener)) {
            if (!result.isBetterOrEqualTo(Result.UNSTABLE)) continue;
            GraniteClientConfig clientConfig = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), baseUrl, this.credentialsId, this.requestTimeout, this.serviceTimeout, this.waitDelay);
            clientConfig.resolveCredentials();
            listener.getLogger().printf("Deploying packages to %s%n", clientConfig.getBaseUrl());
            for (Map.Entry<PackId, FilePath> selectedPackage : this.selectPackages(build, workspace, listener).entrySet()) {
                if (!result.isBetterOrEqualTo(Result.UNSTABLE)) {
                    return;
                }
                MasterToSlaveFileCallable callable = null;
                callable = this.disableForJobTesting ? new DebugPackageCallable(selectedPackage.getKey(), listener) : new DeployPackageCallable(clientConfig, listener, selectedPackage.getKey(), this.getPackageInstallOptions(), this.getExistingPackageBehavior());
                Result actResult = (Result)selectedPackage.getValue().act((FilePath.FileCallable)callable);
                if (actResult != null) {
                    result = result.combine(actResult);
                }
                build.setResult(result);
            }
        }
    }

    private Map<PackId, FilePath> selectPackages(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, final @Nonnull TaskListener listener) throws IOException, InterruptedException {
        HashMap<PackId, FilePath> found = new HashMap<PackId, FilePath>();
        String fLocalDirectory = this.getLocalDirectory(build, workspace, listener);
        FilePath dir = workspace.child(fLocalDirectory);
        try {
            ArrayList<FilePath> listed = new ArrayList<FilePath>();
            listed.addAll(Arrays.asList(dir.list("**/*.jar")));
            listed.addAll(Arrays.asList(dir.list("**/*.zip")));
            Collections.sort(listed, Collections.reverseOrder(new Comparator<FilePath>(){

                @Override
                public int compare(FilePath left, FilePath right) {
                    try {
                        return Long.compare(left.lastModified(), right.lastModified());
                    }
                    catch (Exception e) {
                        listener.error("Failed to compare a couple files: %s", new Object[]{e.getMessage()});
                        return 0;
                    }
                }
            }));
            for (FilePath filePath : listed) {
                PackId packId = (PackId)filePath.act((FilePath.FileCallable)new IdentifyPackageCallable());
                if (packId == null || found.containsKey(packId)) continue;
                found.put(packId, filePath);
            }
        }
        catch (Exception e) {
            listener.error("Failed to list package files: %s", new Object[]{e.getMessage()});
        }
        LinkedHashMap selected = new LinkedHashMap();
        for (Map.Entry<String, PathOrPackIdFilter> entry : this.listPackageFilters(build, workspace, listener).entrySet()) {
            boolean matched = false;
            for (Map.Entry entry2 : found.entrySet()) {
                if (!entry.getValue().includes((PackId)entry2.getKey()) && !entry.getValue().includes(dir, (FilePath)entry2.getValue())) continue;
                matched = true;
                if (selected.containsKey(entry2.getKey())) continue;
                selected.put(entry2.getKey(), entry2.getValue());
            }
            if (matched) continue;
            throw new IOException("No package found matching filter " + entry.getKey());
        }
        HashMap groupings = new HashMap();
        for (PackId packId : found.keySet()) {
            String groupKey = packId.getGroup() + ":" + packId.getName();
            if (!groupings.containsKey(groupKey)) {
                groupings.put(groupKey, new ArrayList());
            }
            ((List)groupings.get(groupKey)).add(packId);
        }
        HashSet hashSet = new HashSet();
        for (List grouping : groupings.values()) {
            Collections.sort(grouping, Collections.reverseOrder());
            hashSet.add(grouping.get(0));
        }
        selected.keySet().retainAll(hashSet);
        return Collections.unmodifiableMap(selected);
    }

    public String getPackageIdFilters(Run<?, ?> build, FilePath workspace, TaskListener listener) throws Exception {
        return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPackageIdFilters());
    }

    private Map<String, PathOrPackIdFilter> listPackageFilters(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        LinkedHashMap<String, PathOrPackIdFilter> filters = new LinkedHashMap<String, PathOrPackIdFilter>();
        try {
            for (String filter : BaseUrlUtil.splitByNewline(this.getPackageIdFilters(build, workspace, listener))) {
                if (filter.trim().length() <= 0) continue;
                filters.put(filter, PathOrPackIdFilter.parse(filter));
            }
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %n%s", new Object[]{this.getPackageIdFilters()});
        }
        return Collections.unmodifiableMap(filters);
    }

    private List<String> listBaseUrls(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return BaseUrlUtil.splitByNewline(TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getBaseUrls()));
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getBaseUrls()});
            return BaseUrlUtil.splitByNewline(this.getBaseUrls());
        }
    }

    private String getLocalDirectory(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getLocalDirectory());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getLocalDirectory()});
            return this.getLocalDirectory();
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static class DebugPackageCallable
    extends MasterToSlaveFileCallable<Result> {
        final PackId packId;
        final TaskListener listener;

        DebugPackageCallable(PackId packId, TaskListener listener) {
            this.packId = packId;
            this.listener = listener;
        }

        public Result invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            this.listener.getLogger().printf("DEBUG: %s identified as %s.%n", f.getPath(), this.packId.toString());
            return Result.SUCCESS;
        }
    }

    @Symbol(value={"crxDeploy"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String ACHANDLING_DEFER_VALUE = "_DEFER";

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Deploy Content Packages to CRX";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json.getJSONObject("graniteDeployPackages"));
            this.save();
            return true;
        }

        public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="baseUrls") String baseUrls, @QueryParameter(value="value") String value) {
            List<String> _baseUrls = BaseUrlUtil.splitByNewline(baseUrls);
            if (!_baseUrls.isEmpty()) {
                return GraniteCredentialsListBoxModel.fillItems(value, context, _baseUrls.iterator().next());
            }
            return GraniteCredentialsListBoxModel.fillItems(value, context);
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrls") String baseUrls, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="requestTimeout") long requestTimeout, @QueryParameter(value="serviceTimeout") long serviceTimeout) throws IOException, ServletException {
            return BaseUrlUtil.testManyConnections(baseUrls, credentialsId, requestTimeout, serviceTimeout);
        }

        public ListBoxModel doFillAcHandlingItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Defer to Package", ACHANDLING_DEFER_VALUE);
            for (ACHandling mode : Arrays.asList(ACHandling.IGNORE, ACHandling.MERGE_PRESERVE, ACHandling.MERGE, ACHandling.OVERWRITE, ACHandling.CLEAR)) {
                model.add(mode.getLabel(), mode.name());
            }
            return model;
        }

        public ListBoxModel doFillBehaviorItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Overwrite existing", "Overwrite");
            model.add("Uninstall and delete", "Uninstall");
            model.add("Skip package", "Skip");
            model.add("Delete package", "Delete");
            model.add("Ignore", "Ignore");
            return model;
        }
    }
}

