/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import net.adamcin.granite.client.packman.DetailedResponse;
import net.adamcin.granite.client.packman.ListResponse;
import net.adamcin.granite.client.packman.ListResult;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.PackageManagerClient;
import net.adamcin.granite.client.packman.ResponseProgressListener;
import net.adamcin.granite.client.packman.SimpleResponse;
import org.jenkinsci.plugins.graniteclient.ExistingPackageBehavior;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;
import org.jenkinsci.plugins.graniteclient.GraniteClientFileCallable;
import org.jenkinsci.plugins.graniteclient.JenkinsResponseProgressListener;
import org.jenkinsci.plugins.graniteclient.PackageInstallOptions;
import org.jenkinsci.plugins.graniteclient.PackageManagerClientCallable;

public final class DeployPackageCallable
extends GraniteClientFileCallable<Result> {
    private static final long serialVersionUID = -3235879975250741115L;
    private final GraniteClientConfig clientConfig;
    private final TaskListener listener;
    private final PackId packId;
    private final PackageInstallOptions options;
    private final ExistingPackageBehavior behavior;
    private final ResponseProgressListener progressListener;

    public DeployPackageCallable(GraniteClientConfig clientConfig, TaskListener listener, PackId packId, PackageInstallOptions options, ExistingPackageBehavior behavior) {
        this.clientConfig = clientConfig;
        this.listener = listener;
        this.progressListener = new JenkinsResponseProgressListener(this.listener);
        this.options = options;
        this.behavior = behavior;
        this.packId = packId;
    }

    public Result invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            return GraniteClientExecutor.execute(new Execution(f), this.clientConfig, this.listener);
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.fatalError("Failed to deploy package: %s", new Object[]{e.getMessage()}));
            return Result.FAILURE;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleExisting(PackageManagerClient client, PackId packId) throws Exception {
        if (this.behavior == ExistingPackageBehavior.IGNORE || this.behavior == ExistingPackageBehavior.OVERWRITE || this.behavior == ExistingPackageBehavior.SKIP) {
            this.listener.getLogger().println("Ignoring existing package...");
            return true;
        }
        if (this.behavior == ExistingPackageBehavior.UNINSTALL) {
            client.waitForService();
            ListResponse r_list = client.list(packId, false);
            if (!r_list.getResults().isEmpty() && ((ListResult)r_list.getResults().get(0)).isHasSnapshot()) {
                this.listener.getLogger().println("Will attempt to uninstall package.");
                DetailedResponse r_uninstall = client.uninstall(packId, this.progressListener);
                if (!r_uninstall.isSuccess()) {
                    this.listener.fatalError("Failed to uninstall package: %s", new Object[]{r_uninstall.getMessage()});
                    return false;
                }
                this.progressListener.onLog(r_uninstall.getMessage());
            } else {
                this.listener.getLogger().println("Existing package has not been installed. Skipping uninstallation...");
            }
        }
        if (this.behavior != ExistingPackageBehavior.UNINSTALL) {
            if (this.behavior != ExistingPackageBehavior.DELETE) return true;
        }
        client.waitForService();
        this.listener.getLogger().println("Will attempt to delete package.");
        SimpleResponse r_delete = client.delete(packId);
        if (r_delete.isSuccess()) {
            this.progressListener.onLog(r_delete.getMessage());
            return true;
        }
        this.listener.fatalError("%s", new Object[]{r_delete.getMessage()});
        return false;
    }

    private class Execution
    implements PackageManagerClientCallable<Result> {
        private final File file;

        private Execution(File file) {
            this.file = file;
        }

        @Override
        public Result doExecute(PackageManagerClient client) throws Exception {
            DeployPackageCallable.this.listener.getLogger().printf("Deploying %s to %s%n", this.file, client.getConsoleUiUrl(DeployPackageCallable.this.packId));
            client.waitForService();
            if (client.existsOnServer(DeployPackageCallable.this.packId)) {
                DeployPackageCallable.this.listener.getLogger().println("Found existing package.");
                if (!DeployPackageCallable.this.handleExisting(client, DeployPackageCallable.this.packId)) {
                    return Result.FAILURE;
                }
                if (DeployPackageCallable.this.behavior == ExistingPackageBehavior.SKIP) {
                    DeployPackageCallable.this.listener.getLogger().println("Will skip package upload and return SUCCESS.");
                    return Result.SUCCESS;
                }
            }
            client.waitForService();
            DeployPackageCallable.this.listener.getLogger().println("Will attempt to upload package.");
            SimpleResponse r_upload = client.upload(this.file, DeployPackageCallable.this.behavior == ExistingPackageBehavior.OVERWRITE, DeployPackageCallable.this.packId);
            if (r_upload.isSuccess()) {
                DeployPackageCallable.this.progressListener.onLog(r_upload.getMessage());
                DeployPackageCallable.this.listener.getLogger().println("Will attempt to install package.");
                DetailedResponse r_install = client.install(DeployPackageCallable.this.packId, DeployPackageCallable.this.options.isRecursive(), DeployPackageCallable.this.options.getAutosave(), DeployPackageCallable.this.options.getAcHandling(), DeployPackageCallable.this.progressListener);
                if (r_install.isSuccess()) {
                    Result r;
                    DeployPackageCallable.this.progressListener.onLog(r_upload.getMessage());
                    Result result = r = r_install.hasErrors() ? Result.UNSTABLE : Result.SUCCESS;
                    if (DeployPackageCallable.this.options.isReplicate()) {
                        DeployPackageCallable.this.progressListener.onLog("Will attempt to replicate package.");
                        SimpleResponse r_replicate = client.replicate(DeployPackageCallable.this.packId);
                        if (r_replicate.isSuccess()) {
                            DeployPackageCallable.this.progressListener.onLog(r_replicate.getMessage());
                        } else {
                            r = r.combine(Result.FAILURE);
                            DeployPackageCallable.this.listener.fatalError("Failed to replicate %s: %s%n", new Object[]{r_replicate.getPath(), r_replicate.getMessage()});
                        }
                    }
                    return r;
                }
                DeployPackageCallable.this.listener.fatalError("%s", new Object[]{r_install.getMessage()});
                return Result.FAILURE;
            }
            DeployPackageCallable.this.listener.fatalError(r_upload.getMessage());
            return Result.FAILURE;
        }
    }
}

