/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import net.adamcin.granite.client.packman.DetailedResponse;
import net.adamcin.granite.client.packman.DownloadResponse;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.PackageManagerClient;
import net.adamcin.granite.client.packman.ResponseProgressListener;
import net.adamcin.granite.client.packman.SimpleResponse;
import net.adamcin.granite.client.packman.WspFilter;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;
import org.jenkinsci.plugins.graniteclient.GraniteClientFileCallable;
import org.jenkinsci.plugins.graniteclient.JenkinsResponseProgressListener;
import org.jenkinsci.plugins.graniteclient.PackageManagerClientCallable;

public class BuildPackageCallable
extends GraniteClientFileCallable<Result> {
    private static final long serialVersionUID = 1329103722879551699L;
    private final GraniteClientConfig clientConfig;
    private final TaskListener listener;
    private final PackId packId;
    private final WspFilter wspFilter;
    private final boolean download;
    private final ResponseProgressListener progressListener;

    public BuildPackageCallable(GraniteClientConfig clientConfig, TaskListener listener, PackId packId, WspFilter wspFilter, boolean download) {
        this.clientConfig = clientConfig;
        this.listener = listener;
        this.packId = packId;
        this.wspFilter = wspFilter;
        this.download = download;
        this.progressListener = new JenkinsResponseProgressListener(listener);
    }

    public Result invoke(File toDirectory, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            return GraniteClientExecutor.execute(new Execution(toDirectory), this.clientConfig, this.listener);
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.fatalError("Failed to build package.", new Object[]{e.getMessage()}));
            return Result.FAILURE;
        }
    }

    private class Execution
    implements PackageManagerClientCallable<Result> {
        final File toDirectory;

        private Execution(File toDirectory) {
            this.toDirectory = toDirectory;
        }

        @Override
        public Result doExecute(PackageManagerClient client) throws Exception {
            Result result = Result.SUCCESS;
            client.setRequestTimeout(BuildPackageCallable.this.clientConfig.getRequestTimeout());
            client.setServiceTimeout(BuildPackageCallable.this.clientConfig.getServiceTimeout());
            client.waitForService();
            BuildPackageCallable.this.listener.getLogger().printf("Checking for package %s on server %s%n", BuildPackageCallable.this.packId, BuildPackageCallable.this.clientConfig.getBaseUrl());
            if (client.existsOnServer(BuildPackageCallable.this.packId)) {
                BuildPackageCallable.this.listener.getLogger().printf("Found package: %s%n", client.getConsoleUiUrl(BuildPackageCallable.this.packId));
            } else {
                BuildPackageCallable.this.listener.getLogger().printf("Creating package.%n", new Object[0]);
                SimpleResponse r_create = client.create(BuildPackageCallable.this.packId);
                if (r_create.isSuccess()) {
                    BuildPackageCallable.this.listener.getLogger().println(r_create.getMessage());
                } else {
                    BuildPackageCallable.this.listener.fatalError(r_create.getMessage());
                    return Result.FAILURE;
                }
            }
            if (BuildPackageCallable.this.wspFilter != null) {
                SimpleResponse r_updateFilter = client.updateFilter(BuildPackageCallable.this.packId, BuildPackageCallable.this.wspFilter);
                if (r_updateFilter.isSuccess()) {
                    BuildPackageCallable.this.listener.getLogger().println(r_updateFilter.getMessage());
                } else {
                    BuildPackageCallable.this.listener.fatalError(r_updateFilter.getMessage());
                    return Result.FAILURE;
                }
            }
            BuildPackageCallable.this.listener.getLogger().printf("Building package %s.%n", BuildPackageCallable.this.packId);
            DetailedResponse r_rebuild = client.build(BuildPackageCallable.this.packId, BuildPackageCallable.this.progressListener);
            if (r_rebuild.isSuccess()) {
                if (r_rebuild.hasErrors()) {
                    result = result.combine(Result.UNSTABLE);
                }
            } else {
                BuildPackageCallable.this.listener.fatalError(r_rebuild.getMessage());
                return Result.FAILURE;
            }
            BuildPackageCallable.this.listener.getLogger().println(r_rebuild.getMessage());
            BuildPackageCallable.this.listener.getLogger().printf("Package location: %s%n", client.getConsoleUiUrl(BuildPackageCallable.this.packId));
            if (BuildPackageCallable.this.download) {
                BuildPackageCallable.this.listener.getLogger().printf("Downloading %s to %s%n", BuildPackageCallable.this.packId, this.toDirectory);
                DownloadResponse response = client.downloadToDirectory(BuildPackageCallable.this.packId, this.toDirectory);
                BuildPackageCallable.this.listener.getLogger().printf("Downloaded %d bytes to file %s.%n", response.getLength(), response.getContent());
                BuildPackageCallable.this.listener.getLogger().printf("Verifying downloaded package...%n", new Object[0]);
                PackId reId = PackId.identifyPackage((File)response.getContent());
                if (BuildPackageCallable.this.packId.equals((Object)reId)) {
                    BuildPackageCallable.this.listener.getLogger().printf("Package verified as %s.%n", BuildPackageCallable.this.packId);
                } else {
                    throw new Exception("Package verification failed: " + response.getContent());
                }
            }
            return result;
        }
    }
}

