/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.WspFilter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.graniteclient.AbstractBuildStep;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.BuildPackageCallable;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BuildPackageBuilder
extends AbstractBuildStep {
    private String packageId;
    private String baseUrl;
    private String credentialsId = null;
    private long requestTimeout = 0L;
    private long serviceTimeout = 0L;
    private long waitDelay = 0L;
    private String wspFilter = null;
    private String localDirectory = null;
    private boolean download = false;

    @DataBoundConstructor
    public BuildPackageBuilder(String packageId, String baseUrl) {
        this.packageId = packageId;
        this.baseUrl = baseUrl;
    }

    public BuildPackageBuilder(String packageId, String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout, long waitDelay, String wspFilter, String localDirectory, boolean download) {
        this.packageId = packageId;
        this.baseUrl = baseUrl;
        this.credentialsId = credentialsId;
        this.requestTimeout = requestTimeout;
        this.serviceTimeout = serviceTimeout;
        this.waitDelay = waitDelay;
        this.wspFilter = wspFilter;
        this.localDirectory = localDirectory;
        this.download = download;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        String packIdString;
        PackId packId;
        Result result = Result.SUCCESS;
        Result buildResult = build.getResult();
        if (buildResult != null) {
            result = buildResult;
        }
        if ((packId = PackId.parsePid((String)(packIdString = this.getPackageId(build, workspace, listener)))) == null) {
            listener.fatalError("Failed to parse Package ID: %s%n", new Object[]{packIdString});
            build.setResult(result.combine(Result.FAILURE));
            return;
        }
        String wspFilterString = this.getWspFilter(build, workspace, listener);
        WspFilter filter = StringUtils.isBlank((String)wspFilterString) ? null : WspFilter.parseSimpleSpec((String)wspFilterString);
        GraniteClientConfig clientConfig = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), this.getBaseUrl(build, workspace, listener), this.credentialsId, this.requestTimeout, this.serviceTimeout, this.waitDelay);
        clientConfig.resolveCredentials();
        BuildPackageCallable callable = new BuildPackageCallable(clientConfig, listener, packId, filter, this.download);
        String fLocalDirectory = this.getLocalDirectory(build, workspace, listener);
        Result actResult = (Result)workspace.child(fLocalDirectory).act((FilePath.FileCallable)callable);
        if (actResult != null) {
            result = result.combine(actResult);
        }
        build.setResult(result);
    }

    public String getPackageId() {
        if (this.packageId != null) {
            return this.packageId.trim();
        }
        return "";
    }

    public String getPackageId(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPackageId());
        }
        catch (MacroEvaluationException e) {
            listener.error("Failed to expand macros in Package ID: %s", new Object[]{this.getPackageId()});
            return this.getPackageId();
        }
    }

    private String getBaseUrl(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getBaseUrl());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getBaseUrl()});
            return this.getBaseUrl();
        }
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = StringUtils.isBlank((String)credentialsId) ? null : credentialsId;
    }

    private String getLocalDirectory(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getLocalDirectory());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getLocalDirectory()});
            return this.getLocalDirectory();
        }
    }

    private String getWspFilter(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getWspFilter());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getWspFilter()});
            return this.getWspFilter();
        }
    }

    public String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl.trim();
        }
        return "";
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    @DataBoundSetter
    public void setWaitDelay(long waitDelay) {
        this.waitDelay = waitDelay;
    }

    public String getWspFilter() {
        return this.wspFilter == null ? "" : this.wspFilter;
    }

    public boolean isDownload() {
        return this.download;
    }

    public String getLocalDirectory() {
        if (StringUtils.isBlank((String)this.localDirectory)) {
            return ".";
        }
        return this.localDirectory;
    }

    @DataBoundSetter
    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    @DataBoundSetter
    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @DataBoundSetter
    public void setWspFilter(String wspFilter) {
        this.wspFilter = wspFilter;
    }

    @DataBoundSetter
    public void setDownload(boolean download) {
        this.download = download;
    }

    @DataBoundSetter
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @DataBoundSetter
    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    @Symbol(value={"crxBuild"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="value") String value) {
            return GraniteCredentialsListBoxModel.fillItems(value, context, baseUrl);
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="requestTimeout") long requestTimeout, @QueryParameter(value="serviceTimeout") long serviceTimeout) throws IOException, ServletException {
            return BaseUrlUtil.testOneConnection(baseUrl, credentialsId, requestTimeout, serviceTimeout);
        }

        public FormValidation doCheckWspFilter(@QueryParameter String value) {
            try {
                WspFilter.parseSimpleSpec((String)value);
                return FormValidation.ok();
            }
            catch (RuntimeException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public String getDisplayName() {
            return "Build a Content Package on CRX";
        }
    }
}

