/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;

class BaseUrlUtil {
    BaseUrlUtil() {
    }

    static List<String> splitByNewline(String value) {
        ArrayList<String> _baseUrls = new ArrayList<String>();
        String[] parts = value.split("\\r?\\n");
        if (parts.length <= 1) {
            parts = value.split("\\\\n");
        }
        for (String url : parts) {
            if (url.trim().length() <= 0) continue;
            _baseUrls.add(url);
        }
        return Collections.unmodifiableList(_baseUrls);
    }

    static FormValidation testOneConnection(String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout) {
        GraniteClientConfig config = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), baseUrl, credentialsId, requestTimeout, serviceTimeout);
        config.resolveCredentials();
        try {
            if (!GraniteClientExecutor.validateBaseUrl(config)) {
                return FormValidation.error((String)("Failed to login to " + config.getBaseUrl() + " as " + config.getUsername()));
            }
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)("Failed to login to " + config.getBaseUrl() + " as " + config.getUsername()));
        }
        return FormValidation.ok((String)"Success");
    }

    static FormValidation testManyConnections(String baseUrls, String credentialsId, long requestTimeout, long serviceTimeout) {
        for (String baseUrl : BaseUrlUtil.splitByNewline(baseUrls)) {
            GraniteClientConfig config = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), baseUrl, credentialsId, requestTimeout, serviceTimeout);
            config.resolveCredentials();
            try {
                if (GraniteClientExecutor.validateBaseUrl(config)) continue;
                return FormValidation.error((String)("Failed to login to " + config.getBaseUrl() + " as " + config.getUsername()));
            }
            catch (IOException e) {
                return FormValidation.error((Throwable)e, (String)("Failed to login to " + config.getBaseUrl() + " as " + config.getUsername()));
            }
        }
        return FormValidation.ok((String)"Success");
    }
}

