/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsConfidentialKey;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import jenkins.security.ConfidentialStore;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.IllegalClassException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class SecretBytes
implements Serializable {
    private static final int CHUNK_SIZE = 16;
    private static final int SALT_SIZE = 8;
    private static final long serialVersionUID = 1L;
    private static final CredentialsConfidentialKey KEY = new CredentialsConfidentialKey(SecretBytes.class, "KEY");
    private static final Logger LOGGER = Logger.getLogger(SecretBytes.class.getName());
    @NonNull
    private final byte[] value;
    @Restricted(value={NoExternalUse.class})
    public static final Pattern ENCRYPTED_VALUE_PATTERN = Pattern.compile("\\{[A-Za-z0-9+/]+={0,2}}");

    private SecretBytes(boolean encrypted, @NonNull byte[] value) {
        if (encrypted) {
            this.value = (byte[])value.clone();
        } else {
            try {
                byte[] salt = ConfidentialStore.get().randomBytes(8);
                Cipher cipher = KEY.encrypt(salt);
                byte[] encryptedBytes = cipher.doFinal(value);
                int len = encryptedBytes.length;
                byte padLen = (byte)(16 - (salt.length + len + 1) % 16);
                int totalLen = salt.length + len + padLen + 1;
                byte[] allEncryptedBytes = new byte[totalLen];
                byte[] padBytes = ConfidentialStore.get().randomBytes((int)padLen);
                System.arraycopy(salt, 0, allEncryptedBytes, 0, salt.length);
                allEncryptedBytes[salt.length] = padLen;
                System.arraycopy(encryptedBytes, 0, allEncryptedBytes, salt.length + 1, len);
                System.arraycopy(padBytes, 0, allEncryptedBytes, salt.length + 1 + len, padLen & 0xFF);
                this.value = allEncryptedBytes;
            }
            catch (GeneralSecurityException e) {
                throw new Error(e);
            }
        }
    }

    @NonNull
    public byte[] getPlainData() {
        try {
            int totalLen = this.value.length;
            byte[] salt = new byte[8];
            System.arraycopy(this.value, 0, salt, 0, salt.length);
            byte padLen = this.value[salt.length];
            int len = totalLen - salt.length - 1 - (padLen & 0xFF);
            byte[] encryptedBytes = new byte[len];
            System.arraycopy(this.value, salt.length + 1, encryptedBytes, 0, len);
            Cipher cipher = KEY.decrypt(salt);
            return cipher.doFinal(encryptedBytes);
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretBytes that = (SecretBytes)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @NonNull
    public byte[] getEncryptedData() {
        return (byte[])this.value.clone();
    }

    @CheckForNull
    public static SecretBytes decrypt(byte[] data) {
        if (data == null || data.length <= 9) {
            return null;
        }
        try {
            int totalLen = data.length;
            byte[] salt = new byte[8];
            System.arraycopy(data, 0, salt, 0, salt.length);
            byte padLen = data[salt.length];
            int len = totalLen - salt.length - 1 - (padLen & 0xFF);
            if (len < 0) {
                return null;
            }
            byte[] encryptedBytes = new byte[len];
            System.arraycopy(data, salt.length + 1, encryptedBytes, 0, len);
            Cipher cipher = KEY.decrypt(salt);
            cipher.doFinal(encryptedBytes);
            return new SecretBytes(true, data);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @NonNull
    public static byte[] getPlainData(@CheckForNull SecretBytes s) {
        return s == null ? new byte[]{} : s.getPlainData();
    }

    public static SecretBytes fromBytes(byte[] data) {
        SecretBytes s = SecretBytes.decrypt(data = data == null ? new byte[]{} : data);
        if (s == null) {
            s = new SecretBytes(false, data);
        }
        return s;
    }

    @NonNull
    public static SecretBytes fromString(String data) {
        SecretBytes s;
        data = Util.fixNull((String)data);
        try {
            byte[] decoded;
            int len = data.length();
            if (len >= 2 && ENCRYPTED_VALUE_PATTERN.matcher(data).matches() && (s = SecretBytes.decrypt(decoded = Base64.decodeBase64((String)data.substring(1, len - 1)))) != null) {
                return s;
            }
            s = new SecretBytes(false, Base64.decodeBase64((String)data));
        }
        catch (StringIndexOutOfBoundsException e) {
            s = new SecretBytes(false, new byte[0]);
        }
        return s;
    }

    public static boolean isSecretBytes(String data) {
        int len = (data = Util.fixNull((String)data)).length();
        if (len >= 2 && ENCRYPTED_VALUE_PATTERN.matcher(data).matches()) {
            byte[] decoded;
            try {
                decoded = Base64.decodeBase64((String)data.substring(1, len - 1));
            }
            catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
                return false;
            }
            return SecretBytes.decrypt(decoded) != null;
        }
        return false;
    }

    public String toString() {
        return "{" + Base64.encodeBase64String((byte[])this.getEncryptedData()) + "}";
    }

    public static String toString(SecretBytes s) {
        return s == null ? "" : s.toString();
    }

    @Restricted(value={NoExternalUse.class})
    public static class StaplerConverterImpl
    implements org.apache.commons.beanutils.Converter {
        public SecretBytes convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return SecretBytes.fromString((String)value);
            }
            if (value instanceof SecretBytes) {
                return (SecretBytes)value;
            }
            throw new IllegalClassException(SecretBytes.class, value.getClass());
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == SecretBytes.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            SecretBytes src = (SecretBytes)source;
            writer.setValue(SecretBytes.toString(src));
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return SecretBytes.fromString(reader.getValue());
        }
    }
}

