/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.fingerprints;

import com.cloudbees.plugins.credentials.fingerprints.AbstractCredentialsFingerprintFacet;
import com.cloudbees.plugins.credentials.fingerprints.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Fingerprint;
import hudson.model.Node;
import jenkins.model.Jenkins;

public class NodeCredentialsFingerprintFacet
extends AbstractCredentialsFingerprintFacet {
    @NonNull
    private final String nodeName;
    private final long timestamp0;

    public NodeCredentialsFingerprintFacet(@NonNull Node node, Fingerprint fingerprint, long timestamp) {
        this(node, fingerprint, timestamp, timestamp);
    }

    public NodeCredentialsFingerprintFacet(@NonNull Node node, Fingerprint fingerprint, long timestamp0, long timestamp) {
        super(fingerprint, Math.max(timestamp, timestamp0));
        this.nodeName = node.getNodeName();
        this.timestamp0 = Math.min(timestamp, timestamp0);
    }

    @NonNull
    public String getNodeName() {
        return this.nodeName;
    }

    @CheckForNull
    public Node getNode() {
        return this.nodeName.isEmpty() ? Jenkins.get() : Jenkins.get().getNode(this.nodeName);
    }

    public long getTimestamp0() {
        return this.timestamp0;
    }

    public String getTimestampString() {
        long now = System.currentTimeMillis();
        return this.timestamp0 == this.getTimestamp() ? Messages.AbstractCredentialsFingerprintFacet_timestampSingle(Util.getPastTimeString((long)(now - this.getTimestamp()))) : Messages.AbstractCredentialsFingerprintFacet_timestampRange(Util.getPastTimeString((long)(now - this.timestamp0)), Util.getPastTimeString((long)(now - this.getTimestamp())));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeCredentialsFingerprintFacet node = (NodeCredentialsFingerprintFacet)((Object)o);
        if (this.getTimestamp0() != node.getTimestamp0()) {
            return false;
        }
        return this.getNodeName().equals(node.getNodeName());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getNodeName().hashCode();
        result = 31 * result + (int)(this.getTimestamp0() ^ this.getTimestamp0() >>> 32);
        return result;
    }
}

