/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.Messages;
import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.security.GlobalSecurityConfiguration;
import hudson.util.FormApply;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension(ordinal=2.147483435E9)
public class GlobalCredentialsConfiguration
extends ManagementLink
implements Describable<GlobalCredentialsConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(GlobalSecurityConfiguration.class.getName());
    public static final Predicate<GlobalConfigurationCategory> FILTER = Category.class::isInstance;

    public String getIconFileName() {
        return ExtensionList.lookup(CredentialsDescriptor.class).isEmpty() ? null : "/plugin/credentials/images/48x48/credentials.png";
    }

    public String getDisplayName() {
        return this.getDescriptor().getDisplayName();
    }

    public String getDescription() {
        return Messages.GlobalCredentialsConfiguration_Description();
    }

    public String getUrlName() {
        return "configureCredentials";
    }

    public String getCategoryName() {
        return "SECURITY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public synchronized HttpResponse doConfigure(@NonNull StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        BulkChange bc = new BulkChange((Saveable)jenkins);
        try {
            boolean result = this.configure(req, req.getSubmittedForm());
            LOGGER.log(Level.FINE, "credentials configuration saved: " + result);
            jenkins.save();
            HttpResponses.HttpResponseException httpResponseException = FormApply.success((String)(result ? req.getContextPath() + "/manage" : req.getContextPath() + "/" + this.getUrlName()));
            return httpResponseException;
        }
        finally {
            bc.commit();
        }
    }

    private boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        boolean result = true;
        for (Descriptor d : Functions.getSortedDescriptorsForGlobalConfig(FILTER)) {
            result &= this.configureDescriptor(req, json, d);
        }
        return result;
    }

    private boolean configureDescriptor(StaplerRequest req, JSONObject json, Descriptor<?> d) throws Descriptor.FormException {
        String name = d.getJsonSafeClassName();
        JSONObject js = json.has(name) ? json.getJSONObject(name) : new JSONObject();
        json.putAll((Map)js);
        return d.configure(req, js);
    }

    public Descriptor<GlobalCredentialsConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    @Symbol(value={"globalCredentialsConfiguration"})
    public static class Category
    extends GlobalConfigurationCategory {
        public String getShortDescription() {
            return Messages.GlobalCredentialsConfiguration_Description();
        }

        public String getDisplayName() {
            return Messages.GlobalCredentialsConfiguration_DisplayName();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalCredentialsConfiguration> {
        public String getDisplayName() {
            return Messages.GlobalCredentialsConfiguration_DisplayName();
        }
    }
}

