/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.util;

import com.cloudbees.plugins.credentials.util.RestrictiveEntityResolver;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Restricted(value={NoExternalUse.class})
public class XMLUtils {
    private static final Logger LOGGER = LogManager.getLogManager().getLogger(XMLUtils.class.getName());
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String DISABLED_PROPERTY_NAME = "jenkins.util.xml.XMLUtils.disableXXEPrevention";

    public static void safeTransform(@Nonnull Source source, @Nonnull Result out) throws TransformerException, SAXException {
        InputSource src = SAXSource.sourceToInputSource(source);
        if (src != null) {
            SAXTransformerFactory stFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            stFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            XMLUtils.setFeatureQuietly(xmlReader, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
            XMLUtils.setFeatureQuietly(xmlReader, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
            xmlReader.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
            SAXSource saxSource = new SAXSource(xmlReader, src);
            XMLUtils._transform(saxSource, out);
        } else if (Boolean.getBoolean(DISABLED_PROPERTY_NAME)) {
            LOGGER.log(Level.WARNING, "XML external entity (XXE) prevention has been disabled by the system property {0}=true Your system may be vulnerable to XXE attacks.", DISABLED_PROPERTY_NAME);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Caller stack trace: ", new Exception("XXE Prevention caller history"));
            }
            XMLUtils._transform(source, out);
        } else {
            throw new TransformerException("Could not convert source of type " + source.getClass() + " and XXEPrevention is enabled.");
        }
    }

    private static void _transform(Source source, Result out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = factory.newTransformer();
        t.transform(source, out);
    }

    private static void setFeatureQuietly(XMLReader reader, String feature, boolean value) {
        try {
            reader.setFeature(feature, value);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }
}

