/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.kohsuke.stapler.DataBoundConstructor;

public class HostnameSpecification
extends DomainSpecification {
    @CheckForNull
    private final String includes;
    @CheckForNull
    private final String excludes;

    @DataBoundConstructor
    public HostnameSpecification(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @CheckForNull
    public String getIncludes() {
        return this.includes;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    @Override
    @NonNull
    public DomainSpecification.Result test(@NonNull DomainRequirement requirement) {
        if (requirement instanceof HostnameRequirement) {
            String hostname = ((HostnameRequirement)requirement).getHostname();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String include : this.includes.split("[,\\n ]")) {
                    if ((include = Util.fixEmptyAndTrim((String)include)) == null || !FilenameUtils.wildcardMatch((String)hostname, (String)include, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String exclude : this.excludes.split("[,\\n ]")) {
                    if ((exclude = Util.fixEmptyAndTrim((String)exclude)) == null || !FilenameUtils.wildcardMatch((String)hostname, (String)exclude, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            return DomainSpecification.Result.PARTIAL;
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        public String getDisplayName() {
            return Messages.HostnameSpecification_DisplayName();
        }
    }
}

