/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.util.XMLUtils;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppDriver;
import hudson.cli.CLICommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public abstract class BaseCredentialsCLICommand
extends CLICommand {
    protected static Credentials getCredentialsById(CredentialsStore store, Domain domain, String id) {
        List<Credentials> credentialsList = store.getCredentials(domain);
        HashSet<String> ids = new HashSet<String>(credentialsList.size());
        Credentials existing = null;
        int index = 0;
        for (Credentials c : credentialsList) {
            String cid;
            if (c instanceof IdCredentials) {
                cid = ((IdCredentials)c).getId();
            } else {
                while (ids.contains("index-" + index)) {
                    ++index;
                }
                cid = "index-" + index;
                ++index;
            }
            if (id.equals(cid)) {
                existing = c;
                break;
            }
            ids.add(cid);
        }
        return existing;
    }

    protected static Domain getDomainByName(CredentialsStore store, String domain) {
        if (StringUtils.equals((String)"_", (String)domain) || StringUtils.isBlank((String)domain) || "(global)".equals(domain)) {
            return Domain.global();
        }
        for (Domain d : store.getDomains()) {
            if (!domain.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    protected static HierarchicalStreamReader safeXmlStreamReader(InputStream stream) throws IOException {
        return BaseCredentialsCLICommand.safeXmlStreamReader(new StreamSource(stream));
    }

    protected static HierarchicalStreamReader safeXmlStreamReader(Source source) throws IOException {
        StringWriter out = new StringWriter();
        try {
            XMLUtils.safeTransform(source, new StreamResult(out));
            out.close();
        }
        catch (TransformerException e) {
            throw new IOException("Failed to parse", e);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse", e);
        }
        return new XppDriver().createReader((Reader)new StringReader(out.toString()));
    }
}

