/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.AccessDeniedException2;
import hudson.security.Permission;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@Extension
public class UserCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(UserCredentialsProperty.class.getName());
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.USER);
    @GuardedBy(value="self")
    private static final WeakHashMap<User, UserCredentialsProperty> emptyProperties = new WeakHashMap();

    @Override
    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof User) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @Override
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        if (object instanceof User) {
            return new StoreImpl((User)object);
        }
        return null;
    }

    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (authentication == null) {
            authentication = ACL.SYSTEM;
        }
        if (!ACL.SYSTEM.equals(authentication)) {
            UserCredentialsProperty property;
            User user;
            try {
                user = authentication == null || authentication instanceof AnonymousAuthenticationToken ? null : (authentication == Jenkins.getAuthentication() ? User.current() : User.get((String)authentication.getName()));
            }
            catch (NullPointerException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not find user for specified authentication. User credentials lookup aborted");
                lr.setThrown(e);
                lr.setParameters(new Object[]{authentication});
                LOGGER.log(lr);
                user = null;
            }
            if (user != null && (property = (UserCredentialsProperty)user.getProperty(UserCredentialsProperty.class)) != null) {
                boolean needImpersonation = !user.equals(User.current());
                SecurityContext old = needImpersonation ? ACL.impersonate((Authentication)user.impersonate()) : null;
                try {
                    List<C> list = DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, CredentialsMatchers.always());
                    return list;
                }
                finally {
                    if (needImpersonation) {
                        SecurityContextHolder.setContext((SecurityContext)old);
                    }
                }
            }
        }
        return new ArrayList();
    }

    @Override
    public String getIconClassName() {
        return "icon-credentials-user-store";
    }

    public static class StoreImpl
    extends CredentialsStore {
        private final User user;
        private final UserFacingAction storeAction;
        private transient UserCredentialsProperty property;

        private StoreImpl(User user) {
            this.user = user;
            this.storeAction = new UserFacingAction(this);
        }

        @Override
        @Nullable
        public CredentialsStoreAction getStoreAction() {
            return this.storeAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UserCredentialsProperty getInstance() {
            if (this.property == null) {
                UserCredentialsProperty property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                if (property == null) {
                    WeakHashMap weakHashMap = emptyProperties;
                    synchronized (weakHashMap) {
                        property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                        if (property == null && (property = (UserCredentialsProperty)((Object)emptyProperties.get(this.user))) == null) {
                            property = new UserCredentialsProperty(new DomainCredentials[0]);
                            property._setUser(this.user);
                            emptyProperties.put(this.user, property);
                        }
                    }
                }
                this.property = property;
            }
            return this.property;
        }

        @Override
        @NonNull
        public ModelObject getContext() {
            return this.user;
        }

        @Override
        public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
            return this.getACL().hasPermission(a, permission);
        }

        @Override
        public ACL getACL() {
            return new ACL(){

                public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                    return user.equals(User.get((String)a.getName())) && user.getACL().hasPermission(a, permission);
                }
            };
        }

        @Override
        @Exported
        @NonNull
        public List<Domain> getDomains() {
            return Collections.unmodifiableList(new ArrayList<Domain>(this.getInstance().getDomainCredentialsMap().keySet()));
        }

        @Override
        @Exported
        @NonNull
        public List<Credentials> getCredentials(@NonNull Domain domain) {
            return this.getInstance().getCredentials(domain);
        }

        @Override
        public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            return this.getInstance().addDomain(domain, credentials);
        }

        @Override
        public boolean removeDomain(@NonNull Domain domain) throws IOException {
            return this.getInstance().removeDomain(domain);
        }

        @Override
        public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            return this.getInstance().updateDomain(current, replacement);
        }

        @Override
        public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return this.getInstance().addCredentials(domain, credentials);
        }

        @Override
        public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return this.getInstance().removeCredentials(domain, credentials);
        }

        @Override
        public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            return this.getInstance().updateCredentials(domain, current, replacement);
        }

        @Override
        public String getRelativeLinkToContext() {
            StaplerRequest request = Stapler.getCurrentRequest();
            return URI.create(request.getContextPath() + "/" + this.user.getUrl() + "/").normalize().toString();
        }

        @Override
        public void save() throws IOException {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            this.getInstance().save();
        }
    }

    @ExportedBean
    public static class UserFacingAction
    extends CredentialsStoreAction {
        private final StoreImpl store;

        public UserFacingAction(StoreImpl store) {
            this.store = store;
        }

        @Override
        @Exported
        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        @Override
        public String getIconFileName() {
            return this.isVisible() ? "/plugin/credentials/images/24x24/user-store.png" : null;
        }

        @Override
        public String getIconClassName() {
            return this.isVisible() ? "icon-credentials-user-store" : null;
        }

        @Override
        public String getDisplayName() {
            return Messages.UserCredentialsProvider_UserFacingAction_DisplayName();
        }
    }

    public static class UserCredentialsProperty
    extends UserProperty {
        @Deprecated
        private transient List<Credentials> credentials;
        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
        private Map<Domain, List<Credentials>> domainCredentialsMap;

        @Deprecated
        public UserCredentialsProperty(List<Credentials> credentials) {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(null, credentials);
        }

        @DataBoundConstructor
        public UserCredentialsProperty(DomainCredentials[] domainCredentials) {
            this.domainCredentialsMap = DomainCredentials.asMap(Arrays.asList(domainCredentials));
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.domainCredentialsMap == null) {
                return new UserCredentialsProperty(this.credentials);
            }
            return this;
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            this.checkPermission(CredentialsProvider.VIEW);
            ArrayList<C> result = new ArrayList<C>();
            for (Credentials credential : this.getCredentials()) {
                if (!type.isInstance(credential)) continue;
                result.add(type.cast(credential));
            }
            return result;
        }

        public List<Credentials> getCredentials() {
            this.checkPermission(CredentialsProvider.VIEW);
            return this.domainCredentialsMap.get(Domain.global());
        }

        public List<DomainCredentials> getDomainCredentials() {
            this.checkPermission(CredentialsProvider.VIEW);
            return DomainCredentials.asList(this.getDomainCredentialsMap());
        }

        @NonNull
        public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
            this.checkPermission(CredentialsProvider.VIEW);
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
            return this.domainCredentialsMap;
        }

        public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
        }

        private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                boolean modified = false;
                for (Credentials c : credentials) {
                    if (list.contains(c)) continue;
                    list.add(c);
                    modified = true;
                }
                if (modified) {
                    this.save();
                }
                return modified;
            }
            domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
            this.save();
            return true;
        }

        private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                domainCredentialsMap.remove(domain);
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(current)) {
                domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.CREATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (list.contains(credentials)) {
                    return false;
                }
                list.add(credentials);
                this.save();
                return true;
            }
            return false;
        }

        @NonNull
        private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
            if (this.user.equals(User.current())) {
                List<Credentials> list = this.getDomainCredentialsMap().get(domain);
                if (list == null || list.isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(new ArrayList<Credentials>(list));
            }
            return Collections.emptyList();
        }

        private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.DELETE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (!list.contains(credentials)) {
                    return false;
                }
                list.remove(credentials);
                this.save();
                return true;
            }
            return false;
        }

        private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            this.checkPermission(CredentialsProvider.UPDATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                int index = list.indexOf(current);
                if (index == -1) {
                    return false;
                }
                list.set(index, replacement);
                this.save();
                return true;
            }
            return false;
        }

        private void checkPermission(Permission p) {
            if (!this.user.equals(User.current())) {
                throw new AccessDeniedException2(Jenkins.getAuthentication(), p);
            }
            this.user.checkPermission(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() throws IOException {
            if (this.user.equals(User.current())) {
                UserCredentialsProperty property = (UserCredentialsProperty)this.user.getProperty(UserCredentialsProperty.class);
                if (property == null) {
                    List<Credentials> global;
                    Map<Domain, List<Credentials>> domainCredentialsMap;
                    Object object = this;
                    synchronized (object) {
                        domainCredentialsMap = this.domainCredentialsMap;
                    }
                    if (domainCredentialsMap == null || domainCredentialsMap.isEmpty()) {
                        return;
                    }
                    if (domainCredentialsMap.size() == 1 && (global = domainCredentialsMap.get(Domain.global())) != null && global.isEmpty()) {
                        return;
                    }
                    object = emptyProperties;
                    synchronized (object) {
                        this.user.addProperty((UserProperty)this);
                        emptyProperties.remove(this.user);
                    }
                }
                this.user.save();
            }
        }

        public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
            return this;
        }

        private void _setUser(User user) {
            this.user = user;
        }

        @Extension
        public static class DescriptorImpl
        extends UserPropertyDescriptor {
            public UserProperty newInstance(User user) {
                return new UserCredentialsProperty(new DomainCredentials[0]);
            }

            public boolean isEnabled() {
                return !UserProperty.all().isEmpty();
            }

            public String getDisplayName() {
                return Messages.UserCredentialsProvider_DisplayName();
            }

            public DescriptorExtensionList<Credentials, CredentialsDescriptor> getCredentialDescriptors() {
                return CredentialsProvider.allCredentialsDescriptors();
            }

            public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
                return Jenkins.getActiveInstance().getDescriptorList(DomainSpecification.class);
            }
        }
    }
}

