/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.model.ComputerSet;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.FormApply;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class CredentialsSelectHelper
extends Descriptor<CredentialsSelectHelper>
implements Describable<CredentialsSelectHelper> {
    public static final Permission CREATE = CredentialsProvider.CREATE;

    public CredentialsSelectHelper() {
        super(CredentialsSelectHelper.class);
    }

    public CredentialsSelectHelper getDescriptor() {
        return this;
    }

    public String getDisplayName() {
        return Messages.CredentialsSelectHelper_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public ModelObject resolveContext(Object context) {
        if (context instanceof ModelObject) {
            return (ModelObject)context;
        }
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            return (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public List<StoreItem> getStoreItems(ModelObject context, boolean includeUser) {
        Object request;
        HashSet<String> urls = new HashSet<String>();
        ArrayList<StoreItem> result = new ArrayList<StoreItem>();
        if (context == null && (request = Stapler.getCurrentRequest()) != null) {
            context = (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        if (context != null) {
            for (CredentialsStore store : CredentialsProvider.lookupStores(context)) {
                StoreItem item = new StoreItem(store);
                String url = item.getUrl();
                if (item.getUrl() == null || urls.contains(url)) continue;
                result.add(item);
                urls.add(url);
            }
        }
        if (includeUser) {
            boolean hasPermission = false;
            ModelObject current = context;
            while (current != null) {
                if (current instanceof AccessControlled) {
                    hasPermission = ((AccessControlled)current).hasPermission(CredentialsProvider.USE_OWN);
                    break;
                }
                if (current instanceof ComputerSet) {
                    current = Jenkins.getActiveInstance();
                    continue;
                }
                current = Jenkins.getActiveInstance();
            }
            if (hasPermission) {
                for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)User.current())) {
                    StoreItem item = new StoreItem(store);
                    String url = item.getUrl();
                    if (item.getUrl() == null || urls.contains(url)) continue;
                    result.add(item);
                    urls.add(url);
                }
            }
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasCreatePermission(ModelObject context, boolean includeUser) {
        StaplerRequest request;
        User current;
        if (includeUser && (current = User.current()) != null && current.hasPermission(CREATE)) {
            return true;
        }
        if (context == null && (request = Stapler.getCurrentRequest()) != null) {
            context = (ModelObject)request.findAncestorObject(ModelObject.class);
        }
        for (CredentialsStore store : CredentialsProvider.lookupStores(context)) {
            if (!store.hasPermission(CREATE)) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    public WrappedContextResolver getResolver(String className) {
        for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
            if (!r.getClass().getName().equals(className)) continue;
            return new WrappedContextResolver(r);
        }
        return null;
    }

    @CLIResolver
    public static CredentialsStore resolveForCLI(@Argument(required=true, metaVar="STORE", usage="Store ID") String storeId) throws CmdLineException {
        int index2;
        int index1 = storeId.indexOf("::");
        int n = index2 = index1 == -1 ? -1 : storeId.indexOf("::", index1 + 2);
        if (index1 == -1 || index1 == 0 || index2 == -1 || index2 < index1 + 2 || index2 == storeId.length() - 2) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLIMalformedStoreId(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLIMalformedStoreId(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        String providerName = storeId.substring(0, index1);
        String resolverName = storeId.substring(index1 + 2, index2);
        String token = storeId.substring(index2 + 2);
        CredentialsProvider provider = CredentialsSelectHelper.getProvidersByName().get(providerName);
        if (provider == null || provider == CredentialsProvider.NONE) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchProvider(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchProvider(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        ContextResolver resolver = CredentialsSelectHelper.getResolversByName().get(resolverName);
        if (resolver == null || resolver == ContextResolver.NONE) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchResolver(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchResolver(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        ModelObject context = resolver.getContext(token);
        if (context == null) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchContext(objects[0]).toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoSuchContext(objects[0]).toString();
                }
            }, new String[]{storeId});
        }
        CredentialsStore store = provider.getStore(context);
        if (store == null) {
            throw new CmdLineException(null, new Localizable(){

                public String formatWithLocale(Locale locale, Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoStore().toString(locale);
                }

                public String format(Object ... objects) {
                    return Messages._CredentialsSelectHelper_CLINoStore().toString();
                }
            }, new String[]{storeId});
        }
        return store;
    }

    public static Map<String, ContextResolver> getResolversByName() {
        TreeMap<String, ContextResolver> resolverByName = new TreeMap<String, ContextResolver>();
        for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
            resolverByName.put(r.getClass().getName(), r);
            String shortName = r.getClass().getSimpleName();
            resolverByName.put(shortName, resolverByName.containsKey(shortName) ? ContextResolver.NONE : r);
            if (!StringUtils.isNotBlank((String)(shortName = shortName.toLowerCase(Locale.ENGLISH).replaceAll("(context|resolver|impl)*", "")))) continue;
            resolverByName.put(shortName, resolverByName.containsKey(shortName) ? ContextResolver.NONE : r);
        }
        Iterator iterator = resolverByName.values().iterator();
        while (iterator.hasNext()) {
            ContextResolver r;
            r = (ContextResolver)iterator.next();
            if (r != ContextResolver.NONE) continue;
            iterator.remove();
        }
        return resolverByName;
    }

    public static Map<String, CredentialsProvider> getProvidersByName() {
        TreeMap<String, CredentialsProvider> providerByName = new TreeMap<String, CredentialsProvider>();
        for (CredentialsProvider r : ExtensionList.lookup(CredentialsProvider.class)) {
            providerByName.put(((Object)((Object)r)).getClass().getName(), r);
            for (Class<?> clazz = ((Object)((Object)r)).getClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
                String shortName = clazz.getSimpleName();
                String simpleName = shortName.toLowerCase(Locale.ENGLISH).replaceAll("(credentials|provider|impl)*", "");
                if (StringUtils.isBlank((String)simpleName)) continue;
                providerByName.put(shortName, providerByName.containsKey(shortName) ? CredentialsProvider.NONE : r);
                providerByName.put(simpleName, providerByName.containsKey(simpleName) ? CredentialsProvider.NONE : r);
            }
        }
        Iterator iterator = providerByName.values().iterator();
        while (iterator.hasNext()) {
            CredentialsProvider p = (CredentialsProvider)((Object)iterator.next());
            if (p != CredentialsProvider.NONE) continue;
            iterator.remove();
        }
        return providerByName;
    }

    @Extension
    public static class UserContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof User ? ((User)context).getId() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            try {
                Method getById = User.class.getMethod("getById", String.class, Boolean.TYPE);
                return (ModelObject)getById.invoke(null, token, false);
            }
            catch (NoSuchMethodException e) {
                return User.get((String)token, (boolean)false, Collections.emptyMap());
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Users";
        }
    }

    @Extension
    public static class ItemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Item ? ((Item)context).getFullName() : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return Jenkins.getActiveInstance().getItemByFullName(token);
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Items";
        }
    }

    @Extension(ordinal=1000.0)
    public static class SystemContextResolver
    extends ContextResolver {
        @Override
        public String getToken(ModelObject context) {
            return context instanceof Jenkins ? "jenkins" : null;
        }

        @Override
        public ModelObject getContext(String token) {
            return "jenkins".equals(token) ? Jenkins.getActiveInstance() : null;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Jenkins";
        }
    }

    public static abstract class ContextResolver
    implements ExtensionPoint {
        public static final ContextResolver NONE = new ContextResolver(){

            @Override
            public String getToken(ModelObject context) {
                return null;
            }

            @Override
            public ModelObject getContext(String token) {
                return null;
            }

            @Override
            public String getDisplayName() {
                return "Nothing";
            }
        };

        @CheckForNull
        public abstract String getToken(ModelObject var1);

        @CheckForNull
        public abstract ModelObject getContext(String var1);

        @NonNull
        public abstract String getDisplayName();

        public static String displayName(ContextResolver resolver) {
            try {
                return resolver.getDisplayName();
            }
            catch (AbstractMethodError e) {
                return resolver.getClass().getName();
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedCredentialsStore
    implements IconSpec,
    ModelObject {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;
        @NonNull
        private final String token;
        private final CredentialsStore store;

        public WrappedCredentialsStore(ContextResolver resolver, CredentialsProvider provider, String token, CredentialsStore store) {
            this.store = store;
            this.resolver = resolver;
            this.provider = provider;
            this.token = token;
        }

        @RequirePOST
        public void doAddCredentials(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            if (!this.store.isDomainsModifiable()) {
                HttpResponses.status((int)400).generateResponse(req, rsp, null);
                FormApply.applyResponse((String)"window.alert('Domain is read-only')").generateResponse(req, rsp, null);
            }
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            JSONObject data = req.getSubmittedForm();
            String domainName = data.getString("domain");
            CredentialsStoreAction.DomainWrapper wrapper = this.getWrappers().get(domainName);
            if (!this.store.getDomains().contains(wrapper.getDomain())) {
                HttpResponses.status((int)400).generateResponse(req, rsp, null);
                FormApply.applyResponse((String)"window.alert('Store does not have selected domain')").generateResponse(req, rsp, null);
            }
            this.store.checkPermission(CredentialsStoreAction.CREATE);
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data.getJSONObject("credentials"));
            this.store.addCredentials(wrapper.getDomain(), credentials);
            FormApply.applyResponse((String)"window.credentials.refreshAll();").generateResponse(req, rsp, null);
        }

        public CredentialsStoreAction.DomainWrapper getWrapper() {
            Collection<CredentialsStoreAction.DomainWrapper> values = this.getWrappers().values();
            return values.isEmpty() ? null : values.iterator().next();
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return String.format("%sdescriptor/%s/resolver/%s/provider/%s/context/%s", Jenkins.getActiveInstance().getRootUrlFromRequest(), CredentialsSelectHelper.class.getName(), Util.rawEncode((String)this.resolver.getClass().getName()), Util.rawEncode((String)((Object)((Object)this.provider)).getClass().getName()), Util.rawEncode((String)this.token));
        }

        public List<CredentialsDescriptor> getCredentialsDescriptors() {
            return this.store.getCredentialsDescriptors();
        }

        public Map<String, CredentialsStoreAction.DomainWrapper> getWrappers() {
            CredentialsStoreAction action = this.store.getStoreAction();
            return action != null ? action.getDomains() : new CredentialsStoreAction(){

                @Override
                @NonNull
                public CredentialsStore getStore() {
                    return store;
                }
            }.getDomains();
        }

        public CredentialsStore getStore() {
            return this.store;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolverCredentialsProvider {
        @NonNull
        private final ContextResolver resolver;
        @NonNull
        private final CredentialsProvider provider;

        public WrappedContextResolverCredentialsProvider(@NonNull ContextResolver resolver, @NonNull CredentialsProvider provider) {
            this.resolver = resolver;
            this.provider = provider;
        }

        public WrappedCredentialsStore getContext(String token) {
            CredentialsStore store;
            ModelObject context = this.resolver.getContext(token);
            if (context != null && (store = this.provider.getStore(context)) != null) {
                return new WrappedCredentialsStore(this.resolver, this.provider, token, store);
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WrappedContextResolver {
        @NonNull
        private final ContextResolver resolver;

        public WrappedContextResolver(@NonNull ContextResolver resolver) {
            this.resolver = resolver;
        }

        @CheckForNull
        public WrappedContextResolverCredentialsProvider getProvider(String className) {
            for (CredentialsProvider p : CredentialsProvider.enabled()) {
                if (!((Object)((Object)p)).getClass().getName().equals(className)) continue;
                return new WrappedContextResolverCredentialsProvider(this.resolver, p);
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class StoreItem
    implements IconSpec,
    ModelObject {
        private final CredentialsStore store;
        private final String url;

        public StoreItem(CredentialsStore store) {
            this.store = store;
            String provider = ((Object)((Object)store.getProvider())).getClass().getName();
            String resolver = null;
            String token = null;
            ModelObject storeContext = store.getContext();
            for (ContextResolver r : ExtensionList.lookup(ContextResolver.class)) {
                String t = r.getToken(storeContext);
                if (t == null) continue;
                resolver = r.getClass().getName();
                token = t;
                break;
            }
            this.url = token == null ? null : String.format("descriptor/%s/resolver/%s/provider/%s/context/%s", CredentialsSelectHelper.class.getName(), Util.rawEncode((String)resolver), Util.rawEncode((String)provider), Util.rawEncode((String)token));
        }

        public String getIconClassName() {
            return this.store.getProvider().getIconClassName();
        }

        public boolean isEnabled() {
            return this.url != null && this.store.hasPermission(CREATE) && !this.store.getCredentialsDescriptors().isEmpty();
        }

        public String getDisplayName() {
            return this.store.getContextDisplayName();
        }

        public String getDescription() {
            return this.store.getProvider().getDisplayName();
        }

        public String getUrl() {
            return this.url;
        }
    }
}

