/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.ContextMenuIconUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.util.xml.XMLUtils;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.xml.sax.SAXException;

@ExportedBean
public abstract class CredentialsStoreAction
implements Action,
IconSpec,
AccessControlled,
ModelObjectWithContextMenu,
ModelObjectWithChildren {
    public static final Permission VIEW = CredentialsProvider.VIEW;
    public static final Permission CREATE = CredentialsProvider.CREATE;
    public static final Permission UPDATE = CredentialsProvider.UPDATE;
    public static final Permission DELETE = CredentialsProvider.DELETE;
    public static final Permission MANAGE_DOMAINS = CredentialsProvider.MANAGE_DOMAINS;
    public static final XStream2 SECRETS_REDACTED = new XStream2();

    @NonNull
    public abstract CredentialsStore getStore();

    public String getIconFileName() {
        return this.isVisible() ? "/plugin/credentials/images/24x24/credentials.png" : null;
    }

    public String getDisplayName() {
        CredentialsStore store = this.getStore();
        if (this == store.getStoreAction()) {
            Class<?> c = store.getClass();
            while (c.getEnclosingClass() != null) {
                c = c.getEnclosingClass();
            }
            String name = c.getSimpleName().replaceAll("(?i)(Impl|Credentials|Provider|Store)+", "");
            if (StringUtils.isBlank((String)name)) {
                name = c.getSimpleName();
            }
            return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)' ');
        }
        return Messages.CredentialsStoreAction_DisplayName();
    }

    @NonNull
    public List<Action> getActions() {
        return Collections.emptyList();
    }

    @CheckForNull
    public Object getDynamic(String token) {
        for (Action a : this.getActions()) {
            String url = a.getUrlName();
            if (url == null || !url.equals(token)) continue;
            return a;
        }
        return null;
    }

    @CheckForNull
    public ModelObjectWithContextMenu.ContextMenu getContextMenu(String prefix) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        if (this.getStore().isDomainsModifiable() && this.getStore().hasPermission(MANAGE_DOMAINS)) {
            menu.add(ContextMenuIconUtils.buildUrl(prefix, "newDomain"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-credentials-new-domain icon-md"), Messages.CredentialsStoreAction_AddDomainAction());
        }
        for (Action action : this.getActions()) {
            ContextMenuIconUtils.addMenuItem(menu, prefix, action);
        }
        return menu.items.isEmpty() ? null : menu;
    }

    @CheckForNull
    public ModelObjectWithContextMenu.ContextMenu getChildrenContextMenu(String prefix) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (Domain d : this.getStore().getDomains()) {
            ModelObjectWithContextMenu.MenuItem item = new ModelObjectWithContextMenu.MenuItem(d.getUrl(), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-credentials-domain icon-md"), d.isGlobal() ? Messages.CredentialsStoreAction_GlobalDomainDisplayName() : d.getName());
            item.subMenu = new DomainWrapper(this, d).getContextMenu(ContextMenuIconUtils.buildUrl(prefix, d.getUrl()));
            menu.add(item);
        }
        return menu.items.isEmpty() ? null : menu;
    }

    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return this.getContextMenu("");
    }

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return this.getChildrenContextMenu("");
    }

    public String getUrlName() {
        CredentialsStore store = this.getStore();
        if (this == store.getStoreAction()) {
            Class<?> c = store.getClass();
            while (c.getEnclosingClass() != null) {
                c = c.getEnclosingClass();
            }
            String name = c.getSimpleName().replaceAll("(?i)(Impl|Credentials|Provider|Store)+", "");
            if (StringUtils.isBlank((String)name)) {
                name = c.getSimpleName();
            }
            return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)name), (char)'-').toLowerCase(Locale.ENGLISH);
        }
        return "credential-store";
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public boolean isVisible() {
        CredentialsStore store = this.getStore();
        if (!store.getProvider().isEnabled()) {
            return false;
        }
        CredentialsStoreAction storeAction = store.getStoreAction();
        if (storeAction != null && this != storeAction) {
            return false;
        }
        return store.hasPermission(CredentialsProvider.VIEW) && !store.getCredentialsDescriptors().isEmpty();
    }

    public String getIconClassName() {
        return this.isVisible() ? "icon-credentials-credentials" : null;
    }

    public final String getFullName() {
        ModelObject context = this.getStore().getContext();
        String n = context instanceof Item ? ((Item)context).getFullName() : (context instanceof ItemGroup ? ((ItemGroup)context).getFullName() : (context instanceof User ? "user:" + ((User)context).getId() : ""));
        if (n.length() == 0) {
            return this.getUrlName();
        }
        return n + '/' + this.getUrlName();
    }

    public final String getFullDisplayName() {
        ModelObject context = this.getStore().getContext();
        String n = context instanceof Item ? ((Item)context).getFullDisplayName() : (context instanceof ItemGroup ? ((ItemGroup)context).getFullDisplayName() : (context instanceof User ? Messages.CredentialsStoreAction_UserDisplayName(((User)context).getDisplayName()) : Jenkins.getActiveInstance().getFullDisplayName()));
        if (n.length() == 0) {
            return this.getDisplayName();
        }
        return n + " \u00bb " + this.getDisplayName();
    }

    @Exported
    @NonNull
    public Map<String, DomainWrapper> getDomains() {
        TreeMap<String, DomainWrapper> result = new TreeMap<String, DomainWrapper>();
        for (Domain d : this.getStore().getDomains()) {
            String name = d.isGlobal() ? "_" : d.getName();
            result.put(name, new DomainWrapper(this, d));
        }
        return result;
    }

    @CheckForNull
    public DomainWrapper getDomain(String name) {
        return this.getDomains().get(name);
    }

    public boolean isDomainsModifiable() {
        return this.getStore().isDomainsModifiable();
    }

    public DomainWrapper.DescriptorImpl getDomainDescriptor() {
        return (DomainWrapper.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(DomainWrapper.DescriptorImpl.class);
    }

    public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
        return Jenkins.getActiveInstance().getDescriptorList(DomainSpecification.class);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doCreateDomain(StaplerRequest req) throws ServletException, IOException {
        this.getStore().checkPermission(MANAGE_DOMAINS);
        if (!this.getStore().isDomainsModifiable()) {
            return HttpResponses.status((int)400);
        }
        String requestContentType = req.getContentType();
        if (requestContentType == null) {
            throw new Failure("No Content-Type header set");
        }
        if (requestContentType.startsWith("application/xml") || requestContentType.startsWith("text/xml")) {
            StringWriter out = new StringWriter();
            try {
                XMLUtils.safeTransform((Source)new StreamSource(req.getReader()), (Result)new StreamResult(out));
                out.close();
            }
            catch (TransformerException e) {
                throw new IOException("Failed to parse credential", e);
            }
            catch (SAXException e) {
                throw new IOException("Failed to parse credential", e);
            }
            Domain domain = (Domain)Items.XSTREAM.unmarshal(new XppDriver().createReader((Reader)new StringReader(out.toString())));
            if (this.getStore().addDomain(domain, new Credentials[0])) {
                return HttpResponses.ok();
            }
            return HttpResponses.status((int)409);
        }
        JSONObject data = req.getSubmittedForm();
        Domain domain = (Domain)req.bindJSON(Domain.class, data);
        String domainName = domain.getName();
        if (domainName != null && this.getStore().addDomain(domain, new Credentials[0])) {
            return HttpResponses.redirectTo((String)("./domain/" + Util.rawEncode((String)domainName)));
        }
        return HttpResponses.redirectToDot();
    }

    @Nonnull
    public ACL getACL() {
        return this.getStore().getACL();
    }

    public void checkPermission(@Nonnull Permission permission) throws AccessDeniedException {
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(@Nonnull Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    static {
        SECRETS_REDACTED.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return type == Secret.class;
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("secret-redacted");
                writer.endNode();
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return null;
            }
        });
    }

    @ExportedBean
    public static class CredentialsWrapper
    extends AbstractDescribableImpl<CredentialsWrapper>
    implements IconSpec,
    ModelObjectWithContextMenu {
        private final DomainWrapper domain;
        private final Credentials credentials;
        private final String id;
        private Fingerprint fingerprint;

        public CredentialsWrapper(DomainWrapper domain, Credentials credentials, String id) {
            this.domain = domain;
            this.credentials = credentials;
            this.id = id;
        }

        @Exported
        public String getId() {
            return this.id;
        }

        public String getUrlName() {
            return Util.rawEncode((String)this.id);
        }

        public String getIconClassName() {
            return this.credentials.getDescriptor().getIconClassName();
        }

        public Api getApi() {
            return new Api((Object)this);
        }

        @Exported
        public String getDisplayName() {
            return CredentialsNameProvider.name(this.credentials);
        }

        @Exported
        public String getTypeName() {
            return this.credentials.getDescriptor().getDisplayName();
        }

        @Exported
        public String getDescription() {
            return this.credentials instanceof StandardCredentials ? ((StandardCredentials)this.credentials).getDescription() : null;
        }

        @Exported
        public final String getFullName() {
            String n = this.getDomain().getFullName();
            if (n.length() == 0) {
                return this.getUrlName();
            }
            return n + '/' + this.getUrlName();
        }

        public final String getFullDisplayName() {
            String n = this.getDomain().getFullDisplayName();
            if (n.length() == 0) {
                return this.getDisplayName();
            }
            return n + " \u00bb " + this.getDisplayName();
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public DomainWrapper getDomain() {
            return this.domain;
        }

        public DomainWrapper getParent() {
            return this.domain;
        }

        public CredentialsStore getStore() {
            return this.domain.getStore();
        }

        @Exported(visibility=1)
        @Restricted(value={NoExternalUse.class})
        public Fingerprint getFingerprint() throws IOException {
            if (this.fingerprint == null) {
                this.fingerprint = CredentialsProvider.getFingerprintOf(this.credentials);
            }
            return this.fingerprint;
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doDoDelete(StaplerRequest req) throws IOException {
            this.getStore().checkPermission(DELETE);
            if (this.getStore().removeCredentials(this.domain.getDomain(), this.credentials)) {
                return HttpResponses.redirectTo((String)"../..");
            }
            return HttpResponses.redirectToDot();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doDoMove(StaplerRequest req, @QueryParameter String destination) throws IOException {
            if (this.getStore().getDomains().size() <= 1) {
                return HttpResponses.status((int)400);
            }
            Jenkins jenkins = Jenkins.getActiveInstance();
            this.getStore().checkPermission(DELETE);
            String splitKey = this.domain.getParent().getUrlName() + "/";
            int split = destination.lastIndexOf(splitKey);
            if (split == -1) {
                return HttpResponses.status((int)400);
            }
            String contextName = destination.substring(0, split);
            String domainName = destination.substring(split + splitKey.length());
            Object context = null;
            if ("".equals(contextName)) {
                context = jenkins;
            } else {
                while (context == null && split > 0) {
                    context = contextName.startsWith("user:") ? User.get((String)contextName.substring("user:".length(), split - 1), (boolean)false, Collections.emptyMap()) : jenkins.getItemByFullName(contextName);
                    if (context != null || (split = destination.lastIndexOf(splitKey, split - 1)) <= 0) continue;
                    contextName = destination.substring(0, split);
                    domainName = destination.substring(split + splitKey.length());
                }
            }
            if (context == null) {
                return HttpResponses.status((int)400);
            }
            CredentialsStore destinationStore = null;
            Domain destinationDomain = null;
            for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)context)) {
                if (store.getContext() != context) continue;
                for (Domain d : store.getDomains()) {
                    if (!(domainName.equals("_") ? d.getName() == null : domainName.equals(d.getName()))) continue;
                    destinationStore = store;
                    destinationDomain = d;
                    break;
                }
                if (destinationDomain == null) continue;
                break;
            }
            if (destinationDomain == null) {
                return HttpResponses.status((int)400);
            }
            if (!destinationStore.isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            destinationStore.checkPermission(CREATE);
            if (destinationDomain.equals(this.domain.getDomain())) {
                return HttpResponses.redirectToDot();
            }
            if (destinationStore.addCredentials(destinationDomain, this.credentials)) {
                if (this.getStore().removeCredentials(this.domain.getDomain(), this.credentials)) {
                    return HttpResponses.redirectTo((String)"../..");
                }
                destinationStore.removeCredentials(destinationDomain, this.credentials);
            }
            return HttpResponses.redirectToDot();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doUpdateSubmit(StaplerRequest req) throws ServletException, IOException {
            this.getStore().checkPermission(UPDATE);
            JSONObject data = req.getSubmittedForm();
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data);
            if (!this.getStore().updateCredentials(this.domain.domain, this.credentials, credentials)) {
                return HttpResponses.redirectTo((String)"concurrentModification");
            }
            return HttpResponses.redirectToDot();
        }

        @CheckForNull
        @Restricted(value={NoExternalUse.class})
        public ModelObjectWithContextMenu.ContextMenu getContextMenu(String prefix) {
            if (this.getStore().hasPermission(UPDATE) || this.getStore().hasPermission(DELETE)) {
                ModelObjectWithContextMenu.ContextMenu result = new ModelObjectWithContextMenu.ContextMenu();
                if (this.getStore().hasPermission(UPDATE)) {
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "update"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-setting icon-md"), Messages.CredentialsStoreAction_UpdateCredentialAction()));
                }
                if (this.getStore().hasPermission(DELETE)) {
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "delete"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-edit-delete icon-md"), Messages.CredentialsStoreAction_DeleteCredentialAction()));
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "move"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-credentials-move icon-md"), Messages.CredentialsStoreAction_MoveCredentialAction()));
                }
                return result.items.isEmpty() ? null : result;
            }
            return null;
        }

        public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
            return this.getContextMenu("");
        }

        @WebMethod(name={"config.xml"})
        @Restricted(value={NoExternalUse.class})
        public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException {
            if (req.getMethod().equals("GET")) {
                this.getStore().checkPermission(VIEW);
                rsp.setContentType("application/xml");
                SECRETS_REDACTED.toXML((Object)this.credentials, (Writer)new OutputStreamWriter((OutputStream)rsp.getOutputStream(), rsp.getCharacterEncoding()));
                return;
            }
            if (req.getMethod().equals("POST")) {
                this.updateByXml(new StreamSource(req.getReader()));
                return;
            }
            if (req.getMethod().equals("DELETE")) {
                this.getStore().checkPermission(DELETE);
                if (this.getStore().removeCredentials(this.domain.getDomain(), this.credentials)) {
                    return;
                }
                rsp.sendError(409);
                return;
            }
            rsp.sendError(400);
        }

        @Restricted(value={NoExternalUse.class})
        public void updateByXml(Source source) throws IOException {
            this.getStore().checkPermission(UPDATE);
            StringWriter out = new StringWriter();
            try {
                XMLUtils.safeTransform((Source)source, (Result)new StreamResult(out));
                out.close();
            }
            catch (TransformerException e) {
                throw new IOException("Failed to parse credential", e);
            }
            catch (SAXException e) {
                throw new IOException("Failed to parse credential", e);
            }
            Credentials credentials = (Credentials)Items.XSTREAM.unmarshal(new XppDriver().createReader((Reader)new StringReader(out.toString())));
            this.getStore().updateCredentials(this.domain.getDomain(), this.credentials, credentials);
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CredentialsWrapper> {
            @Restricted(value={NoExternalUse.class})
            public DescriptorExtensionList<Credentials, CredentialsDescriptor> getCredentialDescriptors() {
                return CredentialsProvider.allCredentialsDescriptors();
            }

            public String getDisplayName() {
                return "Credential";
            }
        }
    }

    @ExportedBean
    public static class DomainWrapper
    extends AbstractDescribableImpl<DomainWrapper>
    implements ModelObjectWithContextMenu,
    ModelObjectWithChildren {
        private final CredentialsStoreAction parent;
        private final Domain domain;

        public DomainWrapper(CredentialsStoreAction parent, Domain domain) {
            this.parent = parent;
            this.domain = domain;
        }

        public Api getApi() {
            return new Api((Object)this);
        }

        public CredentialsStore getStore() {
            return this.getParent().getStore();
        }

        public Domain getDomain() {
            return this.domain;
        }

        public CredentialsStoreAction getParent() {
            return this.parent;
        }

        @Exported
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="isGlobal() check implies that domain.getName() is null")
        public String getUrlName() {
            return this.isGlobal() ? "_" : Util.rawEncode((String)this.domain.getName());
        }

        @Exported
        public String getDisplayName() {
            return this.isGlobal() ? Messages.CredentialsStoreAction_GlobalDomainDisplayName() : this.domain.getName();
        }

        @Exported
        public final String getFullName() {
            String n = this.getParent().getFullName();
            if (n.length() == 0) {
                return this.getUrlName();
            }
            return n + '/' + this.getUrlName();
        }

        @Exported
        public final String getFullDisplayName() {
            String n = this.getParent().getFullDisplayName();
            if (n.length() == 0) {
                return this.getDisplayName();
            }
            return n + " \u00bb " + this.getDisplayName();
        }

        @Exported
        public String getDescription() {
            return this.isGlobal() ? Messages.CredentialsStoreAction_GlobalDomainDescription() : this.domain.getDescription();
        }

        @Exported
        public boolean isGlobal() {
            return this.domain == Domain.global();
        }

        public CredentialsWrapper.DescriptorImpl getCredentialDescriptor() {
            return (CredentialsWrapper.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(CredentialsWrapper.DescriptorImpl.class);
        }

        @NonNull
        public Map<String, CredentialsWrapper> getCredentials() {
            LinkedHashMap<String, CredentialsWrapper> result = new LinkedHashMap<String, CredentialsWrapper>();
            int index = 0;
            for (Credentials c : this.getStore().getCredentials(this.domain)) {
                String id;
                if (c instanceof IdCredentials) {
                    id = ((IdCredentials)c).getId();
                } else {
                    while (result.containsKey("index-" + index)) {
                        ++index;
                    }
                    id = "index-" + index;
                    ++index;
                }
                result.put(id, new CredentialsWrapper(this, c, id));
            }
            return result;
        }

        @Exported(name="credentials", visibility=1)
        @NonNull
        public List<CredentialsWrapper> getCredentialsList() {
            return new ArrayList<CredentialsWrapper>(this.getCredentials().values());
        }

        @CheckForNull
        public CredentialsWrapper getCredential(String id) {
            return this.getCredentials().get(id);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doCreateCredentials(StaplerRequest req) throws ServletException, IOException {
            this.getStore().checkPermission(CREATE);
            String requestContentType = req.getContentType();
            if (requestContentType == null) {
                throw new Failure("No Content-Type header set");
            }
            if (requestContentType.startsWith("application/xml") || requestContentType.startsWith("text/xml")) {
                StringWriter out = new StringWriter();
                try {
                    XMLUtils.safeTransform((Source)new StreamSource(req.getReader()), (Result)new StreamResult(out));
                    out.close();
                }
                catch (TransformerException e) {
                    throw new IOException("Failed to parse credential", e);
                }
                catch (SAXException e) {
                    throw new IOException("Failed to parse credential", e);
                }
                Credentials credentials = (Credentials)Items.XSTREAM.unmarshal(new XppDriver().createReader((Reader)new StringReader(out.toString())));
                if (this.getStore().addCredentials(this.domain, credentials)) {
                    return HttpResponses.ok();
                }
                return HttpResponses.status((int)409);
            }
            JSONObject data = req.getSubmittedForm();
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data.getJSONObject("credentials"));
            this.getStore().addCredentials(this.domain, credentials);
            return HttpResponses.redirectTo((String)("../../domain/" + this.getUrlName()));
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doConfigSubmit(StaplerRequest req) throws ServletException, IOException {
            if (!this.getStore().isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            this.getStore().checkPermission(MANAGE_DOMAINS);
            JSONObject data = req.getSubmittedForm();
            Domain domain = (Domain)req.bindJSON(Domain.class, data);
            String domainName = domain.getName();
            if (domainName != null && this.getStore().updateDomain(this.domain, domain)) {
                return HttpResponses.redirectTo((String)("../../domain/" + Util.rawEncode((String)domainName)));
            }
            return HttpResponses.redirectToDot();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doDoDelete(StaplerRequest req) throws IOException {
            if (!this.getStore().isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            this.getStore().checkPermission(MANAGE_DOMAINS);
            if (this.getStore().removeDomain(this.domain)) {
                return HttpResponses.redirectTo((String)"../..");
            }
            return HttpResponses.redirectToDot();
        }

        @CheckForNull
        public ModelObjectWithContextMenu.ContextMenu getContextMenu(String prefix) {
            if (this.getStore().hasPermission(CREATE) || this.getStore().hasPermission(MANAGE_DOMAINS) && !this.domain.isGlobal()) {
                ModelObjectWithContextMenu.ContextMenu result = new ModelObjectWithContextMenu.ContextMenu();
                if (this.getStore().hasPermission(CREATE)) {
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "newCredentials"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-credentials-new-credential icon-md"), Messages.CredentialsStoreAction_AddCredentialsAction()));
                }
                if (this.getStore().hasPermission(MANAGE_DOMAINS) && !this.domain.isGlobal()) {
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "configure"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-setting icon-md"), Messages.CredentialsStoreAction_ConfigureDomainAction()));
                    result.add(new ModelObjectWithContextMenu.MenuItem(ContextMenuIconUtils.buildUrl(prefix, "delete"), ContextMenuIconUtils.getMenuItemIconUrlByClassSpec("icon-edit-delete icon-md"), Messages.CredentialsStoreAction_DeleteDomainAction()));
                }
                return result.items.isEmpty() ? null : result;
            }
            return null;
        }

        @CheckForNull
        public ModelObjectWithContextMenu.ContextMenu getChildrenContextMenu(String prefix) {
            ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
            for (Map.Entry<String, CredentialsWrapper> entry : this.getCredentials().entrySet()) {
                String p = ContextMenuIconUtils.buildUrl(prefix, "credential", entry.getKey());
                ModelObjectWithContextMenu.MenuItem item = new ModelObjectWithContextMenu.MenuItem(p, ContextMenuIconUtils.getMenuItemIconUrlByClassSpec(entry.getValue().getIconClassName() + " icon-md"), entry.getValue().getDisplayName());
                item.subMenu = entry.getValue().getContextMenu(p);
                menu.add(item);
            }
            return menu.items.isEmpty() ? null : menu;
        }

        public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
            return this.getContextMenu("");
        }

        public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
            return this.getChildrenContextMenu("");
        }

        @WebMethod(name={"config.xml"})
        @Restricted(value={NoExternalUse.class})
        public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException {
            this.getStore().checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            if (req.getMethod().equals("GET")) {
                rsp.setContentType("application/xml");
                Items.XSTREAM2.toXML((Object)this.domain, (Writer)new OutputStreamWriter((OutputStream)rsp.getOutputStream(), rsp.getCharacterEncoding()));
                return;
            }
            if (req.getMethod().equals("POST") && this.getStore().isDomainsModifiable()) {
                this.updateByXml(new StreamSource(req.getReader()));
                return;
            }
            if (req.getMethod().equals("DELETE") && this.getStore().isDomainsModifiable()) {
                if (this.getStore().removeDomain(this.domain)) {
                    return;
                }
                rsp.sendError(409);
                return;
            }
            rsp.sendError(400);
        }

        @Restricted(value={NoExternalUse.class})
        public void updateByXml(Source source) throws IOException {
            this.getStore().checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            StringWriter out = new StringWriter();
            try {
                XMLUtils.safeTransform((Source)source, (Result)new StreamResult(out));
                out.close();
            }
            catch (TransformerException e) {
                throw new IOException("Failed to parse credential", e);
            }
            catch (SAXException e) {
                throw new IOException("Failed to parse credential", e);
            }
            Domain replacement = (Domain)Items.XSTREAM.unmarshal(new XppDriver().createReader((Reader)new StringReader(out.toString())));
            this.getStore().updateDomain(this.domain, replacement);
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<DomainWrapper> {
            public DescriptorImpl() {
                super(DomainWrapper.class);
            }

            public String getDisplayName() {
                return "Domain";
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckName(@AncestorInPath DomainWrapper wrapper, @AncestorInPath CredentialsStoreAction action, @QueryParameter String value) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CredentialsStoreAction_EmptyDomainNameMessage());
                }
                try {
                    Jenkins.checkGoodName((String)value);
                }
                catch (Failure e) {
                    return FormValidation.error((String)e.getMessage());
                }
                if (action != null) {
                    for (Domain d : action.getStore().getDomains()) {
                        if (wrapper != null && wrapper.domain == d || !value.equals(d.getName())) continue;
                        return FormValidation.error((String)Messages.CredentialsStoreAction_DuplicateDomainNameMessage());
                    }
                }
                return FormValidation.ok();
            }
        }
    }
}

