/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.matchers.AllOfMatcher;
import com.cloudbees.plugins.credentials.matchers.AnyOfMatcher;
import com.cloudbees.plugins.credentials.matchers.BeanPropertyMatcher;
import com.cloudbees.plugins.credentials.matchers.CQLBaseListener;
import com.cloudbees.plugins.credentials.matchers.CQLLexer;
import com.cloudbees.plugins.credentials.matchers.CQLParser;
import com.cloudbees.plugins.credentials.matchers.CQLSyntaxException;
import com.cloudbees.plugins.credentials.matchers.ConstantMatcher;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.cloudbees.plugins.credentials.matchers.InstanceOfMatcher;
import com.cloudbees.plugins.credentials.matchers.NotMatcher;
import com.cloudbees.plugins.credentials.matchers.ScopeMatcher;
import com.cloudbees.plugins.credentials.matchers.UsernameMatcher;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CredentialsMatchers {
    private CredentialsMatchers() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NonNull
    public static CredentialsMatcher always() {
        return new ConstantMatcher(true);
    }

    @NonNull
    public static CredentialsMatcher never() {
        return new ConstantMatcher(false);
    }

    @NonNull
    public static CredentialsMatcher not(@NonNull CredentialsMatcher matcher) {
        return new NotMatcher(matcher);
    }

    @NonNull
    public static CredentialsMatcher instanceOf(@NonNull Class clazz) {
        return new InstanceOfMatcher(clazz);
    }

    @NonNull
    public static CredentialsMatcher withId(@NonNull String id) {
        return new IdMatcher(id);
    }

    @NonNull
    public static CredentialsMatcher withScope(@NonNull CredentialsScope scope) {
        return new ScopeMatcher(scope);
    }

    @NonNull
    public static CredentialsMatcher withScopes(CredentialsScope ... scopes) {
        return new ScopeMatcher(scopes);
    }

    @NonNull
    public static CredentialsMatcher withScopes(@NonNull Collection<CredentialsScope> scopes) {
        return new ScopeMatcher(scopes);
    }

    @NonNull
    public static CredentialsMatcher withUsername(@NonNull String username) {
        return new UsernameMatcher(username);
    }

    public static <T extends Serializable> CredentialsMatcher withProperty(@NonNull String name, @CheckForNull T expected) {
        return new BeanPropertyMatcher<T>(name, expected);
    }

    @NonNull
    public static CredentialsMatcher allOf(CredentialsMatcher ... matchers) {
        return new AllOfMatcher(Arrays.asList(matchers));
    }

    @NonNull
    public static CredentialsMatcher anyOf(CredentialsMatcher ... matchers) {
        return new AnyOfMatcher(Arrays.asList(matchers));
    }

    @NonNull
    public static CredentialsMatcher both(@NonNull CredentialsMatcher matcher1, @NonNull CredentialsMatcher matcher2) {
        return new AllOfMatcher(Arrays.asList(matcher1, matcher2));
    }

    @NonNull
    public static CredentialsMatcher either(@NonNull CredentialsMatcher matcher1, @NonNull CredentialsMatcher matcher2) {
        return new AnyOfMatcher(Arrays.asList(matcher1, matcher2));
    }

    @NonNull
    public static CredentialsMatcher noneOf(CredentialsMatcher ... matchers) {
        return CredentialsMatchers.not(CredentialsMatchers.anyOf(matchers));
    }

    @NonNull
    public static <C extends Credentials> Collection<C> filter(@NonNull Collection<C> credentials, @NonNull CredentialsMatcher matcher) {
        AbstractCollection result = credentials instanceof Set ? new LinkedHashSet() : new ArrayList();
        for (Credentials credential : credentials) {
            if (credential == null || !matcher.matches(credential)) continue;
            result.add(credential);
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> Set<C> filter(@NonNull Set<C> credentials, @NonNull CredentialsMatcher matcher) {
        LinkedHashSet<Credentials> result = new LinkedHashSet<Credentials>();
        for (Credentials credential : credentials) {
            if (credential == null || !matcher.matches(credential)) continue;
            result.add(credential);
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> List<C> filter(@NonNull List<C> credentials, @NonNull CredentialsMatcher matcher) {
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        for (Credentials credential : credentials) {
            if (credential == null || !matcher.matches(credential)) continue;
            result.add(credential);
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials> Iterable<C> filter(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher) {
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        for (Credentials credential : credentials) {
            if (credential == null || !matcher.matches(credential)) continue;
            result.add(credential);
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials, V> Map<C, V> filterKeys(@NonNull Map<C, V> credentialMap, @NonNull CredentialsMatcher matcher) {
        LinkedHashMap<C, V> result = new LinkedHashMap<C, V>();
        for (Map.Entry<C, V> credential : credentialMap.entrySet()) {
            if (credential.getKey() == null || !matcher.matches((Credentials)credential.getKey())) continue;
            result.put(credential.getKey(), credential.getValue());
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials, K> Map<K, C> filterValues(@NonNull Map<K, C> credentialMap, @NonNull CredentialsMatcher matcher) {
        LinkedHashMap<K, C> result = new LinkedHashMap<K, C>();
        for (Map.Entry<K, C> credential : credentialMap.entrySet()) {
            if (credential.getValue() == null || !matcher.matches((Credentials)credential.getValue())) continue;
            result.put(credential.getKey(), credential.getValue());
        }
        return result;
    }

    @CheckForNull
    public static <C extends Credentials> C firstOrDefault(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher, @CheckForNull C defaultIfNone) {
        for (Credentials c : credentials) {
            if (!matcher.matches(c)) continue;
            return (C)c;
        }
        return defaultIfNone;
    }

    @CheckForNull
    public static <C extends Credentials> C firstOrNull(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher) {
        return CredentialsMatchers.firstOrDefault(credentials, matcher, null);
    }

    @CheckForNull
    public static String describe(CredentialsMatcher matcher) {
        return matcher instanceof CredentialsMatcher.CQL ? ((CredentialsMatcher.CQL)matcher).describe() : null;
    }

    @NonNull
    public static CredentialsMatcher parse(final String cql) {
        if (StringUtils.isEmpty((String)cql)) {
            return CredentialsMatchers.always();
        }
        CQLLexer lexer = new CQLLexer((CharStream)new ANTLRInputStream(cql));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CQLParser parser = new CQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                int i;
                StringBuilder expression = new StringBuilder(cql.length() + msg.length() + charPositionInLine + 256);
                String[] lines = StringUtils.split((String)cql, (char)'\n');
                for (i = 0; i < line; ++i) {
                    expression.append("    ").append(lines[i]).append('\n');
                }
                expression.append("    ").append(StringUtils.repeat((String)" ", (int)charPositionInLine)).append("^ ").append(msg);
                for (i = line; i < lines.length; ++i) {
                    expression.append("\n    ").append(lines[i]);
                }
                throw new CQLSyntaxException(String.format("CQL syntax error: line %d:%d%n%s", line, charPositionInLine, expression), charPositionInLine);
            }
        });
        CQLParser.ExpressionContext expressionContext = parser.expression();
        ParseTreeWalker walker = new ParseTreeWalker();
        MatcherBuildingListener listener = new MatcherBuildingListener();
        try {
            walker.walk((ParseTreeListener)listener, (ParseTree)expressionContext);
            return listener.getMatcher();
        }
        catch (EmptyStackException e) {
            throw new IllegalStateException("There should not be an empty stack when starting from an expression", e);
        }
        catch (CQLSyntaxError e) {
            throw new CQLSyntaxException(String.format("CQL syntax error:%n    %s%n    %s%s unexpected symbol %s", cql, StringUtils.repeat((String)" ", (int)((CQLSyntaxError)e).interval.a), StringUtils.repeat((String)"^", (int)e.interval.length()), e.text), ((CQLSyntaxError)e).interval.a);
        }
    }

    private static class CQLSyntaxError
    extends RuntimeException {
        private final String text;
        private final Interval interval;

        private CQLSyntaxError(ErrorNode node) {
            this.text = node.getText();
            int offset = 0;
            for (ErrorNode n = node; n != null; n = n.getParent()) {
                offset += n.getSourceInterval().a;
            }
            this.interval = new Interval(offset + node.getSourceInterval().a, offset + node.getSourceInterval().b);
        }
    }

    private static class MatcherBuildingListener
    extends CQLBaseListener {
        private CredentialsMatcher primary;
        private Serializable literal;
        private Stack<CredentialsMatcher> expression = new Stack();

        private MatcherBuildingListener() {
        }

        private CredentialsMatcher getMatcher() {
            return this.expression.pop();
        }

        @Override
        public void exitExpression(CQLParser.ExpressionContext ctx) {
            if (ctx.AND() != null) {
                CredentialsMatcher second = this.expression.pop();
                CredentialsMatcher first = this.expression.pop();
                this.expression.push(CredentialsMatchers.allOf(first, second));
            } else if (ctx.OR() != null) {
                CredentialsMatcher second = this.expression.pop();
                CredentialsMatcher first = this.expression.pop();
                this.expression.push(CredentialsMatchers.anyOf(first, second));
            } else {
                this.expression.push(this.primary);
            }
        }

        @Override
        public void exitConstantTest(CQLParser.ConstantTestContext ctx) {
            this.primary = new ConstantMatcher(Boolean.parseBoolean(ctx.BooleanLiteral().getSymbol().getText()));
        }

        @Override
        public void exitPropertyTest(CQLParser.PropertyTestContext ctx) {
            this.primary = new BeanPropertyMatcher<Serializable>(ctx.Identifier().getText(), this.literal);
        }

        @Override
        public void exitNegativeTest(CQLParser.NegativeTestContext ctx) {
            this.primary = new NotMatcher(this.primary);
        }

        @Override
        public void exitInstanceOfTest(CQLParser.InstanceOfTestContext ctx) {
            try {
                this.primary = new InstanceOfMatcher(Class.forName(ctx.qualifiedName().getText()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void exitGroupedTest(CQLParser.GroupedTestContext ctx) {
            this.primary = this.expression.pop();
        }

        @Override
        public void exitLiteral(CQLParser.LiteralContext ctx) {
            if (ctx.BooleanLiteral() != null) {
                this.literal = Boolean.valueOf(ctx.BooleanLiteral().getText());
            } else if (ctx.StringLiteral() != null) {
                String text = ctx.StringLiteral().getText();
                this.literal = StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1));
            } else if (ctx.CharacterLiteral() != null) {
                String text = ctx.StringLiteral().getText();
                this.literal = Character.valueOf(StringEscapeUtils.unescapeJava((String)text.substring(1, text.length() - 1)).charAt(0));
            } else if (ctx.IntegerLiteral() != null) {
                this.literal = Integer.valueOf(ctx.IntegerLiteral().getText());
            } else if (ctx.FloatingPointLiteral() != null) {
                this.literal = Double.valueOf(ctx.FloatingPointLiteral().getText());
            } else if (ctx.NullLiteral() != null) {
                this.literal = null;
            } else if (ctx.enumLiteral() != null) {
                String enumClass = ctx.enumLiteral().qualifiedName().getText();
                String enumConst = ctx.enumLiteral().Identifier().getText();
                try {
                    Class<?> enumClazz = Class.forName(enumClass);
                    Field field = enumClazz.getDeclaredField(enumConst);
                    this.literal = (Serializable)field.get(null);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void visitErrorNode(ErrorNode node) {
            throw new CQLSyntaxError(node);
        }
    }
}

