/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import hudson.model.Items;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.kohsuke.args4j.Argument;

@Extension
public class GetCredentialsDomainAsXmlCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;

    public String getShortDescription() {
        return Messages.GetCredentialsDomainAsXmlCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.UPDATE);
        Domain domain = GetCredentialsDomainAsXmlCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        Items.XSTREAM2.toXML((Object)domain, (Writer)new OutputStreamWriter((OutputStream)this.stdout, "UTF-8"));
        return 0;
    }
}

