/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import com.trilead.ssh2.crypto.Base64;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.remoting.Channel;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.IOUtils;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CertificateCredentialsImpl
extends BaseStandardCredentials
implements StandardCertificateCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CertificateCredentialsImpl.class.getName());
    private final KeyStoreSource keyStoreSource;
    private final Secret password;
    @GuardedBy(value="this")
    @CheckForNull
    private transient KeyStore keyStore;
    @GuardedBy(value="this")
    private transient long keyStoreLastModified;

    @DataBoundConstructor
    public CertificateCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String password, @NonNull KeyStoreSource keyStoreSource) {
        super(scope, id, description);
        ((Object)((Object)keyStoreSource)).getClass();
        this.password = Secret.fromString((String)password);
        this.keyStoreSource = keyStoreSource;
    }

    @CheckForNull
    private static char[] toCharArray(@NonNull Secret password) {
        String plainText = Util.fixEmpty((String)password.getPlainText());
        return plainText == null ? null : plainText.toCharArray();
    }

    private Object writeReplace() {
        if (Channel.current() == null || this.keyStoreSource.isSnapshotSource()) {
            return this;
        }
        return CredentialsProvider.snapshot(this);
    }

    @Override
    @NonNull
    public synchronized KeyStore getKeyStore() {
        long lastModified = this.keyStoreSource.getKeyStoreLastModified();
        if (this.keyStore == null || this.keyStoreLastModified < lastModified) {
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("PKCS12 is a keystore type per the JLS spec", e);
            }
            try {
                keyStore.load(new ByteArrayInputStream(this.keyStoreSource.getKeyStoreBytes()), CertificateCredentialsImpl.toCharArray(this.password));
            }
            catch (CertificateException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from {1}");
                lr.setParameters(new Object[]{this.getId(), this.keyStoreSource});
                lr.setThrown(e);
                LOGGER.log(lr);
            }
            catch (NoSuchAlgorithmException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from {1}");
                lr.setParameters(new Object[]{this.getId(), this.keyStoreSource});
                lr.setThrown(e);
                LOGGER.log(lr);
            }
            catch (IOException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from {1}");
                lr.setParameters(new Object[]{this.getId(), this.keyStoreSource});
                lr.setThrown(e);
                LOGGER.log(lr);
            }
            this.keyStore = keyStore;
            this.keyStoreLastModified = lastModified;
        }
        return this.keyStore;
    }

    @Override
    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    public boolean isPasswordEmpty() {
        return StringUtils.isEmpty((String)this.password.getPlainText());
    }

    public KeyStoreSource getKeyStoreSource() {
        return this.keyStoreSource;
    }

    @Extension
    public static class CredentialsSnapshotTakerImpl
    extends CredentialsSnapshotTaker<StandardCertificateCredentials> {
        @Override
        public Class<StandardCertificateCredentials> type() {
            return StandardCertificateCredentials.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StandardCertificateCredentials snapshot(StandardCertificateCredentials credentials) {
            if (credentials instanceof CertificateCredentialsImpl) {
                KeyStoreSource keyStoreSource = ((CertificateCredentialsImpl)credentials).getKeyStoreSource();
                if (keyStoreSource.isSnapshotSource()) {
                    return credentials;
                }
                return new CertificateCredentialsImpl(credentials.getScope(), credentials.getId(), credentials.getDescription(), credentials.getPassword().getEncryptedValue(), new UploadedKeyStoreSource(SecretBytes.fromBytes(keyStoreSource.getKeyStoreBytes())));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            char[] password = credentials.getPassword().getPlainText().toCharArray();
            try {
                credentials.getKeyStore().store(bos, password);
                bos.close();
            }
            catch (KeyStoreException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (IOException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (NoSuchAlgorithmException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (CertificateException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
            return new CertificateCredentialsImpl(credentials.getScope(), credentials.getId(), credentials.getDescription(), credentials.getPassword().getEncryptedValue(), new UploadedKeyStoreSource(SecretBytes.fromBytes(bos.toByteArray())));
        }
    }

    public static class UploadedKeyStoreSource
    extends KeyStoreSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterKeyStoreSource.class.getName());
        @Deprecated
        @CheckForNull
        private transient Secret uploadedKeystore;
        @CheckForNull
        private final SecretBytes uploadedKeystoreBytes;

        @Deprecated
        public UploadedKeyStoreSource(String uploadedKeystore) {
            this.uploadedKeystoreBytes = StringUtils.isBlank((String)uploadedKeystore) ? null : SecretBytes.fromBytes(DescriptorImpl.toByteArray(Secret.fromString((String)uploadedKeystore)));
        }

        @DataBoundConstructor
        public UploadedKeyStoreSource(SecretBytes uploadedKeystore) {
            this.uploadedKeystoreBytes = uploadedKeystore;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.uploadedKeystore != null && this.uploadedKeystoreBytes == null) {
                return new UploadedKeyStoreSource(SecretBytes.fromBytes(DescriptorImpl.toByteArray(this.uploadedKeystore)));
            }
            return this;
        }

        public SecretBytes getUploadedKeystore() {
            return this.uploadedKeystoreBytes;
        }

        @Override
        @NonNull
        public byte[] getKeyStoreBytes() {
            return SecretBytes.getPlainData(this.uploadedKeystoreBytes);
        }

        @Override
        public long getKeyStoreLastModified() {
            return 0L;
        }

        @Override
        public boolean isSnapshotSource() {
            return true;
        }

        public String toString() {
            return "UploadedKeyStoreSource{uploadedKeystoreBytes=******}";
        }

        public static class Upload {
            @NonNull
            private final String divId;
            @CheckForNull
            private final SecretBytes uploadedKeystore;

            public Upload(@NonNull String divId, @CheckForNull SecretBytes uploadedKeystore) {
                this.divId = divId;
                this.uploadedKeystore = uploadedKeystore;
            }

            @NonNull
            public String getDivId() {
                return this.divId;
            }

            public SecretBytes getUploadedKeystore() {
                return this.uploadedKeystore;
            }

            @NonNull
            public HttpResponse doUpload(@NonNull StaplerRequest req) throws ServletException, IOException {
                FileItem file = req.getFileItem("certificate.file");
                if (file == null) {
                    throw new ServletException("no file upload");
                }
                SecretBytes uploadedKeystore = SecretBytes.fromBytes(file.get());
                return HttpResponses.forwardToView((Object)new Upload(this.getDivId(), uploadedKeystore), (String)"complete");
            }
        }

        @Extension
        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            @NonNull
            public static byte[] toByteArray(@Nullable Secret secret) {
                if (secret != null) {
                    try {
                        return Base64.decode((char[])secret.getPlainText().toCharArray());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return new byte[0];
            }

            @Deprecated
            @CheckForNull
            public static Secret toSecret(@Nullable byte[] contents) {
                return contents == null || contents.length == 0 ? null : Secret.fromString((String)new String(Base64.encode((byte[])contents)));
            }

            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_UploadedKeyStoreSourceDisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckUploadedKeystore(@QueryParameter String value, @QueryParameter String password) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_NoCertificateUploaded());
                }
                SecretBytes secretBytes = SecretBytes.fromString(value);
                byte[] keystoreBytes = secretBytes.getPlainData();
                if (keystoreBytes == null || keystoreBytes.length == 0) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                }
                return DescriptorImpl.validateCertificateKeystore("PKCS12", keystoreBytes, password);
            }

            @Restricted(value={NoExternalUse.class})
            public Upload getUpload(String divId) {
                return new Upload(divId, null);
            }
        }
    }

    public static class FileOnMasterKeyStoreSource
    extends KeyStoreSource {
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterKeyStoreSource.class.getName());
        private final String keyStoreFile;

        @DataBoundConstructor
        public FileOnMasterKeyStoreSource(String keyStoreFile) {
            this.keyStoreFile = keyStoreFile;
        }

        @Override
        @NonNull
        public byte[] getKeyStoreBytes() {
            byte[] byArray;
            FileInputStream inputStream = new FileInputStream(new File(this.keyStoreFile));
            try {
                byArray = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not read private key file " + this.keyStoreFile, e);
                    return new byte[0];
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return byArray;
        }

        public String getKeyStoreFile() {
            return this.keyStoreFile;
        }

        @Override
        public long getKeyStoreLastModified() {
            return new File(this.keyStoreFile).lastModified();
        }

        public String toString() {
            return "FileOnMasterKeyStoreSource{keyStoreFile='" + this.keyStoreFile + '\'' + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_FileOnMasterKeyStoreSourceDisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public FormValidation doCheckKeyStoreFile(@QueryParameter String value, @QueryParameter String password) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileUnspecified());
                }
                File file = new File(value);
                if (file.isFile()) {
                    try {
                        return DescriptorImpl.validateCertificateKeystore("PKCS12", FileUtils.readFileToByteArray((File)file), password);
                    }
                    catch (IOException e) {
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileUnreadable(value), (Object[])new Object[]{e});
                    }
                }
                return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileDoesNotExist(value));
            }
        }
    }

    public static abstract class KeyStoreSourceDescriptor
    extends Descriptor<KeyStoreSource> {
        protected KeyStoreSourceDescriptor() {
        }

        protected KeyStoreSourceDescriptor(Class<? extends KeyStoreSource> clazz) {
            super(clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        protected static FormValidation validateCertificateKeystore(String type, byte[] keystoreBytes, String password) {
            if (keystoreBytes == null || keystoreBytes.length == 0) {
                return FormValidation.warning((String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
            }
            char[] passwordChars = CertificateCredentialsImpl.toCharArray(Secret.fromString((String)password));
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                keyStore.load(new ByteArrayInputStream(keystoreBytes), passwordChars);
                int size = keyStore.size();
                if (size == 0) {
                    FormValidation formValidation = FormValidation.warning((String)Messages.CertificateCredentialsImpl_EmptyKeystore());
                    return formValidation;
                }
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(alias);
                    if (keyStore.isCertificateEntry(alias)) {
                        keyStore.getCertificate(alias);
                        continue;
                    }
                    if (!keyStore.isKeyEntry(alias)) continue;
                    if (passwordChars == null) {
                        FormValidation formValidation = FormValidation.warning((String)Messages.CertificateCredentialsImpl_LoadKeyFailedQueryEmptyPassword(alias));
                        return formValidation;
                    }
                    try {
                        keyStore.getKey(alias, passwordChars);
                    }
                    catch (UnrecoverableEntryException e) {
                        FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeyFailed(alias));
                        if (passwordChars != null) {
                            Arrays.fill(passwordChars, ' ');
                        }
                        return formValidation;
                    }
                }
                FormValidation formValidation = FormValidation.ok((String)StringUtils.defaultIfEmpty((String)StandardCertificateCredentials.NameProvider.getSubjectDN(keyStore), (String)buf.toString()));
                return formValidation;
            }
            catch (KeyStoreException e) {
                FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                return formValidation;
            }
            catch (CertificateException e) {
                FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                return formValidation;
            }
            catch (NoSuchAlgorithmException e) {
                FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                return formValidation;
            }
            catch (IOException e) {
                FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                return formValidation;
            }
            finally {
                if (passwordChars != null) {
                    Arrays.fill(passwordChars, ' ');
                }
            }
        }
    }

    public static abstract class KeyStoreSource
    extends AbstractDescribableImpl<KeyStoreSource> {
        @NonNull
        public abstract byte[] getKeyStoreBytes();

        public abstract long getKeyStoreLastModified();

        public boolean isSnapshotSource() {
            return false;
        }
    }

    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.CertificateCredentialsImpl_DisplayName();
        }

        @Override
        public String getIconClassName() {
            return "icon-credentials-certificate";
        }
    }
}

