/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsTypeFilterDescriptor;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class CredentialsTypeFilter
extends AbstractDescribableImpl<CredentialsTypeFilter>
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 1L;

    public abstract boolean filter(CredentialsDescriptor var1);

    public CredentialsTypeFilterDescriptor getDescriptor() {
        return (CredentialsTypeFilterDescriptor)super.getDescriptor();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class Excludes
    extends CredentialsTypeFilter {
        private static final long serialVersionUID = 1L;
        private final Set<String> classNames;

        @DataBoundConstructor
        public Excludes(@CheckForNull List<String> classNames) {
            this.classNames = new LinkedHashSet<String>(Util.fixNull(classNames));
        }

        @Override
        public boolean filter(CredentialsDescriptor type) {
            return !this.classNames.contains(((Object)((Object)type)).getClass().getName());
        }

        @NonNull
        public List<String> getClassNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (CredentialsDescriptor type : ExtensionList.lookup(CredentialsDescriptor.class)) {
                if (!this.classNames.contains(((Object)((Object)type)).getClass().getName())) continue;
                result.add(((Object)((Object)type)).getClass().getName());
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Excludes excludes = (Excludes)o;
            return this.classNames.equals(excludes.classNames);
        }

        @Override
        public int hashCode() {
            return this.classNames.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Excludes{");
            sb.append("classes=").append(this.getClassNames());
            sb.append('}');
            return sb.toString();
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsTypeFilterDescriptor {
            public String getDisplayName() {
                return Messages.CredentialsTypeFilter_Excludes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public List<CredentialsDescriptor> getTypeDescriptors() {
                return ExtensionList.lookup(CredentialsDescriptor.class);
            }
        }
    }

    public static class Includes
    extends CredentialsTypeFilter {
        private static final long serialVersionUID = 1L;
        private final Set<String> classNames;

        @DataBoundConstructor
        public Includes(@CheckForNull List<String> classNames) {
            this.classNames = new LinkedHashSet<String>(Util.fixNull(classNames));
        }

        @Override
        public boolean filter(CredentialsDescriptor type) {
            return this.classNames.contains(((Object)((Object)type)).getClass().getName());
        }

        @NonNull
        public List<String> getClassNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (CredentialsDescriptor type : ExtensionList.lookup(CredentialsDescriptor.class)) {
                if (!this.classNames.contains(((Object)((Object)type)).getClass().getName())) continue;
                result.add(((Object)((Object)type)).getClass().getName());
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Includes includes = (Includes)o;
            return this.classNames.equals(includes.classNames);
        }

        @Override
        public int hashCode() {
            return this.classNames.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Includes{");
            sb.append("classes=").append(this.getClassNames());
            sb.append('}');
            return sb.toString();
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsTypeFilterDescriptor {
            public String getDisplayName() {
                return Messages.CredentialsTypeFilter_Includes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public List<CredentialsDescriptor> getTypeDescriptors() {
                return ExtensionList.lookup(CredentialsDescriptor.class);
            }
        }
    }

    public static class None
    extends CredentialsTypeFilter {
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public None() {
        }

        @Override
        public boolean filter(CredentialsDescriptor type) {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return None.class.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("None{");
            sb.append('}');
            return sb.toString();
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsTypeFilterDescriptor {
            public String getDisplayName() {
                return Messages.CredentialsTypeFilter_None_DisplayName();
            }
        }
    }
}

