/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameComparator;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.CredentialsProviderManager;
import com.cloudbees.plugins.credentials.CredentialsResolver;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.ListBoxModel;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class CredentialsProvider
extends Descriptor<CredentialsProvider>
implements ExtensionPoint,
Describable<CredentialsProvider>,
IconSpec {
    public static final PermissionGroup GROUP = new PermissionGroup(CredentialsProvider.class, Messages._CredentialsProvider_PermissionGroupTitle());
    public static final Permission USE_OWN = new Permission(GROUP, "UseOwn", Messages._CredentialsProvider_UseOwnPermissionDescription(), Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission") ? Jenkins.ADMINISTER : Job.BUILD, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseOwnPermission"), new PermissionScope[]{PermissionScope.ITEM});
    public static final Permission USE_ITEM = new Permission(GROUP, "UseItem", Messages._CredentialsProvider_UseItemPermissionDescription(), Job.CONFIGURE, Boolean.getBoolean("com.cloudbees.plugins.credentials.UseItemPermission"), new PermissionScope[]{PermissionScope.ITEM});
    private static final Logger LOGGER = Logger.getLogger(CredentialsProvider.class.getName());
    private static final PermissionScope[] SCOPES = new PermissionScope[]{PermissionScope.ITEM, PermissionScope.ITEM_GROUP, PermissionScope.JENKINS};
    public static final Permission CREATE = new Permission(GROUP, "Create", Messages._CredentialsProvider_CreatePermissionDescription(), Permission.CREATE, true, SCOPES);
    public static final Permission UPDATE = new Permission(GROUP, "Update", Messages._CredentialsProvider_UpdatePermissionDescription(), Permission.UPDATE, true, SCOPES);
    public static final Permission VIEW = new Permission(GROUP, "View", Messages._CredentialsProvider_ViewPermissionDescription(), Permission.READ, true, SCOPES);
    public static final Permission DELETE = new Permission(GROUP, "Delete", Messages._CredentialsProvider_DeletePermissionDescription(), Permission.DELETE, true, SCOPES);
    public static final Permission MANAGE_DOMAINS = new Permission(GROUP, "ManageDomains", Messages._CredentialsProvider_ManageDomainsPermissionDescription(), Permission.CONFIGURE, true, SCOPES);

    public CredentialsProvider() {
        super(Descriptor.self());
    }

    public static DescriptorExtensionList<Credentials, CredentialsDescriptor> allCredentialsDescriptors() {
        return Jenkins.getActiveInstance().getDescriptorList(Credentials.class);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type) {
        return CredentialsProvider.lookupCredentials(type, (Item)null, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), authentication);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item) {
        return item == null ? CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), ACL.SYSTEM) : CredentialsProvider.lookupCredentials(type, item, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, ACL.SYSTEM);
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @Deprecated
    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Collections.<DomainRequirement>emptyList());
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, itemGroup, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        type.getClass();
        Jenkins jenkins = Jenkins.getActiveInstance();
        itemGroup = itemGroup == null ? jenkins : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), itemGroup, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(itemGroup) || !provider.isApplicable(type)) continue;
            try {
                result.addAll(provider.getCredentials(type, itemGroup, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + (Object)((Object)provider) + " likely due to missing optional dependency", e);
            }
        }
        Collections.sort(result, new CredentialsNameComparator());
        return result;
    }

    public static <C extends IdCredentials> ListBoxModel listCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        type.getClass();
        Jenkins jenkins = Jenkins.getActiveInstance();
        itemGroup = itemGroup == null ? jenkins : itemGroup;
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        matcher = matcher == null ? CredentialsMatchers.always() : matcher;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null && IdCredentials.class.isAssignableFrom(resolver.getFromClass())) {
            LOGGER.log(Level.FINE, "Listing legacy credentials of type {0} identified by resolver {1}", new Object[]{type, resolver});
            return CredentialsProvider.listCredentials(resolver.getFromClass(), itemGroup, authentication, domainRequirements, matcher);
        }
        ListBoxModel result = new ListBoxModel();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(itemGroup) || !provider.isApplicable(type)) continue;
            try {
                result.addAll((Collection)provider.getCredentialIds(type, itemGroup, authentication, domainRequirements, matcher));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + (Object)((Object)provider) + " likely due to missing optional dependency", e);
            }
        }
        Collections.sort(result, new ListBoxModelOptionComparator());
        return result;
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.lookupCredentials(type, item, authentication, Arrays.asList(domainRequirements));
    }

    @NonNull
    public static <C extends Credentials> List<C> lookupCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements) {
        type.getClass();
        if (item == null) {
            return CredentialsProvider.lookupCredentials(type, (ItemGroup)Jenkins.getInstance(), authentication, domainRequirements);
        }
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null) {
            LOGGER.log(Level.FINE, "Resolving legacy credentials of type {0} with resolver {1}", new Object[]{type, resolver});
            List<Credentials> originals = CredentialsProvider.lookupCredentials(resolver.getFromClass(), item, authentication, domainRequirements);
            LOGGER.log(Level.FINE, "Original credentials for resolving: {0}", originals);
            return resolver.resolve(originals);
        }
        ArrayList<C> result = new ArrayList<C>();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(item) || !provider.isApplicable(type)) continue;
            try {
                result.addAll(provider.getCredentials(type, item, authentication, domainRequirements));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + (Object)((Object)provider) + " likely due to missing optional dependency", e);
            }
        }
        Collections.sort(result, new CredentialsNameComparator());
        return result;
    }

    @NonNull
    public static <C extends IdCredentials> ListBoxModel listCredentials(@NonNull Class<C> type, @Nullable Item item, @Nullable Authentication authentication, @Nullable List<DomainRequirement> domainRequirements, @Nullable CredentialsMatcher matcher) {
        type.getClass();
        if (item == null) {
            return CredentialsProvider.listCredentials(type, (ItemGroup)Jenkins.getInstance(), authentication, domainRequirements, matcher);
        }
        authentication = authentication == null ? ACL.SYSTEM : authentication;
        domainRequirements = domainRequirements == null ? Collections.emptyList() : domainRequirements;
        CredentialsResolver<Credentials, C> resolver = CredentialsResolver.getResolver(type);
        if (resolver != null && IdCredentials.class.isAssignableFrom(resolver.getFromClass())) {
            LOGGER.log(Level.FINE, "Listing legacy credentials of type {0} identified by resolver {1}", new Object[]{type, resolver});
            return CredentialsProvider.listCredentials(resolver.getFromClass(), item, authentication, domainRequirements, matcher);
        }
        ListBoxModel result = new ListBoxModel();
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(item) || !provider.isApplicable(type)) continue;
            try {
                result.addAll((Collection)provider.getCredentialIds(type, item, authentication, domainRequirements, matcher));
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.FINE, "Could not retrieve provider credentials from " + (Object)((Object)provider) + " likely due to missing optional dependency", e);
            }
        }
        Collections.sort(result, new ListBoxModelOptionComparator());
        return result;
    }

    @CheckForNull
    public static Set<CredentialsScope> lookupScopes(ModelObject object) {
        if (object instanceof CredentialsStoreAction.CredentialsWrapper) {
            object = ((CredentialsStoreAction.CredentialsWrapper)object).getStore().getContext();
        }
        if (object instanceof CredentialsStoreAction.DomainWrapper) {
            object = ((CredentialsStoreAction.DomainWrapper)object).getStore().getContext();
        }
        LinkedHashSet<CredentialsScope> result = null;
        for (CredentialsProvider provider : CredentialsProvider.all()) {
            if (!provider.isEnabled(object)) continue;
            try {
                Set<CredentialsScope> scopes = provider.getScopes(object);
                if (scopes == null) continue;
                if (result == null) {
                    result = new LinkedHashSet<CredentialsScope>();
                }
                result.addAll(scopes);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return result;
    }

    public static Iterable<CredentialsStore> lookupStores(final ModelObject object) {
        final ExtensionList<CredentialsProvider> providers = CredentialsProvider.all();
        return new Iterable<CredentialsStore>(){

            @Override
            public Iterator<CredentialsStore> iterator() {
                return new Iterator<CredentialsStore>(){
                    private ModelObject current;
                    private Iterator<CredentialsProvider> iterator;
                    private CredentialsStore next;
                    {
                        this.current = object;
                        this.iterator = providers.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.current != null) {
                            while (this.iterator.hasNext()) {
                                CredentialsProvider p = this.iterator.next();
                                if (!p.isEnabled(object)) continue;
                                this.next = p.getStore(this.current);
                                if (this.next == null) continue;
                                return true;
                            }
                            if (this.current instanceof Item) {
                                this.current = ((Item)this.current).getParent();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            if (this.current instanceof User) {
                                Authentication a;
                                Jenkins jenkins = Jenkins.getActiveInstance();
                                if (jenkins.hasPermission(USE_ITEM) && this.current == User.current()) {
                                    a = Jenkins.getAuthentication();
                                } else {
                                    try {
                                        a = ((User)this.current).impersonate();
                                    }
                                    catch (UsernameNotFoundException e) {
                                        a = null;
                                    }
                                }
                                if (this.current == User.current() && jenkins.getACL().hasPermission(a, USE_ITEM)) {
                                    this.current = jenkins;
                                    this.iterator = providers.iterator();
                                    continue;
                                }
                                this.current = null;
                                continue;
                            }
                            if (this.current instanceof Jenkins) {
                                this.current = null;
                                continue;
                            }
                            if (this.current instanceof ComputerSet) {
                                this.current = Jenkins.getActiveInstance();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            if (this.current instanceof Computer) {
                                this.current = Jenkins.getActiveInstance();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            if (this.current instanceof Node) {
                                this.current = Jenkins.getActiveInstance();
                                this.iterator = providers.iterator();
                                continue;
                            }
                            this.current = Jenkins.getActiveInstance();
                            this.iterator = providers.iterator();
                        }
                        return false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CredentialsStore next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        try {
                            CredentialsStore credentialsStore = this.next;
                            return credentialsStore;
                        }
                        finally {
                            this.next = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <C extends Credentials> C snapshot(C credential) {
        return (C)CredentialsProvider.snapshot(Credentials.class, credential);
    }

    public static <C extends Credentials> C snapshot(Class<C> clazz, C credential) {
        Class bestType = null;
        CredentialsSnapshotTaker bestTaker = null;
        for (CredentialsSnapshotTaker taker : ExtensionList.lookup(CredentialsSnapshotTaker.class)) {
            if (!clazz.isAssignableFrom(taker.type()) || !taker.type().isInstance(credential) || bestTaker != null && !bestType.isAssignableFrom(taker.type())) continue;
            bestTaker = taker;
            bestType = taker.type();
        }
        if (bestTaker == null) {
            return credential;
        }
        return (C)((Credentials)clazz.cast(bestTaker.snapshot(credential)));
    }

    @NonNull
    static Authentication getDefaultAuthenticationOf(Item item) {
        if (item instanceof Queue.Task) {
            return Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item));
        }
        return ACL.SYSTEM;
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, DomainRequirement ... domainRequirements) {
        return CredentialsProvider.findCredentialById(id, type, run, Arrays.asList(domainRequirements));
    }

    @CheckForNull
    public static <C extends IdCredentials> C findCredentialById(@NonNull String id, @NonNull Class<C> type, @NonNull Run<?, ?> run, @Nullable List<DomainRequirement> domainRequirements) {
        ParameterValue parameter;
        ParametersAction action;
        id.getClass();
        type.getClass();
        run.getClass();
        id = id.trim();
        boolean isParameter = false;
        boolean isDefaultValue = false;
        if (id.startsWith("${") && id.endsWith("}") && (action = (ParametersAction)run.getAction(ParametersAction.class)) != null && (parameter = action.getParameter(id.substring(2, id.length() - 1))) instanceof CredentialsParameterValue) {
            isParameter = true;
            isDefaultValue = ((CredentialsParameterValue)parameter).isDefaultValue();
            id = ((CredentialsParameterValue)parameter).getValue();
        }
        if (!isParameter || isDefaultValue) {
            Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf((Item)run.getParent());
            ArrayList<C> candidates = new ArrayList<C>();
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM && run.getACL().hasPermission(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), ACL.SYSTEM, domainRequirements));
            }
            return (C)((IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id)));
        }
        Map.Entry<User, Run<?, ?>> triggeredBy = CredentialsProvider.triggeredBy(run);
        Authentication a = triggeredBy == null ? Jenkins.ANONYMOUS : triggeredBy.getKey().impersonate();
        ArrayList<C> candidates = new ArrayList<C>();
        if (triggeredBy != null && run == triggeredBy.getValue() && run.getACL().hasPermission(a, USE_OWN)) {
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), a, domainRequirements));
        }
        if (run.getACL().hasPermission(a, USE_ITEM)) {
            Authentication runAuth = CredentialsProvider.getDefaultAuthenticationOf((Item)run.getParent());
            candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), runAuth, domainRequirements));
            if (runAuth != ACL.SYSTEM && run.getACL().hasPermission(runAuth, USE_ITEM)) {
                candidates.addAll(CredentialsProvider.lookupCredentials(type, (Item)run.getParent(), ACL.SYSTEM, domainRequirements));
            }
        }
        return (C)((IdCredentials)CredentialsMatchers.firstOrNull(candidates, CredentialsMatchers.withId(id)));
    }

    @CheckForNull
    private static Map.Entry<User, Run<?, ?>> triggeredBy(Run<?, ?> run) {
        Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
        if (cause != null) {
            User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
            return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
        }
        Cause.UpstreamCause c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        Run run2 = run = c != null ? c.getUpstreamRun() : null;
        while (run != null) {
            cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                User u = User.get((String)cause.getUserId(), (boolean)false, Collections.emptyMap());
                return u == null ? null : new AbstractMap.SimpleImmutableEntry<User, Run>(u, run);
            }
            c = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
            run = c != null ? c.getUpstreamRun() : null;
        }
        return null;
    }

    public static ExtensionList<CredentialsProvider> all() {
        return ExtensionList.lookup(CredentialsProvider.class);
    }

    public static List<CredentialsProvider> enabled() {
        ArrayList<CredentialsProvider> providers = new ArrayList<CredentialsProvider>((Collection<CredentialsProvider>)ExtensionList.lookup(CredentialsProvider.class));
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider p = (CredentialsProvider)((Object)iterator.next());
            if (p.isEnabled()) continue;
            iterator.remove();
        }
        return providers;
    }

    public static List<CredentialsProvider> enabled(Object context) {
        ArrayList<CredentialsProvider> providers = new ArrayList<CredentialsProvider>((Collection<CredentialsProvider>)ExtensionList.lookup(CredentialsProvider.class));
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            CredentialsProvider p = (CredentialsProvider)((Object)iterator.next());
            if (p.isEnabled(context)) continue;
            iterator.remove();
        }
        return providers;
    }

    public Descriptor<CredentialsProvider> getDescriptor() {
        return this;
    }

    public final boolean isEnabled() {
        return CredentialsProviderManager.isEnabled(this);
    }

    public boolean isEnabled(Object context) {
        if (!this.isEnabled()) {
            return false;
        }
        for (DescriptorVisibilityFilter filter : DescriptorVisibilityFilter.all()) {
            if (filter.filter(context, (Descriptor)this)) continue;
            return false;
        }
        return true;
    }

    public String getDisplayName() {
        return StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)((Object)((Object)this)).getClass().getSimpleName()), (char)' ');
    }

    public String getIconClassName() {
        return "icon-credentials-credentials";
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return null;
    }

    @CheckForNull
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        return null;
    }

    @NonNull
    public abstract <C extends Credentials> List<C> getCredentials(@NonNull Class<C> var1, @Nullable ItemGroup var2, @Nullable Authentication var3);

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, itemGroup, authentication);
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        ListBoxModel result = new ListBoxModel();
        for (IdCredentials c : this.getCredentials(type, itemGroup, authentication, domainRequirements)) {
            if (!matcher.matches(c)) continue;
            result.add(CredentialsNameProvider.name(c), c.getId());
        }
        return result;
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
        item.getClass();
        return this.getCredentials(type, item.getParent(), authentication);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, item.getParent(), authentication, domainRequirements);
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        ListBoxModel result = new ListBoxModel();
        for (IdCredentials c : this.getCredentials(type, item, authentication, domainRequirements)) {
            if (!matcher.matches(c)) continue;
            result.add(CredentialsNameProvider.name(c), c.getId());
        }
        return result;
    }

    public final boolean isApplicable(Class<? extends Credentials> clazz) {
        if (!this.isEnabled()) {
            return false;
        }
        for (CredentialsDescriptor d : ExtensionList.lookup(CredentialsDescriptor.class)) {
            if (!clazz.isAssignableFrom(d.clazz) || !this.isApplicable(d)) continue;
            return true;
        }
        return false;
    }

    public final boolean isApplicable(Descriptor<?> descriptor) {
        if (!this.isEnabled()) {
            return false;
        }
        if (descriptor instanceof CredentialsDescriptor && !((CredentialsDescriptor)descriptor).isApplicable(this)) {
            return false;
        }
        for (DescriptorVisibilityFilter filter : DescriptorVisibilityFilter.all()) {
            if (filter.filter((Object)this, descriptor)) continue;
            return false;
        }
        return this._isApplicable(descriptor);
    }

    protected boolean _isApplicable(Descriptor<?> descriptor) {
        return true;
    }

    public final List<CredentialsDescriptor> getCredentialsDescriptors() {
        ArrayList<CredentialsDescriptor> result = DescriptorVisibilityFilter.apply((Object)((Object)this), (Iterable)ExtensionList.lookup(CredentialsDescriptor.class));
        if (!(result instanceof ArrayList)) {
            result = new ArrayList<CredentialsDescriptor>(result);
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            CredentialsDescriptor d = (CredentialsDescriptor)((Object)iterator.next());
            if (this._isApplicable(d)) continue;
            iterator.remove();
        }
        return result;
    }

    public final boolean hasCredentialsDescriptors() {
        ExtensionList filters = DescriptorVisibilityFilter.all();
        block0: for (CredentialsDescriptor d : ExtensionList.lookup(CredentialsDescriptor.class)) {
            for (DescriptorVisibilityFilter f : filters) {
                if (f.filter((Object)this, (Descriptor)d)) continue;
                continue block0;
            }
            if (!this._isApplicable(d)) continue;
            return true;
        }
        return false;
    }

    private static class ListBoxModelOptionComparator
    implements Comparator<ListBoxModel.Option> {
        private final Locale locale;
        private transient Collator collator;

        public ListBoxModelOptionComparator() {
            StaplerRequest req = Stapler.getCurrentRequest();
            this.locale = req != null ? req.getLocale() : Locale.getDefault();
            this.collator = Collator.getInstance(this.locale);
        }

        @Override
        public int compare(ListBoxModel.Option o1, ListBoxModel.Option o2) {
            return this.collator.compare(o1.name.toLowerCase(this.locale), o2.name.toLowerCase(this.locale));
        }
    }
}

