/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.util.ListBoxModel;
import java.util.Set;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;

public abstract class CredentialsDescriptor
extends Descriptor<Credentials>
implements IconSpec {
    protected CredentialsDescriptor(Class<? extends Credentials> clazz) {
        super(clazz);
    }

    protected CredentialsDescriptor() {
    }

    public ListBoxModel doFillScopeItems() {
        ListBoxModel m = new ListBoxModel();
        for (Ancestor ancestor = Stapler.getCurrentRequest().findAncestor(Object.class); ancestor != null; ancestor = ancestor.getPrev()) {
            Set<CredentialsScope> scopes;
            if (!(ancestor.getObject() instanceof ModelObject) || (scopes = CredentialsProvider.lookupScopes((ModelObject)ancestor.getObject())) == null) continue;
            for (CredentialsScope scope : scopes) {
                m.add(scope.getDisplayName(), scope.toString());
            }
            break;
        }
        return m;
    }

    public boolean isScopeRelevant() {
        for (Ancestor ancestor = Stapler.getCurrentRequest().findAncestor(Object.class); ancestor != null; ancestor = ancestor.getPrev()) {
            Set<CredentialsScope> scopes;
            if (!(ancestor.getObject() instanceof ModelObject) || (scopes = CredentialsProvider.lookupScopes((ModelObject)ancestor.getObject())) == null) continue;
            return scopes.size() > 1;
        }
        return false;
    }

    public boolean isScopeRelevant(ModelObject object) {
        Set<CredentialsScope> scopes = CredentialsProvider.lookupScopes(object);
        return scopes != null && scopes.size() > 1;
    }

    public boolean isScopeRelevant(CredentialsStoreAction.DomainWrapper wrapper) {
        if (wrapper != null) {
            return this.isScopeRelevant(wrapper.getStore().getContext());
        }
        CredentialsStoreAction action = (CredentialsStoreAction)Stapler.getCurrentRequest().findAncestorObject(CredentialsStoreAction.class);
        if (action != null) {
            return this.isScopeRelevant(action.getStore().getContext());
        }
        return this.isScopeRelevant();
    }

    public boolean isScopeRelevant(CredentialsStoreAction.CredentialsWrapper wrapper) {
        if (wrapper != null) {
            return this.isScopeRelevant(wrapper.getStore().getContext());
        }
        CredentialsStoreAction action = (CredentialsStoreAction)Stapler.getCurrentRequest().findAncestorObject(CredentialsStoreAction.class);
        if (action != null) {
            return this.isScopeRelevant(action.getStore().getContext());
        }
        return this.isScopeRelevant();
    }

    public String getCredentialsPage() {
        return this.getViewPage(this.clazz, "credentials.jelly");
    }

    public String getIconClassName() {
        return "icon-credentials-credential";
    }

    public boolean isApplicable(CredentialsProvider provider) {
        return true;
    }
}

