/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class CredentialsNameProvider<C extends Credentials> {
    private static final Logger LOGGER = Logger.getLogger(CredentialsNameProvider.class.getName());

    @NonNull
    public static String name(@NonNull Credentials credentials) {
        block6: {
            try {
                Result result = CredentialsNameProvider.name(credentials, credentials.getClass());
                if (result != null) {
                    return result.name;
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                if (credentials instanceof IdCredentials) {
                    LogRecord lr = new LogRecord(Level.FINE, "Credential ID {0} Type {1}: Could not infer name");
                    lr.setParameters(new Object[]{((IdCredentials)credentials).getId(), credentials.getClass()});
                    lr.setThrown(e);
                    LOGGER.log(lr);
                }
                LogRecord lr = new LogRecord(Level.FINE, "Credential Type {0}: Could not infer name");
                lr.setParameters(new Object[]{credentials.getClass()});
                lr.setThrown(e);
                LOGGER.log(lr);
            }
        }
        try {
            return credentials.getDescriptor().getDisplayName();
        }
        catch (AssertionError e) {
            return credentials.getClass().getSimpleName();
        }
    }

    @CheckForNull
    private static Result name(@NonNull Credentials credentials, @NonNull Class<?> clazz) {
        NameWith nameWith = clazz.getAnnotation(NameWith.class);
        if (nameWith != null) {
            try {
                CredentialsNameProvider<? extends Credentials> nameProvider = nameWith.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String name = nameProvider.getName(credentials);
                if (!name.isEmpty()) {
                    LOGGER.fine(() -> "named `" + name + "` from " + String.valueOf(nameProvider));
                    return new Result(name, nameWith.priority());
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException nameProvider) {
                // empty catch block
            }
        }
        ArrayList supertypes = new ArrayList();
        Class<?> supe = clazz.getSuperclass();
        if (supe != null) {
            supertypes.add(supe);
        }
        supertypes.addAll(Arrays.asList(clazz.getInterfaces()));
        Result result = null;
        for (Class clazz2 : supertypes) {
            Result _result = CredentialsNameProvider.name(credentials, clazz2);
            if (_result == null || result != null && result.priority >= _result.priority) continue;
            result = _result;
        }
        return result;
    }

    @NonNull
    public abstract String getName(@NonNull C var1);

    private static final class Result {
        final String name;
        final int priority;

        Result(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }
    }
}

