/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class UserCredentialsProvider
extends CredentialsProvider {
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.USER);

    @Override
    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof User) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @Override
    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        if (authentication == null) {
            authentication = ACL.SYSTEM;
        }
        ArrayList<C> result = new ArrayList<C>();
        if (!ACL.SYSTEM.equals(authentication)) {
            UserCredentialsProperty property;
            User user;
            User user2 = user = authentication == null || authentication instanceof AnonymousAuthenticationToken ? null : User.get((String)authentication.getName());
            if (user != null && (property = (UserCredentialsProperty)user.getProperty(UserCredentialsProperty.class)) != null) {
                result.addAll(property.getCredentials(type));
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserCredentialsProperty
    extends UserProperty {
        private final List<Credentials> credentials;

        @DataBoundConstructor
        public UserCredentialsProperty(List<Credentials> credentials) {
            this.credentials = new ArrayList<Credentials>(credentials);
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            ArrayList<C> result = new ArrayList<C>();
            for (Credentials credential : this.credentials) {
                if (!type.isInstance(credential)) continue;
                result.add(type.cast(credential));
            }
            return result;
        }

        public List<Credentials> getCredentials() {
            return this.credentials;
        }

        public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
            User selUser = (User)req.findAncestorObject(User.class);
            User curUser = User.current();
            if (selUser != null && curUser != null && selUser.getId().equals(curUser.getId())) {
                return (UserProperty)this.getDescriptor().newInstance(req, form);
            }
            return this;
        }

        @Extension
        public static class DescriptorImpl
        extends UserPropertyDescriptor {
            public UserProperty newInstance(User user) {
                return new UserCredentialsProperty(Collections.<Credentials>emptyList());
            }

            public String getDisplayName() {
                return Messages.UserCredentialsProvider_DisplayName();
            }

            public boolean isVisible() {
                if (!this.isEnabled()) {
                    return false;
                }
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req == null) {
                    return false;
                }
                User selUser = (User)req.findAncestorObject(User.class);
                User curUser = User.current();
                return selUser != null && curUser != null && selUser.equals(curUser);
            }

            public boolean isEnabled() {
                return !UserProperty.all().isEmpty();
            }
        }
    }
}

