/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.RootAction;
import hudson.model.Saveable;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SystemCredentialsProvider
extends ManagementLink
implements Describable<SystemCredentialsProvider>,
Saveable,
StaplerProxy,
IconSpec {
    private static final Logger LOGGER = Logger.getLogger(SystemCredentialsProvider.class.getName());
    @Deprecated
    private transient List<Credentials> credentials = new CopyOnWriteArrayList<Credentials>();
    private Map<Domain, List<Credentials>> domainCredentialsMap = new CopyOnWriteMap.Hash();
    private transient StoreImpl store = new StoreImpl();

    public SystemCredentialsProvider() {
        try {
            XmlFile xml = SystemCredentialsProvider.getConfigFile();
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read the existing credentials", e);
        }
        this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
        this.credentials = null;
    }

    public String getIconFileName() {
        return CredentialsProvider.allCredentialsDescriptors().isEmpty() ? null : "/plugin/credentials/images/48x48/credentials.png";
    }

    public String getIconClassName() {
        return CredentialsProvider.allCredentialsDescriptors().isEmpty() ? null : "icon-credentials-credentials";
    }

    public String getDisplayName() {
        return Messages.SystemCredentialsProvider_DisplayName();
    }

    public String getDescription() {
        return Messages.SystemCredentialsProvider_Description();
    }

    public String getUrlName() {
        return "credentials";
    }

    public List<Credentials> getCredentials() {
        return this.domainCredentialsMap.get(Domain.global());
    }

    public List<DomainCredentials> getDomainCredentials() {
        return DomainCredentials.asList(this.getDomainCredentialsMap());
    }

    @NonNull
    public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
        this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
        return this.domainCredentialsMap;
    }

    public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
        this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
    }

    private void checkPermission(Permission p) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        jenkins.checkPermission(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkedSave(Permission p) throws IOException {
        this.checkPermission(p);
        Authentication old = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            this.save();
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(old);
        }
    }

    private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            boolean modified = false;
            for (Credentials c : credentials) {
                if (list.contains(c)) continue;
                list.add(c);
                modified = true;
            }
            if (modified) {
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            }
            return modified;
        }
        domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
        this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
        return true;
    }

    private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            domainCredentialsMap.remove(domain);
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }
        return false;
    }

    private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(current)) {
            domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }
        return false;
    }

    private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
        this.checkPermission(CredentialsProvider.CREATE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            if (list.contains(credentials)) {
                return false;
            }
            list.add(credentials);
            this.checkedSave(CredentialsProvider.CREATE);
            return true;
        }
        return false;
    }

    @NonNull
    private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        if (jenkins.hasPermission(CredentialsProvider.VIEW)) {
            List<Credentials> list = this.getDomainCredentialsMap().get(domain);
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<Credentials>(list));
        }
        return Collections.emptyList();
    }

    private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
        this.checkPermission(CredentialsProvider.DELETE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            if (!list.contains(credentials)) {
                return false;
            }
            list.remove(credentials);
            this.checkedSave(CredentialsProvider.DELETE);
            return true;
        }
        return false;
    }

    private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
        this.checkPermission(CredentialsProvider.UPDATE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            int index = list.indexOf(current);
            if (index == -1) {
                return false;
            }
            list.set(index, replacement);
            this.checkedSave(CredentialsProvider.UPDATE);
            return true;
        }
        return false;
    }

    private synchronized StoreImpl getStore() {
        if (this.store == null) {
            this.store = new StoreImpl();
        }
        return this.store;
    }

    public DescriptorExtensionList<Credentials, CredentialsDescriptor> getCredentialDescriptors() {
        return CredentialsProvider.allCredentialsDescriptors();
    }

    public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        return jenkins.getDescriptorList(DomainSpecification.class);
    }

    public Descriptor<SystemCredentialsProvider> getDescriptor() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        return jenkins.getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public Object getTarget() {
        this.checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public HttpResponse doConfigSubmit(StaplerRequest req) throws ServletException, IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        JSONObject data = req.getSubmittedForm();
        this.setDomainCredentialsMap(DomainCredentials.asMap(req.bindJSONToList(DomainCredentials.class, data.get("domainCredentials"))));
        this.save();
        return HttpResponses.redirectToContextRoot();
    }

    public void save() throws IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        SystemCredentialsProvider.getConfigFile().write((Object)this);
    }

    public static XmlFile getConfigFile() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not been started, or was already shut down");
        }
        return new XmlFile(new File(jenkins.getRootDir(), "credentials.xml"));
    }

    public static SystemCredentialsProvider getInstance() {
        return (SystemCredentialsProvider)((Object)SystemCredentialsProvider.all().get(SystemCredentialsProvider.class));
    }

    @ExportedBean
    @Extension
    public static class UserFacingAction
    extends CredentialsStoreAction
    implements RootAction {
        public Api getApi() {
            return new Api((Object)this);
        }

        @Exported
        public CredentialsStore getStore() {
            return SystemCredentialsProvider.getInstance().getStore();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public static class StoreImpl
    extends CredentialsStore {
        @Override
        public ModelObject getContext() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            return jenkins;
        }

        @Override
        public ACL getACL() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            return jenkins.getACL();
        }

        @Override
        public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
            return this.getACL().hasPermission(a, permission);
        }

        @Override
        @Exported
        @NonNull
        public List<Domain> getDomains() {
            return Collections.unmodifiableList(new ArrayList<Domain>(SystemCredentialsProvider.getInstance().getDomainCredentialsMap().keySet()));
        }

        @Override
        public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().addDomain(domain, credentials);
        }

        @Override
        public boolean removeDomain(@NonNull Domain domain) throws IOException {
            return SystemCredentialsProvider.getInstance().removeDomain(domain);
        }

        @Override
        public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            return SystemCredentialsProvider.getInstance().updateDomain(current, replacement);
        }

        @Override
        public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().addCredentials(domain, credentials);
        }

        @Override
        @Exported
        @NonNull
        public List<Credentials> getCredentials(@NonNull Domain domain) {
            return SystemCredentialsProvider.getInstance().getCredentials(domain);
        }

        @Override
        public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().removeCredentials(domain, credentials);
        }

        @Override
        public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            return SystemCredentialsProvider.getInstance().updateCredentials(domain, current, replacement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ProviderImpl
    extends CredentialsProvider {
        private static final Set<CredentialsScope> SCOPES = Collections.unmodifiableSet(new LinkedHashSet<CredentialsScope>(Arrays.asList(CredentialsScope.GLOBAL, CredentialsScope.SYSTEM)));

        @Override
        public Set<CredentialsScope> getScopes(ModelObject object) {
            if (object instanceof Jenkins || object instanceof SystemCredentialsProvider) {
                return SCOPES;
            }
            return super.getScopes(object);
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
            return this.getCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
            return this.getCredentials(type, item, authentication, Collections.<DomainRequirement>emptyList());
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
            if (ACL.SYSTEM.equals(authentication)) {
                return DomainCredentials.getCredentials(SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, CredentialsMatchers.not(CredentialsMatchers.withScope(CredentialsScope.SYSTEM)));
            }
            return new ArrayList();
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
            if (ACL.SYSTEM.equals(authentication)) {
                CredentialsMatcher matcher = Jenkins.getInstance() == itemGroup ? CredentialsMatchers.always() : CredentialsMatchers.not(CredentialsMatchers.withScope(CredentialsScope.SYSTEM));
                return DomainCredentials.getCredentials(SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, matcher);
            }
            return new ArrayList();
        }

        @Override
        public CredentialsStore getStore(@CheckForNull ModelObject object) {
            if (object == Jenkins.getInstance()) {
                return SystemCredentialsProvider.getInstance().getStore();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SystemCredentialsProvider> {
        public String getDisplayName() {
            return "";
        }
    }
}

