/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;

public class UsernamePasswordCredentialsImpl
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    @NonNull
    private final String username;
    @NonNull
    private final Secret password;

    @DataBoundConstructor
    public UsernamePasswordCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String username, @CheckForNull String password) {
        super(scope, id, description);
        this.username = Util.fixNull((String)username);
        this.password = Secret.fromString((String)password);
    }

    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Extension(ordinal=1.0)
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.UsernamePasswordCredentialsImpl_DisplayName();
        }
    }
}

