/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.NameWith;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsNameProvider<C extends Credentials> {
    @NonNull
    public abstract String getName(@NonNull C var1);

    @NonNull
    public static String name(@NonNull Credentials credentials) {
        Result result = CredentialsNameProvider.name(credentials, credentials.getClass());
        if (result != null) {
            return result.name;
        }
        try {
            return credentials.getDescriptor().getDisplayName();
        }
        catch (AssertionError e) {
            return credentials.getClass().getSimpleName();
        }
    }

    @CheckForNull
    private static Result name(@NonNull Credentials credentials, @NonNull Class<?> clazz) {
        NameWith nameWith = clazz.getAnnotation(NameWith.class);
        if (nameWith != null) {
            try {
                CredentialsNameProvider<? extends Credentials> nameProvider = nameWith.value().newInstance();
                return new Result(nameProvider.getName(credentials), nameWith.priority());
            }
            catch (ClassCastException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        Class<?> supe = clazz.getSuperclass();
        Result result = null;
        if (supe != null && (result = CredentialsNameProvider.name(credentials, supe)) != null) {
            return result;
        }
        for (Class<?> xface : clazz.getInterfaces()) {
            Result _result = CredentialsNameProvider.name(credentials, xface);
            if (_result == null || result != null && result.priority >= _result.priority) continue;
            result = _result;
        }
        return result;
    }

    private static final class Result {
        final String name;
        final int priority;

        Result(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }
    }
}

