/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsSnapshotTaker;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import com.trilead.ssh2.crypto.Base64;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.IOUtils;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CertificateCredentialsImpl
extends BaseStandardCredentials
implements StandardCertificateCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CertificateCredentialsImpl.class.getName());
    private final KeyStoreSource keyStoreSource;
    private final Secret password;
    @GuardedBy(value="this")
    @CheckForNull
    private transient KeyStore keyStore;
    @GuardedBy(value="this")
    private transient long keyStoreLastModified;

    @DataBoundConstructor
    public CertificateCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String password, @NonNull KeyStoreSource keyStoreSource) {
        super(scope, id, description);
        keyStoreSource.getClass();
        this.password = Secret.fromString((String)password);
        this.keyStoreSource = keyStoreSource;
    }

    @NonNull
    public synchronized KeyStore getKeyStore() {
        long lastModified = this.keyStoreSource.getKeyStoreLastModified();
        if (this.keyStore == null || this.keyStoreLastModified < lastModified) {
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance("PKCS12");
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException("PKCS12 is a keystore type per the JLS spec", e);
            }
            try {
                keyStore.load(new ByteArrayInputStream(this.keyStoreSource.getKeyStoreBytes()), CertificateCredentialsImpl.toCharArray(this.password));
            }
            catch (CertificateException e) {
                LOGGER.log(Level.WARNING, "Could not load keystore from " + this.keyStoreSource.toString(), e);
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.WARNING, "Could not load keystore from " + this.keyStoreSource.toString(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not load keystore from " + this.keyStoreSource.toString(), e);
            }
            this.keyStore = keyStore;
            this.keyStoreLastModified = lastModified;
        }
        return this.keyStore;
    }

    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    public boolean isPasswordEmpty() {
        return StringUtils.isEmpty((String)this.password.getPlainText());
    }

    public KeyStoreSource getKeyStoreSource() {
        return this.keyStoreSource;
    }

    private static char[] toCharArray(Secret password) {
        String plainText = Util.fixEmpty((String)password.getPlainText());
        return plainText == null ? null : plainText.toCharArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class CredentialsSnapshotTakerImpl
    extends CredentialsSnapshotTaker<StandardCertificateCredentials> {
        @Override
        public Class<StandardCertificateCredentials> type() {
            return StandardCertificateCredentials.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StandardCertificateCredentials snapshot(StandardCertificateCredentials credentials) {
            if (credentials instanceof CertificateCredentialsImpl) {
                KeyStoreSource keyStoreSource = ((CertificateCredentialsImpl)credentials).getKeyStoreSource();
                if (keyStoreSource.isSnapshotSource()) {
                    return credentials;
                }
                return new CertificateCredentialsImpl(credentials.getScope(), credentials.getId(), credentials.getDescription(), credentials.getPassword().getEncryptedValue(), new UploadedKeyStoreSource(UploadedKeyStoreSource.DescriptorImpl.toSecret(keyStoreSource.getKeyStoreBytes()).getEncryptedValue()));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            char[] password = credentials.getPassword().getPlainText().toCharArray();
            try {
                credentials.getKeyStore().store(bos, password);
                bos.close();
            }
            catch (KeyStoreException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (IOException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (NoSuchAlgorithmException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            catch (CertificateException e) {
                StandardCertificateCredentials standardCertificateCredentials = credentials;
                return standardCertificateCredentials;
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
            return new CertificateCredentialsImpl(credentials.getScope(), credentials.getId(), credentials.getDescription(), credentials.getPassword().getEncryptedValue(), new UploadedKeyStoreSource(UploadedKeyStoreSource.DescriptorImpl.toSecret(bos.toByteArray()).getEncryptedValue()));
        }
    }

    public static class UploadedKeyStoreSource
    extends KeyStoreSource {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterKeyStoreSource.class.getName());
        @CheckForNull
        private final Secret uploadedKeystore;

        @DataBoundConstructor
        public UploadedKeyStoreSource(String uploadedKeystore) {
            this.uploadedKeystore = StringUtils.isBlank((String)uploadedKeystore) ? null : Secret.fromString((String)uploadedKeystore);
        }

        @NonNull
        public byte[] getKeyStoreBytes() {
            return DescriptorImpl.toByteArray(this.uploadedKeystore);
        }

        public long getKeyStoreLastModified() {
            return 0L;
        }

        public String getUploadedKeystore() {
            return this.uploadedKeystore == null ? "" : this.uploadedKeystore.getEncryptedValue();
        }

        public boolean isSnapshotSource() {
            return true;
        }

        public static class Upload {
            private final String divId;
            private final Secret uploadedKeystore;

            public Upload(String divId, Secret uploadedKeystore) {
                this.divId = divId;
                this.uploadedKeystore = uploadedKeystore;
            }

            public String getDivId() {
                return this.divId;
            }

            public Secret getUploadedKeystore() {
                return this.uploadedKeystore;
            }

            public HttpResponse doUpload(StaplerRequest req) throws ServletException, IOException {
                FileItem file = req.getFileItem("certificate.file");
                if (file == null) {
                    throw new ServletException("no file upload");
                }
                return HttpResponses.forwardToView((Object)new Upload(this.getDivId(), DescriptorImpl.toSecret(file.get())), (String)"complete");
            }
        }

        @Extension
        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_UploadedKeyStoreSourceDisplayName();
            }

            public static byte[] toByteArray(Secret secret) {
                if (secret != null) {
                    try {
                        return Base64.decode((char[])secret.getPlainText().toCharArray());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return new byte[0];
            }

            public static Secret toSecret(byte[] contents) {
                return contents == null || contents.length == 0 ? null : Secret.fromString((String)new String(Base64.encode((byte[])contents)));
            }

            public FormValidation doCheckUploadedKeystore(@QueryParameter String value, @QueryParameter String password) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_NoCertificateUploaded());
                }
                return DescriptorImpl.validateCertificateKeystore("PKCS12", DescriptorImpl.toByteArray(Secret.fromString((String)value)), password);
            }

            public Upload getUpload(String divId) {
                return new Upload(divId, null);
            }
        }
    }

    public static class FileOnMasterKeyStoreSource
    extends KeyStoreSource {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(FileOnMasterKeyStoreSource.class.getName());
        private final String keyStoreFile;

        @DataBoundConstructor
        public FileOnMasterKeyStoreSource(String keyStoreFile) {
            this.keyStoreFile = keyStoreFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public byte[] getKeyStoreBytes() {
            byte[] byArray;
            InputStream inputStream = Channel.current() == null ? new FileInputStream(new File(this.keyStoreFile)) : new FilePath((VirtualChannel)Channel.current(), this.keyStoreFile).read();
            try {
                byArray = IOUtils.toByteArray((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not read private key file " + this.keyStoreFile, e);
                    return new byte[0];
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return byArray;
        }

        public long getKeyStoreLastModified() {
            if (Channel.current() == null) {
                return new File(this.keyStoreFile).lastModified();
            }
            try {
                return new FilePath((VirtualChannel)Channel.current(), this.keyStoreFile).lastModified();
            }
            catch (IOException e) {
                return 0L;
            }
            catch (InterruptedException e) {
                return 0L;
            }
        }

        public String getKeyStoreFile() {
            return this.keyStoreFile;
        }

        @Extension
        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_FileOnMasterKeyStoreSourceDisplayName();
            }

            public FormValidation doCheckKeyStoreFile(@QueryParameter String value, @QueryParameter String password) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileUnspecified());
                }
                File file = new File(value);
                if (file.isFile()) {
                    try {
                        return DescriptorImpl.validateCertificateKeystore("PKCS12", FileUtils.readFileToByteArray((File)file), password);
                    }
                    catch (IOException e) {
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileUnreadable(value), (Object[])new Object[]{e});
                    }
                }
                return FormValidation.error((String)Messages.CertificateCredentialsImpl_KeyStoreFileDoesNotExist(value));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class KeyStoreSourceDescriptor
    extends Descriptor<KeyStoreSource> {
        protected KeyStoreSourceDescriptor() {
        }

        protected KeyStoreSourceDescriptor(Class<? extends KeyStoreSource> clazz) {
            super(clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected static FormValidation validateCertificateKeystore(String type, byte[] keystoreBytes, String password) {
            char[] passwordChars = CertificateCredentialsImpl.toCharArray(Secret.fromString((String)password));
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                keyStore.load(new ByteArrayInputStream(keystoreBytes), passwordChars);
                int size = keyStore.size();
                if (size == 0) {
                    FormValidation formValidation = FormValidation.warning((String)Messages.CertificateCredentialsImpl_EmptyKeystore());
                    return formValidation;
                }
                StringBuilder buf = new StringBuilder();
                boolean first = true;
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String alias = enumeration.nextElement();
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(alias);
                    if (keyStore.isCertificateEntry(alias)) {
                        keyStore.getCertificate(alias);
                        continue;
                    }
                    if (!keyStore.isKeyEntry(alias)) continue;
                    try {
                        keyStore.getKey(alias, passwordChars);
                    }
                    catch (UnrecoverableEntryException e) {
                        FormValidation formValidation;
                        block24: {
                            if (passwordChars == null || passwordChars.length == 0) {
                                FormValidation formValidation2 = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeyFailedQueryEmptyPassword(alias));
                                if (passwordChars != null) {
                                    Arrays.fill(passwordChars, ' ');
                                }
                                return formValidation2;
                            }
                            formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeyFailed(alias));
                            if (passwordChars == null) break block24;
                            Arrays.fill(passwordChars, ' ');
                        }
                        return formValidation;
                    }
                }
                FormValidation formValidation = FormValidation.ok((String)StringUtils.defaultIfEmpty((String)StandardCertificateCredentials.NameProvider.getSubjectDN(keyStore), (String)buf.toString()));
                return formValidation;
                {
                    catch (KeyStoreException e) {
                        FormValidation formValidation3 = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                        return formValidation3;
                    }
                    catch (CertificateException e) {
                        FormValidation formValidation4 = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                        return formValidation4;
                    }
                    catch (NoSuchAlgorithmException e) {
                        FormValidation formValidation5 = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                        return formValidation5;
                    }
                    catch (IOException e) {
                        FormValidation formValidation6 = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                        return formValidation6;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (passwordChars != null) {
                    Arrays.fill(passwordChars, ' ');
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class KeyStoreSource
    extends AbstractDescribableImpl<KeyStoreSource>
    implements Serializable {
        @NonNull
        public abstract byte[] getKeyStoreBytes();

        public abstract long getKeyStoreLastModified();

        public boolean isSnapshotSource() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension(ordinal=-1.0)
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.CertificateCredentialsImpl_DisplayName();
        }

        public DescriptorExtensionList<KeyStoreSource, Descriptor<KeyStoreSource>> getKeyStoreSources() {
            return Hudson.getInstance().getDescriptorList(KeyStoreSource.class);
        }

        public CertificateCredentialsImpl fixInstance(CertificateCredentialsImpl instance) {
            if (instance == null) {
                return new CertificateCredentialsImpl(CredentialsScope.GLOBAL, null, "", "", new FileOnMasterKeyStoreSource(""));
            }
            return instance;
        }
    }
}

