/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialsStoreAction
implements Action {
    public static final Permission VIEW = CredentialsProvider.VIEW;
    public static final Permission CREATE = CredentialsProvider.CREATE;
    public static final Permission UPDATE = CredentialsProvider.UPDATE;
    public static final Permission DELETE = CredentialsProvider.DELETE;
    public static final Permission MANAGE_DOMAINS = CredentialsProvider.MANAGE_DOMAINS;

    @NonNull
    public abstract CredentialsStore getStore();

    public String getIconFileName() {
        if (CredentialsProvider.allCredentialsDescriptors().isEmpty()) {
            return null;
        }
        return this.getStore().hasPermission(CredentialsProvider.VIEW) ? "/plugin/credentials/images/48x48/credentials.png" : null;
    }

    public String getDisplayName() {
        return Messages.CredentialsStoreAction_DisplayName();
    }

    public String getUrlName() {
        return "credential-store";
    }

    public final String getFullName() {
        ModelObject context = this.getStore().getContext();
        String n = context instanceof Item ? ((Item)context).getFullName() : (context instanceof ItemGroup ? ((ItemGroup)context).getFullName() : "");
        if (n.length() == 0) {
            return this.getUrlName();
        }
        return n + '/' + this.getUrlName();
    }

    public final String getFullDisplayName() {
        ModelObject context = this.getStore().getContext();
        String n = context instanceof Item ? ((Item)context).getFullDisplayName() : (context instanceof ItemGroup ? ((ItemGroup)context).getFullDisplayName() : Jenkins.getInstance().getFullDisplayName());
        if (n.length() == 0) {
            return this.getDisplayName();
        }
        return n + " \u00bb " + this.getDisplayName();
    }

    @Exported
    public Map<String, DomainWrapper> getDomains() {
        TreeMap<String, DomainWrapper> result = new TreeMap<String, DomainWrapper>();
        for (Domain d : this.getStore().getDomains()) {
            String name = d == Domain.global() ? "_" : d.getName();
            result.put(name, new DomainWrapper(this, d));
        }
        return result;
    }

    public DomainWrapper getDomain(String name) {
        return this.getDomains().get(name);
    }

    public boolean isDomainsModifiable() {
        return this.getStore().isDomainsModifiable();
    }

    public DomainWrapper.DescriptorImpl getDomainDescriptor() {
        return (DomainWrapper.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DomainWrapper.DescriptorImpl.class);
    }

    public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
        return Jenkins.getInstance().getDescriptorList(DomainSpecification.class);
    }

    public HttpResponse doCreateDomain(StaplerRequest req) throws ServletException, IOException {
        if (!"POST".equals(req.getMethod())) {
            return HttpResponses.status((int)405);
        }
        this.getStore().checkPermission(MANAGE_DOMAINS);
        JSONObject data = req.getSubmittedForm();
        Domain domain = (Domain)req.bindJSON(Domain.class, data);
        if (this.getStore().addDomain(domain, new Credentials[0])) {
            return HttpResponses.redirectTo((String)("./domain/" + Util.rawEncode((String)domain.getName())));
        }
        return HttpResponses.redirectToDot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public static class CredentialsWrapper
    extends AbstractDescribableImpl<CredentialsWrapper> {
        private final DomainWrapper domain;
        private final Credentials credentials;
        private final String id;

        public CredentialsWrapper(DomainWrapper domain, Credentials credentials, String id) {
            this.domain = domain;
            this.credentials = credentials;
            this.id = id;
        }

        public String getUrlName() {
            return Util.rawEncode((String)this.id);
        }

        public Api getApi() {
            return new Api((Object)this);
        }

        public String getDisplayName() {
            return CredentialsNameProvider.name(this.credentials);
        }

        @Exported
        public String getTypeName() {
            return this.credentials.getDescriptor().getDisplayName();
        }

        public String getDescription() {
            return this.credentials instanceof StandardCredentials ? ((StandardCredentials)this.credentials).getDescription() : null;
        }

        @Exported
        public final String getFullName() {
            String n = this.getDomain().getFullName();
            if (n.length() == 0) {
                return this.getUrlName();
            }
            return n + '/' + this.getUrlName();
        }

        public final String getFullDisplayName() {
            String n = this.getDomain().getFullDisplayName();
            if (n.length() == 0) {
                return this.getDisplayName();
            }
            return n + " \u00bb " + this.getDisplayName();
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public DomainWrapper getDomain() {
            return this.domain;
        }

        public DomainWrapper getParent() {
            return this.domain;
        }

        public CredentialsStore getStore() {
            return this.domain.getStore();
        }

        public HttpResponse doDoDelete(StaplerRequest req) throws IOException {
            if (!"POST".equals(req.getMethod())) {
                return HttpResponses.status((int)405);
            }
            if (!this.getStore().isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            this.getStore().checkPermission(DELETE);
            if (this.getStore().removeCredentials(this.domain.getDomain(), this.credentials)) {
                return HttpResponses.redirectTo((String)"../..");
            }
            return HttpResponses.redirectToDot();
        }

        public HttpResponse doUpdateSubmit(StaplerRequest req) throws ServletException, IOException {
            if (!"POST".equals(req.getMethod())) {
                return HttpResponses.status((int)405);
            }
            this.getStore().checkPermission(UPDATE);
            JSONObject data = req.getSubmittedForm();
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data);
            if (!this.getStore().updateCredentials(this.domain.domain, this.credentials, credentials)) {
                return HttpResponses.redirectTo((String)"concurrentModification");
            }
            return HttpResponses.redirectToDot();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<CredentialsWrapper> {
            public String getDisplayName() {
                return "Credential";
            }

            public DescriptorExtensionList<Credentials, CredentialsDescriptor> getCredentialDescriptors() {
                return Jenkins.getInstance().getDescriptorList(Credentials.class);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public static class DomainWrapper
    extends AbstractDescribableImpl<DomainWrapper>
    implements ModelObject {
        private final CredentialsStoreAction parent;
        private final Domain domain;

        public DomainWrapper(CredentialsStoreAction parent, Domain domain) {
            this.parent = parent;
            this.domain = domain;
        }

        public Api getApi() {
            return new Api((Object)this);
        }

        public CredentialsStore getStore() {
            return this.getParent().getStore();
        }

        public Domain getDomain() {
            return this.domain;
        }

        public CredentialsStoreAction getParent() {
            return this.parent;
        }

        @Exported
        public String getUrlName() {
            return this.isGlobal() ? "_" : Util.rawEncode((String)this.domain.getName());
        }

        public String getDisplayName() {
            return this.isGlobal() ? Messages.CredentialsStoreAction_GlobalDomainDisplayName() : this.domain.getName();
        }

        @Exported
        public final String getFullName() {
            String n = this.getParent().getFullName();
            if (n.length() == 0) {
                return this.getUrlName();
            }
            return n + '/' + this.getUrlName();
        }

        public final String getFullDisplayName() {
            String n = this.getParent().getFullDisplayName();
            if (n.length() == 0) {
                return this.getDisplayName();
            }
            return n + " \u00bb " + this.getDisplayName();
        }

        public String getDescription() {
            return this.isGlobal() ? Messages.CredentialsStoreAction_GlobalDomainDescription() : this.domain.getDescription();
        }

        @Exported
        public boolean isGlobal() {
            return this.domain == Domain.global();
        }

        public CredentialsWrapper.DescriptorImpl getCredentialDescriptor() {
            return (CredentialsWrapper.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(CredentialsWrapper.DescriptorImpl.class);
        }

        @Exported
        public Map<String, CredentialsWrapper> getCredentials() {
            LinkedHashMap<String, CredentialsWrapper> result = new LinkedHashMap<String, CredentialsWrapper>();
            int index = 0;
            for (Credentials c : this.getStore().getCredentials(this.domain)) {
                String id;
                if (c instanceof IdCredentials) {
                    id = ((IdCredentials)c).getId();
                } else {
                    while (result.containsKey("index-" + index)) {
                        ++index;
                    }
                    id = "index-" + index;
                    ++index;
                }
                result.put(id, new CredentialsWrapper(this, c, id));
            }
            return result;
        }

        public CredentialsWrapper getCredential(String id) {
            return this.getCredentials().get(id);
        }

        public HttpResponse doCreateCredentials(StaplerRequest req) throws ServletException, IOException {
            if (!"POST".equals(req.getMethod())) {
                return HttpResponses.status((int)405);
            }
            this.getStore().checkPermission(CREATE);
            JSONObject data = req.getSubmittedForm();
            Credentials credentials = (Credentials)req.bindJSON(Credentials.class, data.getJSONObject("credentials"));
            this.getStore().addCredentials(this.domain, credentials);
            return HttpResponses.redirectTo((String)("../../domain/" + this.getUrlName()));
        }

        public HttpResponse doConfigSubmit(StaplerRequest req) throws ServletException, IOException {
            if (!"POST".equals(req.getMethod())) {
                return HttpResponses.status((int)405);
            }
            if (!this.getStore().isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            this.getStore().checkPermission(MANAGE_DOMAINS);
            JSONObject data = req.getSubmittedForm();
            Domain domain = (Domain)req.bindJSON(Domain.class, data);
            if (this.getStore().updateDomain(this.domain, domain)) {
                return HttpResponses.redirectTo((String)("../../domain/" + Util.rawEncode((String)domain.getName())));
            }
            return HttpResponses.redirectToDot();
        }

        public HttpResponse doDoDelete(StaplerRequest req) throws IOException {
            if (!"POST".equals(req.getMethod())) {
                return HttpResponses.status((int)405);
            }
            if (!this.getStore().isDomainsModifiable()) {
                return HttpResponses.status((int)400);
            }
            this.getStore().checkPermission(MANAGE_DOMAINS);
            if (this.getStore().removeDomain(this.domain)) {
                return HttpResponses.redirectTo((String)"../..");
            }
            return HttpResponses.redirectToDot();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<DomainWrapper> {
            public DescriptorImpl() {
                super(DomainWrapper.class);
            }

            public String getDisplayName() {
                return "Domain";
            }

            public FormValidation doCheckName(@AncestorInPath DomainWrapper wrapper, @AncestorInPath CredentialsStoreAction action, @QueryParameter String value) {
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.warning((String)Messages.CredentialsStoreAction_EmptyDomainNameMessage());
                }
                try {
                    Jenkins.checkGoodName((String)value);
                }
                catch (Failure e) {
                    return FormValidation.error((String)e.getMessage());
                }
                if (action != null) {
                    for (Domain d : action.getStore().getDomains()) {
                        if (wrapper != null && wrapper.domain == d || !value.equals(d.getName())) continue;
                        return FormValidation.error((String)Messages.CredentialsStoreAction_DuplicateDomainNameMessage());
                    }
                }
                return FormValidation.ok();
            }
        }
    }
}

