/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.credentialsbinding.impl.UnbindableDir;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SSHUserPrivateKeyBinding
extends MultiBinding<SSHUserPrivateKey> {
    public final String keyFileVariable;
    public String usernameVariable;
    public String passphraseVariable;

    @DataBoundConstructor
    public SSHUserPrivateKeyBinding(@Nonnull String keyFileVariable, String credentialsId) {
        super(credentialsId);
        this.keyFileVariable = keyFileVariable;
    }

    @DataBoundSetter
    public void setUsernameVariable(@Nonnull String usernameVariable) {
        this.usernameVariable = usernameVariable;
    }

    @CheckForNull
    public String getUsernameVariable() {
        return this.usernameVariable;
    }

    @DataBoundSetter
    public void setPassphraseVariable(@Nonnull String passphraseVariable) {
        this.passphraseVariable = passphraseVariable;
    }

    @CheckForNull
    public String getPassphraseVariable() {
        return this.passphraseVariable;
    }

    @Override
    protected Class<SSHUserPrivateKey> type() {
        return SSHUserPrivateKey.class;
    }

    @Override
    public Set<String> variables() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.keyFileVariable);
        if (this.usernameVariable != null) {
            set.add(this.usernameVariable);
        }
        if (this.passphraseVariable != null) {
            set.add(this.passphraseVariable);
        }
        return ImmutableSet.copyOf(set);
    }

    @Override
    public MultiBinding.MultiEnvironment bind(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        SSHUserPrivateKey sshKey = (SSHUserPrivateKey)this.getCredentials(build);
        UnbindableDir keyDir = UnbindableDir.create(workspace);
        FilePath keyFile = keyDir.getDirPath().child("ssh-key-" + this.keyFileVariable);
        StringBuilder contents = new StringBuilder();
        for (String key : sshKey.getPrivateKeys()) {
            contents.append(key);
            contents.append('\n');
        }
        keyFile.write(contents.toString(), "UTF-8");
        keyFile.chmod(256);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.keyFileVariable, keyFile.getRemote());
        if (this.passphraseVariable != null) {
            Secret passphrase = sshKey.getPassphrase();
            if (passphrase != null) {
                map.put(this.passphraseVariable, passphrase.getPlainText());
            } else {
                map.put(this.passphraseVariable, "");
            }
        }
        if (this.usernameVariable != null) {
            map.put(this.usernameVariable, sshKey.getUsername());
        }
        return new MultiBinding.MultiEnvironment(map, keyDir.getUnbinder());
    }

    @Symbol(value={"sshUserPrivateKey"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<SSHUserPrivateKey> {
        @Override
        protected Class<SSHUserPrivateKey> type() {
            return SSHUserPrivateKey.class;
        }

        public String getDisplayName() {
            return Messages.SSHUserPrivateKeyBinding_ssh_user_private_key();
        }
    }
}

