/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.masking;

import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatternFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SecretPatterns {
    private static final Comparator<String> BY_LENGTH_DESCENDING = Comparator.comparingInt(String::length).reversed().thenComparing(String::compareTo);

    @Nonnull
    public static Pattern getAggregateSecretPattern(@Nonnull Collection<String> inputs) {
        String pattern = inputs.stream().filter(input -> !input.isEmpty()).flatMap(input -> SecretPatternFactory.all().stream().flatMap(factory -> factory.getEncodedForms((String)input).stream())).sorted(BY_LENGTH_DESCENDING).distinct().map(Pattern::quote).collect(Collectors.joining("|"));
        return Pattern.compile(pattern);
    }
}

