/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.UUID;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.Binding;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.kohsuke.stapler.DataBoundConstructor;

public class FileBinding
extends Binding<FileCredentials> {
    @DataBoundConstructor
    public FileBinding(String variable, String credentialsId) {
        super(variable, credentialsId);
    }

    @Override
    protected Class<FileCredentials> type() {
        return FileCredentials.class;
    }

    @Override
    public Binding.SingleEnvironment bindSingle(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        FileCredentials credentials = (FileCredentials)((MultiBinding)this).getCredentials(build);
        FilePath secrets = FileBinding.secretsDir(workspace);
        String dirName = UUID.randomUUID().toString();
        FilePath dir = secrets.child(dirName);
        dir.mkdirs();
        secrets.chmod(448);
        FilePath secret = dir.child(credentials.getFileName());
        this.copy(secret, credentials);
        if (secret.isDirectory()) {
            secret.chmod(448);
        } else {
            secret.chmod(256);
        }
        return new Binding.SingleEnvironment(secret.getRemote(), new UnbinderImpl(dirName));
    }

    private static FilePath secretsDir(FilePath workspace) {
        return FileBinding.tempDir(workspace).child("secretFiles");
    }

    private static FilePath tempDir(FilePath ws) {
        return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
    }

    protected void copy(FilePath secret, FileCredentials credentials) throws IOException, InterruptedException {
        secret.copyFrom(credentials.getContent());
    }

    @Symbol(value={"file"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<FileCredentials> {
        @Override
        protected Class<FileCredentials> type() {
            return FileCredentials.class;
        }

        public String getDisplayName() {
            return Messages.FileBinding_secret_file();
        }
    }

    private static class UnbinderImpl
    implements MultiBinding.Unbinder {
        private static final long serialVersionUID = 1L;
        private final String dirName;

        UnbinderImpl(String dirName) {
            this.dirName = dirName;
        }

        @Override
        public void unbind(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            FileBinding.secretsDir(workspace).child(this.dirName).deleteRecursive();
        }
    }
}

