/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.cppncss.parser.Statistic;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.DefaultCategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GraphHelper {
    private GraphHelper() {
    }

    public static boolean isGraphUnsupported() {
        return ChartUtil.awtProblemCause != null;
    }

    public static void redirectWhenGraphUnsupported(StaplerResponse rsp, StaplerRequest req) throws IOException {
        rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
    }

    public static JFreeChart buildChart(final AbstractBuild<?, ?> build, final @CheckForNull Integer functionCcnViolationThreshold, final @CheckForNull Integer functionNcssViolationThreshold) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Total Files", (CategoryDataset)GraphHelper.buildDataset(build, new DataCollector(){

            @Override
            public String getTitle() {
                return "Files";
            }

            public long getCollectedNumber(AbstractBuildReport action) {
                return action.getResults().getFileResults().size();
            }
        }), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        DefaultCategoryItemRenderer firstRender = new DefaultCategoryItemRenderer();
        plot.setRenderer((CategoryItemRenderer)firstRender);
        int index = 1;
        GraphHelper.build_category(build, chart, index, Color.BLUE, "Non Commenting Source Statements", new CategoryDatasetBuilder(){

            @Override
            public CategoryDataset buildData() {
                return GraphHelper.buildDataset(build, new DataCollector(){

                    @Override
                    public String getTitle() {
                        return "NCSS";
                    }

                    public long getCollectedNumber(AbstractBuildReport action) {
                        return action.getTotals().getFileTotal().getNcss();
                    }
                });
            }
        });
        GraphHelper.build_category(build, chart, ++index, Color.GREEN, "McCabe's Cyclomatic Number", new CategoryDatasetBuilder(){

            @Override
            public CategoryDataset buildData() {
                return GraphHelper.buildDataset(build, new DataCollector(){

                    @Override
                    public String getTitle() {
                        return "CCN";
                    }

                    public long getCollectedNumber(AbstractBuildReport action) {
                        return action.getTotals().getFileTotal().getCcn();
                    }
                });
            }
        });
        GraphHelper.build_category(build, chart, ++index, Color.ORANGE, "Total Functions", new CategoryDatasetBuilder(){

            @Override
            public CategoryDataset buildData() {
                return GraphHelper.buildDataset(build, new DataCollector(){

                    @Override
                    public String getTitle() {
                        return "Functions";
                    }

                    public long getCollectedNumber(AbstractBuildReport action) {
                        return action.getTotals().getFileTotal().getFunctions();
                    }
                });
            }
        });
        GraphHelper.build_category(build, chart, ++index, Color.CYAN, "CCN Violated Functions", new CategoryDatasetBuilder(){

            @Override
            public CategoryDataset buildData() {
                return GraphHelper.buildDataset(build, new DataCollector(){

                    @Override
                    public String getTitle() {
                        return "CCNVF";
                    }

                    public long getCollectedNumber(AbstractBuildReport action) {
                        Collection<Statistic> functionResults = action.getResults().getFunctionResults();
                        int ccnViolatedFunctions = 0;
                        int threshold = functionCcnViolationThreshold != null ? functionCcnViolationThreshold : 0;
                        for (Statistic statistic : functionResults) {
                            if (statistic.getCcn() <= (long)threshold) continue;
                            ++ccnViolatedFunctions;
                        }
                        return ccnViolatedFunctions;
                    }
                });
            }
        });
        GraphHelper.build_category(build, chart, ++index, Color.MAGENTA, "NCSS Violated Functions", new CategoryDatasetBuilder(){

            @Override
            public CategoryDataset buildData() {
                return GraphHelper.buildDataset(build, new DataCollector(){

                    @Override
                    public String getTitle() {
                        return "NCSSVF";
                    }

                    public long getCollectedNumber(AbstractBuildReport action) {
                        Collection<Statistic> functionResults = action.getResults().getFunctionResults();
                        int ncssViolatedFunctions = 0;
                        int threshold = functionNcssViolationThreshold != null ? functionNcssViolationThreshold : 0;
                        for (Statistic statistic : functionResults) {
                            if (statistic.getNcss() <= (long)threshold) continue;
                            ++ncssViolatedFunctions;
                        }
                        return ncssViolatedFunctions;
                    }
                });
            }
        });
        return chart;
    }

    private static void build_category(AbstractBuild<?, ?> build, JFreeChart chart, int index, Color color, String title, CategoryDatasetBuilder datasetBuilder) {
        NumberAxis axis = new NumberAxis(title);
        axis.setLabelPaint((Paint)color);
        axis.setAxisLinePaint((Paint)color);
        axis.setTickLabelPaint((Paint)color);
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        categoryPlot.setRangeAxis(index, (ValueAxis)axis);
        categoryPlot.setDataset(index, datasetBuilder.buildData());
        categoryPlot.mapDatasetToRangeAxis(index, index);
        categoryPlot.mapDatasetToDomainAxis(index, 0);
        DefaultCategoryItemRenderer rendu = new DefaultCategoryItemRenderer();
        rendu.setBasePaint((Paint)color);
        categoryPlot.setRenderer(index, (CategoryItemRenderer)rendu);
    }

    @Nonnull
    private static CategoryDataset buildDataset(@CheckForNull AbstractBuild<?, ?> build, @Nonnull DataCollector collector) {
        DataSetBuilder builder = new DataSetBuilder();
        if (build != null) {
            for (AbstractBuild lastBuild = build; lastBuild != null; lastBuild = lastBuild.getPreviousBuild()) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(lastBuild);
                AbstractBuildReport action = (AbstractBuildReport)lastBuild.getAction(AbstractBuildReport.class);
                if (action == null) continue;
                builder.add((Number)collector.getCollectedNumber(action), (Comparable)((Object)collector.getTitle()), (Comparable)label);
            }
        }
        return builder.build();
    }

    public static interface DataCollector {
        public long getCollectedNumber(AbstractBuildReport<?> var1);

        public String getTitle();
    }

    public static interface CategoryDatasetBuilder {
        public CategoryDataset buildData();
    }
}

