/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.HealthReport;
import hudson.model.Result;
import hudson.plugins.cppncss.CppNCSSBuildIndividualReport;
import hudson.plugins.cppncss.CppNCSSHealthTarget;
import hudson.plugins.cppncss.parser.Statistic;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class CppNCSSGhostwriter
implements Ghostwriter,
Ghostwriter.MasterGhostwriter,
Ghostwriter.SlaveGhostwriter {
    private final String reportFilenamePattern;
    private final CppNCSSHealthTarget[] targets;
    private final Integer functionCcnViolationThreshold;
    private final Integer functionNcssViolationThreshold;

    public CppNCSSGhostwriter(String reportFilenamePattern, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold, CppNCSSHealthTarget ... targets) {
        this.reportFilenamePattern = reportFilenamePattern;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.targets = targets;
    }

    @Override
    public boolean performFromMaster(AbstractBuild<?, ?> build, FilePath executionRoot, BuildListener listener) throws InterruptedException, IOException {
        if (this.targets != null && this.targets.length > 0) {
            List actions = build.getActions();
            Result buildResult = build.getResult();
            if (buildResult == null) {
                throw new AbortException("Cannot perform publisher for a running job. The plugin needs to be updated to support plugins like Any Build Step. File a JIRA ticket if you need that");
            }
            for (Action action : actions) {
                if (!(action instanceof CppNCSSBuildIndividualReport)) continue;
                CppNCSSBuildIndividualReport cppncssAction = (CppNCSSBuildIndividualReport)action;
                cppncssAction.setBuild(build);
                for (CppNCSSHealthTarget target : this.targets) {
                    Result result = target.evaluateStability(cppncssAction);
                    if (!result.isWorseThan(buildResult)) continue;
                    buildResult = result;
                }
            }
            build.setResult(buildResult);
        }
        return true;
    }

    @Override
    public boolean performFromSlave(BuildProxy build, BuildListener listener) throws InterruptedException, IOException {
        FilePath[] paths = build.getExecutionRootDir().list(this.reportFilenamePattern);
        StatisticsResult results = null;
        HashSet<String> parsedFiles = new HashSet<String>();
        for (FilePath path : paths) {
            String pathStr = path.getRemote();
            if (parsedFiles.contains(pathStr)) continue;
            parsedFiles.add(pathStr);
            try {
                StatisticsResult result = Statistic.parse(new File(pathStr));
                if (results == null) {
                    results = result;
                    continue;
                }
                results = StatisticsResult.merge(results, result);
            }
            catch (XmlPullParserException e) {
                e.printStackTrace(listener.getLogger());
            }
        }
        if (results != null) {
            CppNCSSBuildIndividualReport action = new CppNCSSBuildIndividualReport(results, this.functionCcnViolationThreshold, this.functionNcssViolationThreshold);
            if (this.targets != null && this.targets.length > 0) {
                HealthReport r = null;
                for (CppNCSSHealthTarget target : this.targets) {
                    r = HealthReport.min(r, (HealthReport)target.evaluateHealth(action, "Cpp NCSS Report: "));
                }
                action.setBuildHealth(r);
            }
            build.getActions().add(action);
        }
        return true;
    }
}

