/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.plugins.cppncss.parser.StatisticsTotalResult;
import hudson.plugins.helpers.AbstractProjectAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractProjectReport<T extends AbstractProject<?, ?>>
extends AbstractProjectAction<T>
implements ProminentProjectAction {
    public AbstractProjectReport(T project, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold) {
        super(project, functionCcnViolationThreshold, functionNcssViolationThreshold);
    }

    public String getIconFileName() {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return "graph.gif";
        }
        return null;
    }

    public String getDisplayName() {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return "Cpp NCSS Report";
        }
        return null;
    }

    @Override
    public String getGraphName() {
        return "Cpp NCSS Trend";
    }

    public String getUrlName() {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return "cppncss";
        }
        return null;
    }

    public String getSearchUrl() {
        return "cppncss";
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        AbstractBuild lastBuild = this.getProject().getLastBuild();
        if (lastBuild == null) {
            return;
        }
        Calendar t = lastBuild.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart(lastBuild, this.getFunctionCcnViolationThreshold(), this.getFunctionNcssViolationThreshold()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        AbstractBuild build = this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = build.getPreviousBuild();
        }
        return true;
    }

    public StatisticsResult getResults() {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getResults();
        }
        return new StatisticsResult();
    }

    public StatisticsTotalResult getTotals() {
        for (AbstractBuild build = this.getProject().getLastBuild(); build != null; build = build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getTotals();
        }
        return null;
    }

    protected abstract Class<? extends AbstractBuildReport> getBuildActionClass();

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

