/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck.util;

import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigSeverityEvaluation;
import org.jenkinsci.plugins.cppcheck.util.CppcheckMetricUtil;

public class CppcheckBuildHealthEvaluator {
    public int evaluatBuildHealth(CppcheckConfigSeverityEvaluation severityEvaluation, int nbErrorForSeverity) {
        if (severityEvaluation == null) {
            return -1;
        }
        if (this.isHealthyReportEnabled(severityEvaluation)) {
            int healthyNumber = CppcheckMetricUtil.convert(severityEvaluation.getHealthy());
            int unHealthyNumber = CppcheckMetricUtil.convert(severityEvaluation.getUnHealthy());
            int percentage = nbErrorForSeverity < healthyNumber ? 100 : (nbErrorForSeverity > unHealthyNumber ? 0 : 100 - (nbErrorForSeverity - healthyNumber) * 100 / (unHealthyNumber - healthyNumber));
            return percentage;
        }
        return -1;
    }

    private boolean isHealthyReportEnabled(CppcheckConfigSeverityEvaluation severityEvaluation) {
        if (CppcheckMetricUtil.isValid(severityEvaluation.getHealthy()) && CppcheckMetricUtil.isValid(severityEvaluation.getUnHealthy())) {
            int healthyNumber = CppcheckMetricUtil.convert(severityEvaluation.getHealthy());
            int unHealthyNumber = CppcheckMetricUtil.convert(severityEvaluation.getUnHealthy());
            return unHealthyNumber > healthyNumber;
        }
        return false;
    }
}

