/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck.parser;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.jenkinsci.plugins.cppcheck.model.Error;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jenkinsci.plugins.cppcheck.CppcheckReport;
import org.jenkinsci.plugins.cppcheck.model.Cppcheck;
import org.jenkinsci.plugins.cppcheck.model.Error;
import org.jenkinsci.plugins.cppcheck.model.Errors;
import org.jenkinsci.plugins.cppcheck.model.Results;
import org.jenkinsci.plugins.cppcheck.util.CppcheckLogger;

public class CppcheckParser
implements Serializable {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CppcheckReport parse(File file, TaskListener listener) throws IOException {
        CppcheckReport report;
        if (file == null) {
            throw new IllegalArgumentException("File input is mandatory.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File input " + file.getName() + " must exist.");
        }
        AtomicReference<JAXBContext> jc = new AtomicReference<JAXBContext>();
        try {
            Thread t = Thread.currentThread();
            ClassLoader orig = t.getContextClassLoader();
            t.setContextClassLoader(CppcheckParser.class.getClassLoader());
            try {
                jc.set(JAXBContext.newInstance((Class[])new Class[]{org.jenkinsci.plugins.cppcheck.model.Error.class, Errors.class, Cppcheck.class, Results.class}));
            }
            finally {
                t.setContextClassLoader(orig);
            }
            Unmarshaller unmarshaller = ((JAXBContext)jc.get()).createUnmarshaller();
            Results results = (Results)unmarshaller.unmarshal(file);
            if (results.getCppcheck() == null) {
                throw new JAXBException("Test with version 1");
            }
            report = this.getReportVersion2(results);
        }
        catch (JAXBException jxe) {
            try {
                Thread t = Thread.currentThread();
                ClassLoader orig = t.getContextClassLoader();
                t.setContextClassLoader(CppcheckParser.class.getClassLoader());
                try {
                    jc.set(JAXBContext.newInstance((Class[])new Class[]{Error.class, com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results.class}));
                }
                finally {
                    t.setContextClassLoader(orig);
                }
                Unmarshaller unmarshaller = ((JAXBContext)jc.get()).createUnmarshaller();
                com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results results = (com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results)unmarshaller.unmarshal(file);
                report = this.getReportVersion1(results);
                CppcheckLogger.log(listener, "WARNING: Legacy format of report file detected, please consider to pass additional argument '--xml-version=2' to Cppcheck. It often detects and reports more issues with the new format, so its usage is highly recommended.");
            }
            catch (JAXBException jxe1) {
                throw new IOException(jxe1);
            }
        }
        return report;
    }

    private CppcheckReport getReportVersion1(com.thalesgroup.jenkinsci.plugins.cppcheck.model.Results results) {
        CppcheckReport cppCheckReport = new CppcheckReport();
        ArrayList<CppcheckFile> allErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> warningSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> performanceSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> informationSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategorySeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> portabilitySeverityList = new ArrayList<CppcheckFile>();
        for (int i = 0; i < results.getError().size(); ++i) {
            Error error = results.getError().get(i);
            CppcheckFile cppcheckFile = new CppcheckFile();
            cppcheckFile.setFileName(error.getFile());
            String lineAtr = error.getLine();
            if (lineAtr != null) {
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
            cppcheckFile.setCppCheckId(error.getId());
            cppcheckFile.setSeverity(error.getSeverity());
            cppcheckFile.setMessage(error.getMsg());
            if ("possible error".equals(cppcheckFile.getSeverity())) {
                warningSeverityList.add(cppcheckFile);
            } else if ("style".equals(cppcheckFile.getSeverity())) {
                styleSeverityList.add(cppcheckFile);
            } else if ("possible style".equals(cppcheckFile.getSeverity())) {
                performanceSeverityList.add(cppcheckFile);
            } else if ("error".equals(cppcheckFile.getSeverity())) {
                errorSeverityList.add(cppcheckFile);
            } else {
                noCategorySeverityList.add(cppcheckFile);
            }
            allErrors.add(cppcheckFile);
        }
        cppCheckReport.setAllErrors(allErrors);
        cppCheckReport.setErrorSeverityList(errorSeverityList);
        cppCheckReport.setInformationSeverityList(informationSeverityList);
        cppCheckReport.setNoCategorySeverityList(noCategorySeverityList);
        cppCheckReport.setPerformanceSeverityList(performanceSeverityList);
        cppCheckReport.setStyleSeverityList(styleSeverityList);
        cppCheckReport.setWarningSeverityList(warningSeverityList);
        cppCheckReport.setPortabilitySeverityList(portabilitySeverityList);
        return cppCheckReport;
    }

    private CppcheckReport getReportVersion2(Results results) {
        CppcheckReport cppCheckReport = new CppcheckReport();
        ArrayList<CppcheckFile> allErrors = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> errorSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> warningSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> styleSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> performanceSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> informationSeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> noCategorySeverityList = new ArrayList<CppcheckFile>();
        ArrayList<CppcheckFile> portabilitySeverityList = new ArrayList<CppcheckFile>();
        Errors errors = results.getErrors();
        if (errors != null) {
            for (int i = 0; i < errors.getError().size(); ++i) {
                org.jenkinsci.plugins.cppcheck.model.Error error = errors.getError().get(i);
                CppcheckFile cppcheckFile = new CppcheckFile();
                cppcheckFile.setCppCheckId(error.getId());
                cppcheckFile.setSeverity(error.getSeverity());
                cppcheckFile.setMessage(error.getMsg());
                cppcheckFile.setInconclusive(error.isInconclusive() != null ? error.isInconclusive() : false);
                if (error.getVerbose() != null && !error.getMsg().equals(error.getVerbose())) {
                    cppcheckFile.setVerbose(error.getVerbose());
                }
                if ("warning".equals(cppcheckFile.getSeverity())) {
                    warningSeverityList.add(cppcheckFile);
                } else if ("style".equals(cppcheckFile.getSeverity())) {
                    styleSeverityList.add(cppcheckFile);
                } else if ("performance".equals(cppcheckFile.getSeverity())) {
                    performanceSeverityList.add(cppcheckFile);
                } else if ("error".equals(cppcheckFile.getSeverity())) {
                    errorSeverityList.add(cppcheckFile);
                } else if ("information".equals(cppcheckFile.getSeverity())) {
                    informationSeverityList.add(cppcheckFile);
                } else if ("portability".equals(cppcheckFile.getSeverity())) {
                    portabilitySeverityList.add(cppcheckFile);
                } else {
                    noCategorySeverityList.add(cppcheckFile);
                }
                allErrors.add(cppcheckFile);
                Error.Location location = error.getLocation();
                if (location == null) continue;
                cppcheckFile.setFileName(location.getFile());
                String lineAtr = location.getLine();
                if (lineAtr == null) continue;
                cppcheckFile.setLineNumber(Integer.parseInt(lineAtr));
            }
        }
        cppCheckReport.setAllErrors(allErrors);
        cppCheckReport.setErrorSeverityList(errorSeverityList);
        cppCheckReport.setInformationSeverityList(informationSeverityList);
        cppCheckReport.setNoCategorySeverityList(noCategorySeverityList);
        cppCheckReport.setPerformanceSeverityList(performanceSeverityList);
        cppCheckReport.setStyleSeverityList(styleSeverityList);
        cppCheckReport.setWarningSeverityList(warningSeverityList);
        cppCheckReport.setPortabilitySeverityList(portabilitySeverityList);
        if (results.getCppcheck() != null) {
            cppCheckReport.setVersion(results.getCppcheck().getVersion());
        }
        return cppCheckReport;
    }
}

