/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CppcheckStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int errorCount;
    private final int warningCount;
    private final int styleCount;
    private final int performanceCount;
    private final int informationCount;
    private final int noCategoryCount;
    private final int portabilityCount;
    private final Set<String> versions;

    public CppcheckStatistics() {
        this(0, 0, 0, 0, 0, 0, 0, Collections.emptySet());
    }

    public CppcheckStatistics(int errorCount, int warningCount, int styleCount, int performanceCount, int informationCount, int noCategoryCount, int portabilityCount, Set<String> versions) {
        this.errorCount = errorCount;
        this.warningCount = warningCount;
        this.styleCount = styleCount;
        this.performanceCount = performanceCount;
        this.informationCount = informationCount;
        this.noCategoryCount = noCategoryCount;
        this.portabilityCount = portabilityCount;
        this.versions = versions != null ? new HashSet<String>(versions) : null;
    }

    @Exported
    public int getNumberTotal() {
        return this.errorCount + this.warningCount + this.styleCount + this.performanceCount + this.informationCount + this.noCategoryCount + this.portabilityCount;
    }

    @Exported
    public int getNumberErrorSeverity() {
        return this.errorCount;
    }

    @Exported
    public int getNumberWarningSeverity() {
        return this.warningCount;
    }

    @Exported
    public int getNumberStyleSeverity() {
        return this.styleCount;
    }

    @Exported
    public int getNumberPerformanceSeverity() {
        return this.performanceCount;
    }

    @Exported
    public int getNumberInformationSeverity() {
        return this.informationCount;
    }

    @Exported
    public int getNumberNoCategorySeverity() {
        return this.noCategoryCount;
    }

    @Exported
    public int getNumberPortabilitySeverity() {
        return this.portabilityCount;
    }

    public Set<String> getVersions() {
        return this.versions != null ? Collections.unmodifiableSet(this.versions) : null;
    }

    public String formatDiff(int value) {
        if (value == 0) {
            return "";
        }
        return String.format("%+d", value);
    }
}

