/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class CppcheckSourceAll {
    private final Run<?, ?> owner;
    private final Collection<CppcheckWorkspaceFile> files;
    private final int linesBefore;
    private final int linesAfter;

    public CppcheckSourceAll(Run<?, ?> owner, Collection<CppcheckWorkspaceFile> files, int linesBefore, int linesAfter) {
        this.owner = owner;
        this.files = files;
        this.linesBefore = linesBefore;
        this.linesAfter = linesAfter;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public Collection<CppcheckWorkspaceFile> getFiles() {
        return this.files;
    }

    public int getLinesBefore() {
        return this.linesBefore;
    }

    public int getLinesAfter() {
        return this.linesAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getSourceCode(CppcheckWorkspaceFile file) {
        String string;
        File tempFile = new File(file.getTempName(this.owner));
        if (!tempFile.exists()) {
            return "Can't read file: " + tempFile.getAbsolutePath();
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), StandardCharsets.UTF_8));
            string = this.getRelatedLines(reader, file.getCppcheckFile().getLineNumber());
        }
        catch (FileNotFoundException e) {
            String string2 = "Can't read file: " + e;
            IOUtils.closeQuietly((Reader)reader);
            return string2;
        }
        catch (IOException e2) {
            String string3 = "Reading file failed: " + e2;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)reader);
            return string3;
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    private String getRelatedLines(BufferedReader reader, int lineNumber) throws IOException {
        int start = lineNumber > this.linesBefore ? lineNumber - this.linesBefore : 1;
        int end = lineNumber + this.linesAfter;
        String numberFormat = "%0" + String.valueOf(end).length() + "d";
        StringBuilder builder = new StringBuilder();
        String line = "";
        for (int current = 1; (line = reader.readLine()) != null && current <= end; ++current) {
            if (current < start) continue;
            if (current == lineNumber) {
                builder.append("<div class=\"line highlighted\">");
            } else {
                builder.append("<div class=\"line\">");
            }
            builder.append("<span class=\"lineNumber\">");
            builder.append(String.format(numberFormat, current));
            builder.append("</span> ");
            builder.append(StringEscapeUtils.escapeHtml((String)line));
            builder.append("</div>\n");
        }
        return builder.toString();
    }
}

