/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.CppcheckSource;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckFile;
import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.cppcheck.CppcheckBuildAction;
import org.jenkinsci.plugins.cppcheck.CppcheckDiffState;
import org.jenkinsci.plugins.cppcheck.CppcheckReport;
import org.jenkinsci.plugins.cppcheck.CppcheckSourceAll;
import org.jenkinsci.plugins.cppcheck.CppcheckSourceContainer;
import org.jenkinsci.plugins.cppcheck.CppcheckStatistics;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigSeverityEvaluation;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public class CppcheckResult
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Deprecated
    private CppcheckReport report;
    @Deprecated
    private transient CppcheckSourceContainer cppcheckSourceContainer;
    private transient Run<?, ?> owner;
    private CppcheckStatistics statistics;

    public CppcheckResult(@Nonnull CppcheckStatistics statistics, @Nonnull Run<?, ?> owner) {
        this.statistics = statistics;
        this.owner = owner;
    }

    @Deprecated
    public CppcheckResult(CppcheckReport report, CppcheckSourceContainer cppcheckSourceContainer, Run<?, ?> owner) {
        this.report = report;
        this.cppcheckSourceContainer = cppcheckSourceContainer;
        this.owner = owner;
        this.statistics = report.getStatistics();
    }

    public Api getApi() {
        return new Api((Object)this.getStatistics());
    }

    @Exported
    public CppcheckStatistics getReport() {
        return this.getStatistics();
    }

    @Exported
    public CppcheckStatistics getStatistics() {
        return this.statistics;
    }

    public synchronized Run<?, ?> getOwner() {
        return this.owner;
    }

    public synchronized void setOwner(Run<?, ?> owner) {
        this.owner = owner;
    }

    public CppcheckSourceContainer getCppcheckSourceContainer() {
        return this.lazyLoadSourceContainer();
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) throws IOException {
        if (link.equals("source.all")) {
            if (!this.owner.getParent().getACL().hasPermission(Item.WORKSPACE)) {
                response.sendRedirect2("nosourcepermission");
                return null;
            }
            Set<CppcheckDiffState> filter = this.parseStatesFilter(request.getParameter("states"));
            Collection<CppcheckWorkspaceFile> files = this.diffCurrentAndPrevious(filter);
            int before = this.parseIntWithDefault(request.getParameter("before"), 5);
            int after = this.parseIntWithDefault(request.getParameter("after"), 5);
            return new CppcheckSourceAll(this.owner, files, before, after);
        }
        if (link.startsWith("source.")) {
            if (!this.owner.getParent().getACL().hasPermission(Item.WORKSPACE)) {
                response.sendRedirect2("nosourcepermission");
                return null;
            }
            Map<Integer, CppcheckWorkspaceFile> agregateMap = this.getCppcheckSourceContainer().getInternalMap();
            if (agregateMap != null) {
                CppcheckWorkspaceFile vCppcheckWorkspaceFile = agregateMap.get(Integer.parseInt(StringUtils.substringAfter((String)link, (String)"source.")));
                if (vCppcheckWorkspaceFile == null) {
                    throw new IllegalArgumentException("Error for retrieving the source file with link:" + link);
                }
                return new CppcheckSource(this.owner, vCppcheckWorkspaceFile);
            }
        }
        return null;
    }

    private Set<CppcheckDiffState> parseStatesFilter(String states) {
        if (states == null) {
            return null;
        }
        HashSet<CppcheckDiffState> result = new HashSet<CppcheckDiffState>();
        for (String state : states.toUpperCase().split(",")) {
            try {
                result.add(CppcheckDiffState.valueOf(state));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    private int parseIntWithDefault(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public CppcheckResult getPreviousResult() {
        CppcheckBuildAction previousAction = this.getPreviousAction();
        CppcheckResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    private CppcheckBuildAction getPreviousAction() {
        if (this.owner == null) {
            return null;
        }
        Run previousBuild = this.owner.getPreviousBuild();
        if (previousBuild != null) {
            return (CppcheckBuildAction)previousBuild.getAction(CppcheckBuildAction.class);
        }
        return null;
    }

    public CppcheckStatistics getDiff() {
        CppcheckStatistics current = this.getStatistics();
        CppcheckResult previousResult = this.getPreviousResult();
        if (previousResult == null) {
            return new CppcheckStatistics();
        }
        CppcheckStatistics previous = previousResult.getStatistics();
        return new CppcheckStatistics(current.getNumberErrorSeverity() - previous.getNumberErrorSeverity(), current.getNumberWarningSeverity() - previous.getNumberWarningSeverity(), current.getNumberStyleSeverity() - previous.getNumberStyleSeverity(), current.getNumberPerformanceSeverity() - previous.getNumberPerformanceSeverity(), current.getNumberInformationSeverity() - previous.getNumberInformationSeverity(), current.getNumberNoCategorySeverity() - previous.getNumberNoCategorySeverity(), current.getNumberPortabilitySeverity() - previous.getNumberPortabilitySeverity(), current.getVersions());
    }

    public int getNumberErrorsAccordingConfiguration(CppcheckConfigSeverityEvaluation severityEvaluation, boolean checkNewError) throws IOException {
        CppcheckStatistics prev;
        if (severityEvaluation == null) {
            throw new IOException("[ERROR] - The cppcheck configuration file is missing. Could you save again your job configuration.");
        }
        int nbErrors = 0;
        int nbPreviousError = 0;
        CppcheckResult previousResult = this.getPreviousResult();
        CppcheckStatistics st = this.getStatistics();
        CppcheckStatistics cppcheckStatistics = prev = previousResult != null ? previousResult.getStatistics() : null;
        if (severityEvaluation.isSeverityError()) {
            nbErrors += st.getNumberErrorSeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberErrorSeverity();
            }
        }
        if (severityEvaluation.isSeverityWarning()) {
            nbErrors += st.getNumberWarningSeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberWarningSeverity();
            }
        }
        if (severityEvaluation.isSeverityStyle()) {
            nbErrors += st.getNumberStyleSeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberStyleSeverity();
            }
        }
        if (severityEvaluation.isSeverityPerformance()) {
            nbErrors += st.getNumberPerformanceSeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberPerformanceSeverity();
            }
        }
        if (severityEvaluation.isSeverityInformation()) {
            nbErrors += st.getNumberInformationSeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberInformationSeverity();
            }
        }
        if (severityEvaluation.isSeverityNoCategory()) {
            nbErrors += st.getNumberNoCategorySeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberNoCategorySeverity();
            }
        }
        if (severityEvaluation.isSeverityPortability()) {
            nbErrors += st.getNumberPortabilitySeverity();
            if (previousResult != null) {
                nbPreviousError += prev.getNumberPortabilitySeverity();
            }
        }
        if (checkNewError) {
            if (previousResult != null) {
                return nbErrors - nbPreviousError;
            }
            return 0;
        }
        return nbErrors;
    }

    public Collection<CppcheckWorkspaceFile> diffCurrentAndPrevious(Set<CppcheckDiffState> filter) {
        CppcheckFile prevCppFile;
        CppcheckFile curCppFile;
        CppcheckSourceContainer cur = this.getCppcheckSourceContainer();
        CppcheckResult prevResult = this.getPreviousResult();
        ArrayList<CppcheckWorkspaceFile> curValues = new ArrayList<CppcheckWorkspaceFile>(cur.getInternalMap().values());
        if (prevResult == null) {
            for (CppcheckWorkspaceFile file : curValues) {
                file.setDiffState(CppcheckDiffState.UNCHANGED);
            }
            return this.filterDiffOutput(curValues, filter);
        }
        CppcheckSourceContainer prev = prevResult.getCppcheckSourceContainer();
        Collection<CppcheckWorkspaceFile> prevValues = prev.getInternalMap().values();
        block1: for (CppcheckWorkspaceFile curFile : curValues) {
            curCppFile = curFile.getCppcheckFile();
            for (CppcheckWorkspaceFile prevFile : prevValues) {
                prevCppFile = prevFile.getCppcheckFile();
                if (curCppFile.getLineNumber() != prevCppFile.getLineNumber() || !curCppFile.getFileNameNotNull().equals(prevCppFile.getFileNameNotNull()) || !curCppFile.getMessage().equals(prevCppFile.getMessage())) continue;
                curFile.setDiffState(CppcheckDiffState.UNCHANGED);
                prevFile.setDiffState(CppcheckDiffState.UNCHANGED);
                continue block1;
            }
        }
        block3: for (CppcheckWorkspaceFile curFile : curValues) {
            if (curFile.getDiffState() != null) continue;
            curCppFile = curFile.getCppcheckFile();
            for (CppcheckWorkspaceFile prevFile : prevValues) {
                if (prevFile.getDiffState() != null) continue;
                prevCppFile = prevFile.getCppcheckFile();
                if (!curCppFile.getFileNameNotNull().equals(prevCppFile.getFileNameNotNull()) || !curCppFile.getMessage().equals(prevCppFile.getMessage())) continue;
                curFile.setDiffState(CppcheckDiffState.UNCHANGED);
                prevFile.setDiffState(CppcheckDiffState.UNCHANGED);
                continue block3;
            }
        }
        for (CppcheckWorkspaceFile curFile : curValues) {
            if (curFile.getDiffState() != null) continue;
            curFile.setDiffState(CppcheckDiffState.NEW);
        }
        for (CppcheckWorkspaceFile prevFile : prevValues) {
            if (prevFile.getDiffState() != null) continue;
            prevFile.setDiffState(CppcheckDiffState.SOLVED);
            prevFile.setSourceIgnored(true);
            curValues.add(prevFile);
        }
        Collections.sort(curValues, new Comparator<CppcheckWorkspaceFile>(){

            @Override
            public int compare(CppcheckWorkspaceFile a, CppcheckWorkspaceFile b) {
                return a.getDiffState().ordinal() - b.getDiffState().ordinal();
            }
        });
        return this.filterDiffOutput(curValues, filter);
    }

    private Collection<CppcheckWorkspaceFile> filterDiffOutput(List<CppcheckWorkspaceFile> files, Set<CppcheckDiffState> filter) {
        if (filter == null) {
            return files;
        }
        ArrayList<CppcheckWorkspaceFile> result = new ArrayList<CppcheckWorkspaceFile>();
        for (CppcheckWorkspaceFile file : files) {
            if (!filter.contains((Object)file.getDiffState())) continue;
            result.add(file);
        }
        return result;
    }

    private Object readResolve() {
        if (this.report != null && this.statistics == null) {
            this.statistics = this.report.getStatistics();
        }
        if (this.statistics == null) {
            this.statistics = new CppcheckStatistics();
        }
        return this;
    }

    private CppcheckSourceContainer lazyLoadSourceContainer() {
        if (this.cppcheckSourceContainer != null) {
            return this.cppcheckSourceContainer;
        }
        try {
            if (this.owner != null) {
                XmlFile xmlSourceContainer = null;
                xmlSourceContainer = new XmlFile(new File(this.owner.getRootDir(), "cppcheck_details.xml"));
                return (CppcheckSourceContainer)xmlSourceContainer.read();
            }
            throw new IOException("lazyLoad: Attemped without owner");
        }
        catch (IOException e) {
            return new CppcheckSourceContainer(new HashMap<Integer, CppcheckWorkspaceFile>());
        }
    }
}

