/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.model.CppcheckWorkspaceFile;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.cppcheck.CppcheckBuildAction;
import org.jenkinsci.plugins.cppcheck.CppcheckParserResult;
import org.jenkinsci.plugins.cppcheck.CppcheckReport;
import org.jenkinsci.plugins.cppcheck.CppcheckResult;
import org.jenkinsci.plugins.cppcheck.CppcheckSourceContainer;
import org.jenkinsci.plugins.cppcheck.Messages;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfig;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigGraph;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigSeverityEvaluation;
import org.jenkinsci.plugins.cppcheck.util.CppcheckBuildResultEvaluator;
import org.jenkinsci.plugins.cppcheck.util.CppcheckLogger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CppcheckPublisher
extends Recorder
implements SimpleBuildStep {
    public static final String XML_FILE_DETAILS = "cppcheck_details.xml";
    private CppcheckConfig config;
    @Deprecated
    private CppcheckConfig cppcheckConfig;

    @DataBoundConstructor
    public CppcheckPublisher() {
        this("", false, "", false, "", "", "", "", "", true, true, true, true, true, true, true, 500, 200, 0, true, false, false, false, false, false, false, false);
    }

    @Deprecated
    public CppcheckPublisher(String pattern, boolean ignoreBlankFiles, String threshold, boolean allowNoReport, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, boolean severityError, boolean severityWarning, boolean severityStyle, boolean severityPerformance, boolean severityInformation, boolean severityNoCategory, boolean severityPortability, int xSize, int ySize, int numBuildsInGraph, boolean displayAllErrors, boolean displayErrorSeverity, boolean displayWarningSeverity, boolean displayStyleSeverity, boolean displayPerformanceSeverity, boolean displayInformationSeverity, boolean displayNoCategorySeverity, boolean displayPortabilitySeverity) {
        this.config = new CppcheckConfig();
        this.config.setPattern(pattern);
        this.config.setAllowNoReport(allowNoReport);
        this.config.setIgnoreBlankFiles(ignoreBlankFiles);
        CppcheckConfigSeverityEvaluation configSeverityEvaluation = new CppcheckConfigSeverityEvaluation(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, severityError, severityWarning, severityStyle, severityPerformance, severityInformation, severityNoCategory, severityPortability);
        this.config.setConfigSeverityEvaluation(configSeverityEvaluation);
        CppcheckConfigGraph configGraph = new CppcheckConfigGraph(xSize, ySize, numBuildsInGraph, displayAllErrors, displayErrorSeverity, displayWarningSeverity, displayStyleSeverity, displayPerformanceSeverity, displayInformationSeverity, displayNoCategorySeverity, displayPortabilitySeverity);
        this.config.setConfigGraph(configGraph);
    }

    protected Object readResolve() {
        if (this.cppcheckConfig != null) {
            this.config = this.cppcheckConfig;
        }
        return this;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.config.setPattern(pattern);
    }

    public String getPattern() {
        return this.config.getPattern();
    }

    @DataBoundSetter
    public void setThreshold(String threshold) {
        this.config.getConfigSeverityEvaluation().setThreshold(threshold);
    }

    public String getThreshold() {
        return this.config.getConfigSeverityEvaluation().getThreshold();
    }

    @DataBoundSetter
    public void setNewThreshold(String newThreshold) {
        this.config.getConfigSeverityEvaluation().setNewThreshold(newThreshold);
    }

    public String getNewThreshold() {
        return this.config.getConfigSeverityEvaluation().getNewThreshold();
    }

    @DataBoundSetter
    public void setFailureThreshold(String failureThreshold) {
        this.config.getConfigSeverityEvaluation().setFailureThreshold(failureThreshold);
    }

    public String getFailureThreshold() {
        return this.config.getConfigSeverityEvaluation().getFailureThreshold();
    }

    @DataBoundSetter
    public void setNewFailureThreshold(String newFailureThreshold) {
        this.config.getConfigSeverityEvaluation().setNewFailureThreshold(newFailureThreshold);
    }

    public String getNewFailureThreshold() {
        return this.config.getConfigSeverityEvaluation().getNewFailureThreshold();
    }

    @DataBoundSetter
    public void setHealthy(String healthy) {
        this.config.getConfigSeverityEvaluation().setHealthy(healthy);
    }

    public String getHealthy() {
        return this.config.getConfigSeverityEvaluation().getHealthy();
    }

    @DataBoundSetter
    public void setUnHealthy(String unHealthy) {
        this.config.getConfigSeverityEvaluation().setUnHealthy(unHealthy);
    }

    public String getUnHealthy() {
        return this.config.getConfigSeverityEvaluation().getUnHealthy();
    }

    @DataBoundSetter
    public void setIgnoreBlankFiles(boolean ignoreBlankFiles) {
        this.config.setIgnoreBlankFiles(ignoreBlankFiles);
    }

    public boolean getIgnoreBlankFiles() {
        return this.config.getIgnoreBlankFiles();
    }

    public boolean isIgnoreBlankFiles() {
        return this.config.isIgnoreBlankFiles();
    }

    @DataBoundSetter
    public void setAllowNoReport(boolean allowNoReport) {
        this.config.setAllowNoReport(allowNoReport);
    }

    public boolean getAllowNoReport() {
        return this.config.getAllowNoReport();
    }

    @DataBoundSetter
    public void setSeverityError(boolean severityError) {
        this.config.getConfigSeverityEvaluation().setSeverityError(severityError);
    }

    public boolean getSeverityError() {
        return this.config.getConfigSeverityEvaluation().getSeverityError();
    }

    @DataBoundSetter
    public void setSeverityWarning(boolean severityWarning) {
        this.config.getConfigSeverityEvaluation().setSeverityWarning(severityWarning);
    }

    public boolean getSeverityWarning() {
        return this.config.getConfigSeverityEvaluation().getSeverityWarning();
    }

    @DataBoundSetter
    public void setSeverityStyle(boolean severityStyle) {
        this.config.getConfigSeverityEvaluation().setSeverityStyle(severityStyle);
    }

    public boolean getSeverityStyle() {
        return this.config.getConfigSeverityEvaluation().getSeverityStyle();
    }

    @DataBoundSetter
    public void setSeverityPerformance(boolean severityPerformance) {
        this.config.getConfigSeverityEvaluation().setSeverityPerformance(severityPerformance);
    }

    public boolean getSeverityPerformance() {
        return this.config.getConfigSeverityEvaluation().getSeverityPerformance();
    }

    @DataBoundSetter
    public void setSeverityInformation(boolean severityInformation) {
        this.config.getConfigSeverityEvaluation().setSeverityInformation(severityInformation);
    }

    public boolean getSeverityInformation() {
        return this.config.getConfigSeverityEvaluation().getSeverityInformation();
    }

    @DataBoundSetter
    public void setSeverityNoCategory(boolean severityNoCategory) {
        this.config.getConfigSeverityEvaluation().setSeverityNoCategory(severityNoCategory);
    }

    public boolean getSeverityNoCategory() {
        return this.config.getConfigSeverityEvaluation().getSeverityNoCategory();
    }

    @DataBoundSetter
    public void setSeverityPortability(boolean severityPortability) {
        this.config.getConfigSeverityEvaluation().setSeverityPortability(severityPortability);
    }

    public boolean getSeverityPortability() {
        return this.config.getConfigSeverityEvaluation().getSeverityPortability();
    }

    @DataBoundSetter
    public void setDisplayAllErrors(boolean displayAllErrors) {
        this.config.getConfigGraph().setDisplayAllErrors(displayAllErrors);
    }

    public boolean getDisplayAllErrors() {
        return this.config.getConfigGraph().getDisplayAllErrors();
    }

    @DataBoundSetter
    public void setDisplayErrorSeverity(boolean displayErrorSeverity) {
        this.config.getConfigGraph().setDisplayErrorSeverity(displayErrorSeverity);
    }

    public boolean getDisplayErrorSeverity() {
        return this.config.getConfigGraph().getDisplayErrorSeverity();
    }

    @DataBoundSetter
    public void setDisplayWarningSeverity(boolean displayWarningSeverity) {
        this.config.getConfigGraph().setDisplayWarningSeverity(displayWarningSeverity);
    }

    public boolean getDisplayWarningSeverity() {
        return this.config.getConfigGraph().getDisplayWarningSeverity();
    }

    @DataBoundSetter
    public void setDisplayStyleSeverity(boolean displayStyleSeverity) {
        this.config.getConfigGraph().setDisplayStyleSeverity(displayStyleSeverity);
    }

    public boolean getDisplayStyleSeverity() {
        return this.config.getConfigGraph().getDisplayStyleSeverity();
    }

    @DataBoundSetter
    public void setDisplayPerformanceSeverity(boolean displayPerformanceSeverity) {
        this.config.getConfigGraph().setDisplayPerformanceSeverity(displayPerformanceSeverity);
    }

    public boolean getDisplayPerformanceSeverity() {
        return this.config.getConfigGraph().getDisplayPerformanceSeverity();
    }

    @DataBoundSetter
    public void setDisplayNoCategorySeverity(boolean displayNoCategorySeverity) {
        this.config.getConfigGraph().setDisplayNoCategorySeverity(displayNoCategorySeverity);
    }

    public boolean getDisplayNoCategorySeverity() {
        return this.config.getConfigGraph().getDisplayNoCategorySeverity();
    }

    @DataBoundSetter
    public void setDisplayPortabilitySeverity(boolean displayPortabilitySeverity) {
        this.config.getConfigGraph().setDisplayPortabilitySeverity(displayPortabilitySeverity);
    }

    public boolean getDisplayPortabilitySeverity() {
        return this.config.getConfigGraph().getDisplayPortabilitySeverity();
    }

    @DataBoundSetter
    public void setXSize(int xSize) {
        this.config.getConfigGraph().setXSize(xSize);
    }

    public int getXSize() {
        return this.config.getConfigGraph().getXSize();
    }

    @DataBoundSetter
    public void setYSize(int ySize) {
        this.config.getConfigGraph().setYSize(ySize);
    }

    public int getYSize() {
        return this.config.getConfigGraph().getYSize();
    }

    @DataBoundSetter
    public void setNumBuildsInGraph(int numBuildsInGraph) {
        this.config.getConfigGraph().setNumBuildsInGraph(numBuildsInGraph);
    }

    public int getNumBuildsInGraph() {
        return this.config.getConfigGraph().getNumBuildsInGraph();
    }

    @Deprecated
    public CppcheckPublisher(CppcheckConfig config) {
        this.config = config;
    }

    public CppcheckConfig getCppcheckConfig() {
        return this.config;
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            CppcheckConfigSeverityEvaluation severityEvaluation;
            CppcheckReport cppcheckReport;
            CppcheckLogger.log(listener, "Starting the cppcheck analysis.");
            EnvVars env = build.getEnvironment(listener);
            String expandedPattern = env.expand(this.config.getPattern());
            CppcheckParserResult parser = new CppcheckParserResult(listener, expandedPattern, this.config.isIgnoreBlankFiles());
            try {
                cppcheckReport = (CppcheckReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (Exception e) {
                CppcheckLogger.log(listener, "Error on cppcheck analysis: " + e);
                build.setResult(Result.FAILURE);
                return;
            }
            if (cppcheckReport == null) {
                if (this.config.getAllowNoReport()) {
                    return;
                }
                build.setResult(Result.FAILURE);
                return;
            }
            CppcheckSourceContainer cppcheckSourceContainer = new CppcheckSourceContainer(listener, workspace, workspace, cppcheckReport.getAllErrors());
            CppcheckResult result = new CppcheckResult(cppcheckReport.getStatistics(), build);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult(listener, result.getNumberErrorsAccordingConfiguration(severityEvaluation = this.config.getConfigSeverityEvaluation(), false), result.getNumberErrorsAccordingConfiguration(severityEvaluation, true), severityEvaluation);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            CppcheckBuildAction buildAction = new CppcheckBuildAction(build, result, this.config, CppcheckBuildAction.computeHealthReportPercentage(result, severityEvaluation));
            build.addAction((Action)buildAction);
            XmlFile xmlSourceContainer = new XmlFile(new File(build.getRootDir(), XML_FILE_DETAILS));
            xmlSourceContainer.write((Object)cppcheckSourceContainer);
            this.copyFilesToBuildDirectory(build.getRootDir(), launcher.getChannel(), cppcheckSourceContainer.getInternalMap().values());
            CppcheckLogger.log(listener, "Ending the cppcheck analysis.");
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (this.canContinue(build.getResult())) {
            CppcheckConfigSeverityEvaluation severityEvaluation;
            CppcheckLogger.log(listener, "Starting the cppcheck analysis.");
            EnvVars env = build.getEnvironment((TaskListener)listener);
            String expandedPattern = env.expand(this.config.getPattern());
            CppcheckParserResult parser = new CppcheckParserResult((TaskListener)listener, expandedPattern, this.config.isIgnoreBlankFiles());
            CppcheckReport cppcheckReport = null;
            try {
                FilePath oWorkspacePath = build.getWorkspace();
                if (oWorkspacePath != null) {
                    cppcheckReport = (CppcheckReport)oWorkspacePath.act((FilePath.FileCallable)parser);
                }
            }
            catch (Exception e) {
                CppcheckLogger.log(listener, "Error on cppcheck analysis: " + e);
                build.setResult(Result.FAILURE);
                return false;
            }
            if (cppcheckReport == null) {
                if (this.config.getAllowNoReport()) {
                    return true;
                }
                build.setResult(Result.FAILURE);
                return false;
            }
            CppcheckSourceContainer cppcheckSourceContainer = new CppcheckSourceContainer((TaskListener)listener, build.getWorkspace(), build.getModuleRoot(), cppcheckReport.getAllErrors());
            CppcheckResult result = new CppcheckResult(cppcheckReport.getStatistics(), (Run<?, ?>)build);
            Result buildResult = new CppcheckBuildResultEvaluator().evaluateBuildResult((TaskListener)listener, result.getNumberErrorsAccordingConfiguration(severityEvaluation = this.config.getConfigSeverityEvaluation(), false), result.getNumberErrorsAccordingConfiguration(severityEvaluation, true), severityEvaluation);
            if (buildResult != Result.SUCCESS) {
                build.setResult(buildResult);
            }
            CppcheckBuildAction buildAction = new CppcheckBuildAction((Run<?, ?>)build, result, this.config, CppcheckBuildAction.computeHealthReportPercentage(result, severityEvaluation));
            build.addAction((Action)buildAction);
            XmlFile xmlSourceContainer = new XmlFile(new File(build.getRootDir(), XML_FILE_DETAILS));
            xmlSourceContainer.write((Object)cppcheckSourceContainer);
            this.copyFilesToBuildDirectory(build.getRootDir(), launcher.getChannel(), cppcheckSourceContainer.getInternalMap().values());
            CppcheckLogger.log(listener, "Ending the cppcheck analysis.");
        }
        return true;
    }

    private void copyFilesToBuildDirectory(File rootDir, VirtualChannel channel, Collection<CppcheckWorkspaceFile> sourcesFiles) throws IOException, InterruptedException {
        File directory = new File(rootDir, "workspace-files");
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Can't create directory for copy of workspace files: " + directory.getAbsolutePath());
        }
        for (CppcheckWorkspaceFile file : sourcesFiles) {
            File masterFile;
            if (file.isSourceIgnored() || (masterFile = new File(directory, file.getTempName())).exists()) continue;
            FileOutputStream outputStream = new FileOutputStream(masterFile);
            new FilePath(channel, file.getFileName()).copyTo((OutputStream)outputStream);
        }
    }

    @Extension
    @Symbol(value={"publishCppcheck"})
    public static final class CppcheckDescriptor
    extends BuildStepDescriptor<Publisher> {
        public CppcheckDescriptor() {
            super(CppcheckPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.cppcheck_PublishResults();
        }

        public String getFunctionName() {
            return "publishCppcheck";
        }

        public final String getHelpFile() {
            return this.getPluginRoot() + "help.html";
        }

        public String getPluginRoot() {
            return "/plugin/cppcheck/";
        }

        public CppcheckConfig getConfig() {
            return new CppcheckConfig();
        }
    }
}

