/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.graph.CppcheckGraph;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.Calendar;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.cppcheck.CppcheckBuildAction;
import org.jenkinsci.plugins.cppcheck.CppcheckStatistics;
import org.jenkinsci.plugins.cppcheck.Messages;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigGraph;
import org.jenkinsci.plugins.cppcheck.util.AbstractCppcheckProjectAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CppcheckProjectAction
extends AbstractCppcheckProjectAction {
    @Override
    public String getSearchUrl() {
        return this.getUrlName();
    }

    public CppcheckProjectAction(@Nonnull Job<?, ?> job) {
        super(job);
    }

    @Override
    public Run<?, ?> getLastFinishedBuild() {
        Run lastBuild;
        for (lastBuild = this.getJob().getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(CppcheckBuildAction.class) == null); lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    @Override
    public Run<?, ?> getLastResultBuild() {
        for (Run b = this.getJob().getLastBuild(); b != null; b = b.getPreviousBuiltBuild()) {
            CppcheckBuildAction r = (CppcheckBuildAction)b.getAction(CppcheckBuildAction.class);
            if (r == null) continue;
            return b;
        }
        return null;
    }

    public final boolean isDisplayGraph() {
        Run b = this.getLastFinishedBuild();
        if (b == null) {
            return false;
        }
        for (b = b.getPreviousBuild(); b != null; b = b.getPreviousBuild()) {
            CppcheckBuildAction action;
            if (b.getResult() == null || b.getResult().isWorseOrEqualTo(Result.FAILURE) || (action = (CppcheckBuildAction)b.getAction(CppcheckBuildAction.class)) == null || action.getResult() == null || action.getConfig() == null || action.getConfig().getConfigGraph() == null) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return Messages.cppcheck_CppcheckResults();
    }

    public String getUrlName() {
        return "cppcheckResult";
    }

    @Override
    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        CppcheckConfigGraph configGraph;
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        Calendar timestamp = lastBuild.getTimestamp();
        if (req.checkIfModified(timestamp, rsp)) {
            return;
        }
        Run<?, ?> lastBuildWithResult = this.getLastResultBuild();
        CppcheckBuildAction lastAction = (CppcheckBuildAction)lastBuildWithResult.getAction(CppcheckBuildAction.class);
        CppcheckConfigGraph cppcheckConfigGraph = lastAction != null ? (lastAction.getConfig() != null ? lastAction.getConfig().getConfigGraph() : null) : (configGraph = null);
        if (configGraph == null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        CppcheckGraph g = new CppcheckGraph(lastBuild, this.getDataSetBuilder(configGraph).build(), Messages.cppcheck_NumberOfErrors(), configGraph.getXSize(), configGraph.getYSize());
        g.doPng(req, rsp);
    }

    private DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> getDataSetBuilder(CppcheckConfigGraph configGraph) {
        DataSetBuilder dsb = new DataSetBuilder();
        if (configGraph == null) {
            return dsb;
        }
        Run<?, ?> lastBuild = this.getLastFinishedBuild();
        CppcheckBuildAction lastAction = (CppcheckBuildAction)lastBuild.getAction(CppcheckBuildAction.class);
        int numBuilds = 0;
        for (CppcheckBuildAction a = lastAction; a != null && (configGraph.getNumBuildsInGraph() <= 1 || numBuilds < configGraph.getNumBuildsInGraph()); a = (CppcheckBuildAction)((Object)a.getPreviousResult()), ++numBuilds) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getOwner());
            CppcheckStatistics statistics = a.getResult().getStatistics();
            if (configGraph.isDisplayErrorSeverity()) {
                dsb.add((Number)statistics.getNumberErrorSeverity(), (Comparable)((Object)Messages.cppcheck_Error()), (Comparable)label);
            }
            if (configGraph.isDisplayWarningSeverity()) {
                dsb.add((Number)statistics.getNumberWarningSeverity(), (Comparable)((Object)Messages.cppcheck_Warning()), (Comparable)label);
            }
            if (configGraph.isDisplayStyleSeverity()) {
                dsb.add((Number)statistics.getNumberStyleSeverity(), (Comparable)((Object)Messages.cppcheck_Style()), (Comparable)label);
            }
            if (configGraph.isDisplayPerformanceSeverity()) {
                dsb.add((Number)statistics.getNumberPerformanceSeverity(), (Comparable)((Object)Messages.cppcheck_Performance()), (Comparable)label);
            }
            if (configGraph.isDisplayInformationSeverity()) {
                dsb.add((Number)statistics.getNumberInformationSeverity(), (Comparable)((Object)Messages.cppcheck_Information()), (Comparable)label);
            }
            if (configGraph.isDisplayNoCategorySeverity()) {
                dsb.add((Number)statistics.getNumberNoCategorySeverity(), (Comparable)((Object)Messages.cppcheck_NoCategory()), (Comparable)label);
            }
            if (configGraph.isDisplayPortabilitySeverity()) {
                dsb.add((Number)statistics.getNumberPortabilitySeverity(), (Comparable)((Object)Messages.cppcheck_Portability()), (Comparable)label);
            }
            if (!configGraph.isDisplayAllErrors()) continue;
            dsb.add((Number)statistics.getNumberTotal(), (Comparable)((Object)Messages.cppcheck_AllErrors()), (Comparable)label);
        }
        return dsb;
    }
}

