/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.security.Roles;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.jenkinsci.plugins.cppcheck.CppcheckReport;
import org.jenkinsci.plugins.cppcheck.parser.CppcheckParser;
import org.jenkinsci.plugins.cppcheck.util.CppcheckLogger;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class CppcheckParserResult
implements FilePath.FileCallable<CppcheckReport> {
    private static final long serialVersionUID = 1L;
    private final TaskListener listener;
    private final String cppcheckReportPattern;
    private final boolean ignoreBlankFiles;
    public static final String DEFAULT_REPORT_MAVEN = "**/cppcheck-result.xml";

    public CppcheckParserResult(TaskListener listener, String cppcheckReportPattern, boolean ignoreBlankFiles) {
        if (cppcheckReportPattern == null) {
            cppcheckReportPattern = DEFAULT_REPORT_MAVEN;
        }
        if (cppcheckReportPattern.trim().length() == 0) {
            cppcheckReportPattern = DEFAULT_REPORT_MAVEN;
        }
        this.listener = listener;
        this.cppcheckReportPattern = cppcheckReportPattern;
        this.ignoreBlankFiles = ignoreBlankFiles;
    }

    public CppcheckReport invoke(File basedir, VirtualChannel channel) throws IOException {
        CppcheckReport cppcheckReportResult = new CppcheckReport();
        try {
            String[] cppcheckReportFiles = this.findCppcheckReports(basedir);
            if (cppcheckReportFiles.length == 0) {
                String msg = "No cppcheck test report file(s) were found with the pattern '" + this.cppcheckReportPattern + "' relative to '" + basedir + "'.  Did you enter a pattern relative to the correct directory?  Did you generate the XML report(s) for Cppcheck?";
                CppcheckLogger.log(this.listener, msg);
                throw new IllegalArgumentException(msg);
            }
            CppcheckLogger.log(this.listener, "Processing " + cppcheckReportFiles.length + " files with the pattern '" + this.cppcheckReportPattern + "'.");
            for (String cppcheckReportFileName : cppcheckReportFiles) {
                CppcheckReport cppcheckReport = new CppcheckParser().parse(new File(basedir, cppcheckReportFileName), this.listener);
                CppcheckParserResult.mergeReport(cppcheckReportResult, cppcheckReport);
            }
        }
        catch (Exception e) {
            String stack_trace = ExceptionUtils.getStackTrace((Throwable)e);
            CppcheckLogger.log(this.listener, "Parsing throws exceptions. " + e.getMessage());
            CppcheckLogger.log(this.listener, stack_trace);
            return null;
        }
        return cppcheckReportResult;
    }

    private static void mergeReport(CppcheckReport cppcheckReportResult, CppcheckReport cppcheckReport) {
        cppcheckReportResult.getErrorSeverityList().addAll(cppcheckReport.getErrorSeverityList());
        cppcheckReportResult.getWarningSeverityList().addAll(cppcheckReport.getWarningSeverityList());
        cppcheckReportResult.getStyleSeverityList().addAll(cppcheckReport.getStyleSeverityList());
        cppcheckReportResult.getPerformanceSeverityList().addAll(cppcheckReport.getPerformanceSeverityList());
        cppcheckReportResult.getInformationSeverityList().addAll(cppcheckReport.getInformationSeverityList());
        cppcheckReportResult.getNoCategorySeverityList().addAll(cppcheckReport.getNoCategorySeverityList());
        cppcheckReportResult.getPortabilitySeverityList().addAll(cppcheckReport.getPortabilitySeverityList());
        cppcheckReportResult.getAllErrors().addAll(cppcheckReport.getAllErrors());
        cppcheckReportResult.getVersions().add(cppcheckReport.getVersion());
    }

    private String[] findCppcheckReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.cppcheckReportPattern);
        if (this.ignoreBlankFiles) {
            fs.add(new FileSelector(){

                public boolean isSelected(File basedir, String filename, File file) throws BuildException {
                    return file != null && file.length() != 0L;
                }
            });
        }
        DirectoryScanner ds = fs.getDirectoryScanner();
        return ds.getIncludedFiles();
    }

    public String getCppcheckReportPattern() {
        return this.cppcheckReportPattern;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
        checker.check((RoleSensitive)this, Roles.SLAVE);
    }
}

