/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.cppcheck;

import com.thalesgroup.hudson.plugins.cppcheck.util.AbstractCppcheckBuildAction;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.cppcheck.CppcheckProjectAction;
import org.jenkinsci.plugins.cppcheck.CppcheckResult;
import org.jenkinsci.plugins.cppcheck.Messages;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfig;
import org.jenkinsci.plugins.cppcheck.config.CppcheckConfigSeverityEvaluation;
import org.jenkinsci.plugins.cppcheck.util.CppcheckBuildHealthEvaluator;

public class CppcheckBuildAction
extends AbstractCppcheckBuildAction
implements SimpleBuildStep.LastBuildAction {
    public static final String URL_NAME = "cppcheckResult";
    private final CppcheckResult result;
    private final CppcheckConfig config;
    private int healthReportPercentage;
    @Deprecated
    private Run<?, ?> build;
    @Deprecated
    private CppcheckConfig cppcheckConfig;

    public CppcheckBuildAction(@Nonnull Run<?, ?> owner, @Nonnull CppcheckResult result, @Nonnull CppcheckConfig config, int healthReportPercentage) {
        super(owner);
        this.result = result;
        this.config = config;
        this.healthReportPercentage = healthReportPercentage;
    }

    public String getIconFileName() {
        return "/plugin/cppcheck/icons/cppcheck-24.png";
    }

    public String getDisplayName() {
        return Messages.cppcheck_CppcheckResults();
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public CppcheckResult getResult() {
        return this.result;
    }

    public CppcheckConfig getConfig() {
        return this.config;
    }

    Run<?, ?> getBuild() {
        return this.owner;
    }

    public Object getTarget() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        if (this.healthReportPercentage >= 0 && this.healthReportPercentage <= 100) {
            return new HealthReport(this.healthReportPercentage, Messages._cppcheck_BuildStability());
        }
        return null;
    }

    public static int computeHealthReportPercentage(CppcheckResult result, CppcheckConfigSeverityEvaluation severityEvaluation) {
        try {
            return new CppcheckBuildHealthEvaluator().evaluatBuildHealth(severityEvaluation, result.getNumberErrorsAccordingConfiguration(severityEvaluation, false));
        }
        catch (IOException e) {
            return -1;
        }
    }

    private Object readResolve() {
        if (this.build != null) {
            this.owner = this.build;
        }
        if (this.cppcheckConfig != null) {
            this.healthReportPercentage = 100;
        }
        return this;
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.owner == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(new CppcheckProjectAction(this.owner.getParent()));
    }

    @Override
    public synchronized void setOwner(Run<?, ?> owner) {
        super.setOwner(owner);
        this.result.setOwner(owner);
    }
}

